/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.bean.OddRedirectEntity;
import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddRedirectService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="oddService")
public class OddServiceImpl
extends BaseServiceImpl<OddMapper, OddEntity>
implements IOddService {
    private static final String ODD_CODE = "ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;

    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "add";
        }
        CommonResponse orgVo = this.orgApi.getOneById(entity.getOrgId());
        if (!orgVo.isSuccess()) {
            return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setCropSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        if (entity.getSourceType() == 0 && entity.getOddStatus() == 1) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)1);
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getOddApplyId());
            this.oddApplyService.update((Wrapper)updateWrapper);
        }
        List oddInfoEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getOddInfoEntities(), OddInfoEntity.class);
        List attachIds = saveorUpdateVO.getAttachIds();
        super.saveOrUpdate((Object)entity);
        if (attachIds != null && attachIds.size() > 0) {
            this.fileApi.updateAttachRef(entity.getId(), attachIds);
        }
        this.saveDetails(oddInfoEntities, entity.getId(), operateType);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    private void saveDetails(List<OddInfoEntity> infoList, Long oddId, String operateType) {
        if ("edit".equals(operateType)) {
            this.redirectService.remove((Wrapper)new QueryWrapper().eq((Object)"odd_id", (Object)oddId));
        }
        ArrayList<OddRedirectEntity> saveRedirects = new ArrayList<OddRedirectEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (OddInfoEntity info : infoList) {
            List<OddRedirectEntity> list;
            if ("add".equals(info.getRowState())) {
                info.setOddId(oddId);
                list = info.getOddRedirectEntities();
                this.oddInfoService.save((Object)info);
                if (list == null || list.size() <= 0) continue;
                for (OddRedirectEntity re : list) {
                    re.setInfoId(info.getId());
                    re.setOddId(oddId);
                    saveRedirects.add(re);
                }
                continue;
            }
            if ("edit".equals(info.getRowState())) {
                list = info.getOddRedirectEntities();
                this.oddInfoService.updateById((Object)info);
                if (list == null || list.size() <= 0) continue;
                for (OddRedirectEntity re : list) {
                    re.setInfoId(info.getId());
                    re.setOddId(oddId);
                    saveRedirects.add(re);
                }
                continue;
            }
            if (!"del".equals(info.getRowState())) continue;
            deleteIds.add(info.getId());
        }
        if (saveRedirects.size() > 0) {
            this.redirectService.saveBatch(saveRedirects);
        }
        if (deleteIds.size() > 0) {
            this.oddInfoService.removeByIds(deleteIds, false);
        }
    }

    @Override
    public void del(List<OddVO> vos) {
        List list = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("eq", list));
        List oddEntities = super.queryList(queryParam, false);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (OddEntity entity : oddEntities) {
            if (entity.getSourceType() != 0) continue;
            ids.add(entity.getOddApplyId());
        }
        if (ids.size() > 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)1);
            updateWrapper.in(BaseEntity::getId, ids);
            this.oddApplyService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public OddVO queryDetail(Long id) {
        OddEntity entity = (OddEntity)((Object)this.selectById(id));
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = (OddVO)BeanMapper.map((Object)((Object)entity), OddVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam = null;
            for (OddInfoVO infovo : oddInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter("eq", (Object)infovo.getId()));
                List redirectEntities = this.redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList((Iterable)redirectEntities, OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }
}

