package com.ejianc.business.fbxt.grap.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("sumGrap") 
public class SumGrapBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IGrapService grapService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("--> 进度台账提交开始");
		LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(GrapEntity::getSumGrapId, billId);
		updateWrapper.set(GrapEntity::getUseState, 1);
		grapService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--> 进度台账审核开始");
		LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(GrapEntity::getSumGrapId, billId);
		updateWrapper.set(GrapEntity::getUseState, 1);
		grapService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--> 进度台账撤回开始");
		LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(GrapEntity::getSumGrapId, billId);
		updateWrapper.set(GrapEntity::getUseState, 0);
		grapService.update(updateWrapper);
		return CommonResponse.success();
	}

}
