package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("oddApply") 
public class OddApplyBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOddApplyService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		// 暂存提交需要修改暂存状态
		LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(OddApplyEntity::getOddStatus,1);
		updateWrapper.eq(OddApplyEntity::getId,billId);
		service.update(updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(state == 0){//0是直审，2是有审批流
			LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.set(OddApplyEntity::getOddStatus,1);
			updateWrapper.eq(OddApplyEntity::getId,billId);
			service.update(updateWrapper);
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//1是直审，2是有审批流
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
