package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.bean.OddRedirectEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddRedirectService;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.service.IOddService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 零星用工实体
 * 
 * @author generator
 * 
 */
@Service("oddService")
public class OddServiceImpl extends BaseServiceImpl<OddMapper, OddEntity> implements IOddService{
    private static final String ODD_CODE = "ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;
    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ODD_CODE,tenantId);
                if(billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "add";
        }

        CommonResponse<OrgVO> orgVo = orgApi.getOneById(entity.getOrgId());
        if(!orgVo.isSuccess()) {
            return CommonResponse.error("列表查询失败, 查询组织信息失败！");
        }
        if(null!=orgVo.getData()){
            entity.setCropSourceId(orgVo.getData().getSourceId());
        }

        List<OddInfoEntity> oddInfoEntities = BeanMapper.mapList(saveorUpdateVO.getOddInfoEntities(),OddInfoEntity.class);
        List<Long> fileIds = saveorUpdateVO.getFileIds();
        super.saveOrUpdate(entity);
        //零星用工自由态即回写 ，暂存不回写  删除时释放
        if(entity.getSourceType() == 0 && entity.getOddStatus()==1){
            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag,1);
            updateWrapper.set(OddApplyEntity::getOddId,entity.getId());
            updateWrapper.eq(OddApplyEntity::getId,entity.getOddApplyId());
            oddApplyService.update(updateWrapper);
        }
        if(fileIds!=null&&fileIds.size()>0){
            fileApi.updateAttachRef(entity.getId(),fileIds);
        }
        saveDetails(oddInfoEntities,entity.getId(),operateType);
        return CommonResponse.success("保存或修改单据成功！",this.queryDetail(entity.getId()));
    }
    private void saveDetails(List<OddInfoEntity> infoList,Long oddId,String operateType){
        if("edit".equals(operateType)){
            //删除所有
            redirectService.remove(new QueryWrapper<OddRedirectEntity>().eq("odd_id", oddId));
        }
        List<OddRedirectEntity> saveRedirects = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(OddInfoEntity info:infoList){
            if("add".equals(info.getRowState())) {
                info.setOddId(oddId);
                List<OddRedirectEntity> list = info.getOddRedirectEntities();
                oddInfoService.save(info);
                if(list!=null&&list.size()>0){
                    for(OddRedirectEntity re:list){
                        re.setInfoId(info.getId());
                        re.setOddId(oddId);
                        re.setId(null);
                        saveRedirects.add(re);
                    }
                }
            }else if("edit".equals(info.getRowState())) {
                List<OddRedirectEntity> list = info.getOddRedirectEntities();
                oddInfoService.updateById(info);
                if(list!=null&&list.size()>0){
                    for(OddRedirectEntity re:list){
                        re.setInfoId(info.getId());
                        re.setOddId(oddId);
                        re.setId(null);
                        saveRedirects.add(re);
                    }
                }
            } else if("del".equals(info.getRowState())) {
                deleteIds.add(info.getId());
            }
        }
        if(saveRedirects.size()>0){
            redirectService.saveBatch(saveRedirects);
        }
        if(deleteIds.size()>0){
            oddInfoService.removeByIds(deleteIds, false);
        }
    }


    @Override
    public void del(List<OddVO> vos) {
        List<Long> list=vos.stream().map(OddVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.EQ, list));
        List<OddEntity> oddEntities = super.queryList(queryParam,false);
        List<Long> ids=new ArrayList<>();
        for(OddEntity entity:oddEntities){
            if(entity.getSourceType()==0){
                ids.add(entity.getOddApplyId());
            }
        }
        if(ids.size()>0){
            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag,1);
            updateWrapper.set(OddApplyEntity::getOddId,null);
            updateWrapper.in(OddApplyEntity::getId,ids);
            oddApplyService.update(updateWrapper);
        }
    }

    @Override
    public OddVO queryDetail(Long id) {
    	OddEntity entity = this.selectById(id);
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = BeanMapper.map(entity, OddVO.class);
        if(infoEntities!=null&&infoEntities.size()>0){
            List<OddInfoVO> oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam=null;
            for(OddInfoVO infovo:oddInfoVOS){
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<OddRedirectEntity> redirectEntities = redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList(redirectEntities, OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }
}
