/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.sync.api.IGrapSyncApi;
import com.ejianc.business.sync.vo.SumGrapVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sumGrap")
public class SumGrapBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IGrapService grapService;
    @Autowired
    private ISumGrapService sumGrapService;
    @Autowired
    private IGrapSyncApi grapSyncApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("--> \u8fdb\u5ea6\u53f0\u8d26\u63d0\u4ea4\u5f00\u59cb");
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(GrapEntity::getSumGrapId, (Object)billId);
        updateWrapper.set(GrapEntity::getUseState, (Object)1);
        this.grapService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("--> \u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("--> \u8fdb\u5ea6\u53f0\u8d26\u5ba1\u6838\u5f00\u59cb");
        SumGrapEntity entity = (SumGrapEntity)((Object)this.sumGrapService.selectById(billId));
        SumGrapVO sumGrapVO = (SumGrapVO)BeanMapper.map((Object)((Object)entity), SumGrapVO.class);
        CommonResponse response = this.grapSyncApi.syncImg(sumGrapVO);
        this.logger.info("--> \u63a8\u9001NC\u4e2d\u95f4\u8868:" + JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            this.grapSyncApi.delSyncImg(billId);
            return CommonResponse.error((String)response.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(GrapEntity::getSumGrapId, (Object)billId);
        updateWrapper.set(GrapEntity::getUseState, (Object)1);
        this.grapService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("--> \u8fdb\u5ea6\u53f0\u8d26\u5f03\u5ba1\u524d\u4e8b\u4ef6");
        CommonResponse response = this.grapSyncApi.getSyncImg(billId);
        this.logger.info("--> NC\u4e2d\u95f4\u8868\u662f\u5426\u5df2\u7ed3\u7b97:" + JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        if ((Integer)response.getData() > 0) {
            return CommonResponse.error((String)"NC\u5df2\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("--> \u8fdb\u5ea6\u53f0\u8d26\u64a4\u56de\u5f00\u59cb");
        CommonResponse delRes = this.grapSyncApi.delSyncImg(billId);
        this.logger.info("--> \u5220\u9664NC\u4e2d\u95f4\u8868:" + JSONObject.toJSONString((Object)delRes));
        if (!delRes.isSuccess()) {
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(GrapEntity::getSumGrapId, (Object)billId);
        updateWrapper.set(GrapEntity::getUseState, (Object)0);
        this.grapService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

