/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.business.sync.vo.OddRedirectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="odd")
public class OddBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOddService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddSyncApi oddSyncApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OddEntity::getOddStatus, (Object)1);
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (state == 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddEntity::getOddStatus, (Object)1);
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.debug("---------------------------\u6570\u636e\u540c\u6b65\u81f3nc");
        OddVO oddVO = this.service.queryDetail(billId);
        com.ejianc.business.sync.vo.OddVO map = (com.ejianc.business.sync.vo.OddVO)BeanMapper.map((Object)oddVO, com.ejianc.business.sync.vo.OddVO.class);
        List oddInfoEntities = oddVO.getOddInfoEntities();
        ArrayList<com.ejianc.business.sync.vo.OddInfoVO> list = new ArrayList<com.ejianc.business.sync.vo.OddInfoVO>();
        for (OddInfoVO info : oddInfoEntities) {
            List oddRedirectEntities = info.getOddRedirectEntities();
            List redirectVO = BeanMapper.mapList((Iterable)oddRedirectEntities, OddRedirectVO.class);
            com.ejianc.business.sync.vo.OddInfoVO oddInfoVO = (com.ejianc.business.sync.vo.OddInfoVO)BeanMapper.map((Object)info, com.ejianc.business.sync.vo.OddInfoVO.class);
            oddInfoVO.setOddRedirectEntities(redirectVO);
            list.add(oddInfoVO);
        }
        map.setOddInfoEntities(list);
        CommonResponse response = this.oddSyncApi.syncOdd(map);
        this.logger.debug("+++++++++++++++++++++++++++\u6570\u636e\u540c\u6b65\u81f3nc");
        if (response.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u6570\u636e\u540c\u6b65\u81f3nc\u5931\u8d25");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse booleanResponse = this.oddSyncApi.syncFlag(billId);
        if (booleanResponse.isSuccess()) {
            if (((Boolean)booleanResponse.getData()).booleanValue()) {
                return CommonResponse.error((String)booleanResponse.getMsg());
            }
            CommonResponse delResponse = this.oddSyncApi.delSync(billId);
            if (delResponse.isSuccess()) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)delResponse.getMsg());
        }
        return CommonResponse.error((String)booleanResponse.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

