package com.ejianc.business.fbxt.grap.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 进度台账实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("sumGrap")
public class SumGrapController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ISumGrapService service;

    @Autowired
    private IGrapService grapService;

    @Autowired
    private IOrgApi orgApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SumGrapVO> saveOrUpdate(@RequestBody SumGrapVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SumGrapVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SumGrapVO> vos) {
        List<Long> ids = vos.stream().map(SumGrapVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        // 修改对应进度计量单为自由态
        LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(GrapEntity::getSumGrapId, ids);
        updateWrapper.set(GrapEntity::getBillState, 0);
        updateWrapper.set(GrapEntity::getSumGrapId, null);
        grapService.update(updateWrapper);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SumGrapVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 权限隔离 */
        Long orgId = InvocationInfoProxy.getOrgId();
        if(null != orgId && orgId > 0){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        } else {
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if(!childOrgResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        // 审核金额
        if(param.getParams().containsKey("sumApproveMny")){
            param.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.UNCOMMITED_STATE.getBillStateCode()));
        }
        IPage<SumGrapEntity> page = service.queryPage(param,false);
        IPage<SumGrapVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SumGrapVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<SumGrapVO>> res = this.queryList(param);
        List<SumGrapVO> list = new ArrayList<>();
        if(res.isSuccess() && res.getData() != null && CollectionUtils.isNotEmpty(res.getData().getRecords())){
            list = res.getData().getRecords();
            list.forEach(vo -> {
                String useStateName = "";
                if(vo.getUseState() != null && vo.getUseState() == 1) {
                    useStateName = "是";
                } else {
                    useStateName = "否";
                }
                vo.setUseStateName(useStateName);
                if(vo.getBillState() == BillStateEnum.UNCOMMITED_STATE.getBillStateCode()){
                    vo.setSumApproveMny(null);
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sumGrap-export.xlsx", beans, response);
    }

    /**
     * @Description syncUseState 同步NC已结算状态
     */
    @RequestMapping(value = "/syncUseState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse syncUseState(HttpServletRequest request) {
        return service.syncUseState(request);
    }

}
