package com.ejianc.business.fbxt.odd.controller;

import java.io.Serializable;

import com.ejianc.business.fbxt.odd.service.IOddRedirectService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 零星用工实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("odd")
public class OddController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOddService service;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddVO> saveOrUpdate(@RequestBody OddVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddVO> vos) {
        service.del(vos);
        service.removeByIds(vos.stream().map(OddVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage<OddEntity> page = service.queryPage(param,false);
        IPage<OddVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询暂存
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryzcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddVO>> queryzcList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage<OddEntity> page = service.queryPage(param,false);
        IPage<OddVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 查询暂存数量
     * @param param
     * @return
     */
    @RequestMapping(value = "/getcount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        CommonResponse<IPage<OddVO>> response = this.queryzcList(param);
        return CommonResponse.success("查询成功！",response.getData().getTotal());
    }
    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");

        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<OddEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<OddVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), OddVO.class);
            list.forEach(vo -> {
                if(null != vo.getSourceType()){
                    if(0==vo.getSourceType()){
                        vo.setSourceTypeName("参照申请");
                    }else if(1 == vo.getSourceType()){
                        vo.setSourceTypeName("自制");
                    }
                }else{
                    vo.setSourceTypeName("");
                }
                if(null != vo.getSettleNcFlag()){
                    if(0==vo.getSettleNcFlag()){
                        vo.setSettleNcFlagName("否");
                    }else if(1 == vo.getSettleNcFlag()){
                        vo.setSettleNcFlagName("是");
                    }
                }else{
                    vo.setSettleNcFlagName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("odd-export.xlsx", beans, response);
    }

}
