/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.bean.SumGrapDetailEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.mapper.SumGrapMapper;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.sync.api.IGrapSyncApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sumGrapService")
public class SumGrapServiceImpl
extends BaseServiceImpl<SumGrapMapper, SumGrapEntity>
implements ISumGrapService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FBXT_SUM_GRAP = "FBXT_SUM_GRAP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IGrapSyncApi grapSyncApi;

    @Override
    public SumGrapVO saveOrUpdate(SumGrapVO saveorUpdateVO) {
        SumGrapEntity entity = (SumGrapEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SumGrapEntity.class));
        List detailList = saveorUpdateVO.getDetailList();
        ArrayList childList = new ArrayList();
        for (SumGrapDetailVO detail : detailList) {
            if (!CollectionUtils.isNotEmpty((Collection)detail.getChildren())) continue;
            childList.addAll(detail.getChildren());
        }
        if (CollectionUtils.isNotEmpty(childList)) {
            detailList.addAll(childList);
        }
        entity.setDetailList(BeanMapper.mapList((Iterable)detailList, SumGrapDetailEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(FBXT_SUM_GRAP, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public SumGrapVO queryDetail(Long id) {
        SumGrapEntity entity = (SumGrapEntity)((Object)super.selectById((Serializable)id));
        SumGrapVO vo = (SumGrapVO)BeanMapper.map((Object)((Object)entity), SumGrapVO.class);
        ArrayList list = new ArrayList();
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(item -> {
                if (item.getParentId() == null) {
                    list.add(item);
                }
            });
            list.forEach(item -> {
                ArrayList listd = new ArrayList();
                detailList.forEach(e -> {
                    if (item.getId().equals(e.getParentId())) {
                        listd.add(e);
                    }
                });
                Collections.sort(listd, new Comparator<SumGrapDetailVO>(){

                    @Override
                    public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                        Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000.0 - Double.valueOf(o2.getDetailIndex()) * 10000.0;
                        int i = vlaue.intValue();
                        return i;
                    }
                });
                item.setChildren(listd);
            });
            Collections.sort(list, new Comparator<SumGrapDetailVO>(){

                @Override
                public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                    Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000.0 - Double.valueOf(o2.getDetailIndex()) * 10000.0;
                    int i = vlaue.intValue();
                    return i;
                }
            });
            vo.setDetailList(list);
        }
        return vo;
    }

    @Override
    public CommonResponse syncUseState(HttpServletRequest request) {
        this.logger.info("--> \u540c\u6b65NC\u4e2d\u95f4\u8868\u5f00\u59cb");
        String param = request.getParameter("param");
        JSONArray jsonArray = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        int day = jsonArray.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + day + "----");
        CommonResponse response = this.grapSyncApi.selectStatus(Integer.valueOf(day));
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.logger.info("--> \u83b7\u53d6NC\u4e2d\u95f4\u8868\u6570\u636e:" + JSONObject.toJSONString((Object)response));
        List list = (List)response.getData();
        ArrayList<Long> yids = new ArrayList<Long>();
        ArrayList<Long> nids = new ArrayList<Long>();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            String str = obj != null ? JSONObject.toJSONString(obj) : "";
            JSONObject json = JSON.parseObject((String)str);
            String CSRCID = json.getString("CSRCID");
            String BISSETTLE = json.getString("BISSETTLE");
            if (!StringUtils.isNotEmpty((CharSequence)CSRCID) || !CSRCID.startsWith("ST-")) continue;
            Long id = Long.valueOf(CSRCID.substring("ST-".length()));
            if ("Y".equals(BISSETTLE)) {
                yids.add(id);
                continue;
            }
            nids.add(id);
        }
        this.logger.info("--> yids:" + JSONObject.toJSONString(yids));
        this.logger.info("--> nids:" + JSONObject.toJSONString(nids));
        if (CollectionUtils.isNotEmpty(yids)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, yids);
            updateWrapper.set(SumGrapEntity::getUseState, (Object)1);
            super.update((Wrapper)updateWrapper);
        }
        if (CollectionUtils.isNotEmpty(nids)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, nids);
            updateWrapper.set(SumGrapEntity::getUseState, (Object)0);
            super.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }
}

