/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.mapper.OddApplyMapper;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.vo.OddApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="oddApplyService")
public class OddApplyServiceImpl
extends BaseServiceImpl<OddApplyMapper, OddApplyEntity>
implements IOddApplyService {
    private static final String ODD_APPLY = "ODD_APPLY";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<OddApplyVO> saveOrUpdate(OddApplyVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddApplyEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddApplyEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_APPLY, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OddApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddApplyEntity.class));
            operateType = "add";
        }
        CommonResponse orgVo = this.orgApi.getOneById(entity.getOrgId());
        if (!orgVo.isSuccess()) {
            return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setCropSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        entity.setRegisterFlag(0);
        super.saveOrUpdate((Object)entity, false);
        OddApplyVO vo = (OddApplyVO)BeanMapper.map((Object)((Object)entity), OddApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

