/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.bean.OddRedirectEntity;
import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddRedirectService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="oddService")
public class OddServiceImpl
extends BaseServiceImpl<OddMapper, OddEntity>
implements IOddService {
    private static final String ODD_CODE = "ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;

    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        QueryParam queryParam;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            saveorUpdateVO.setOddSource(Integer.valueOf(0));
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "add";
        }
        CommonResponse orgVo = this.orgApi.getOneById(entity.getCropId());
        if (!orgVo.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setCropSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        List oddInfoEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getOddInfoEntities(), OddInfoEntity.class);
        List fileIds = saveorUpdateVO.getFileIds();
        super.saveOrUpdate((Object)entity);
        if (entity.getSourceType() == 0 && entity.getOddStatus() == 1) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            queryParam.getParams().put("oddStatus", new Parameter("ne", (Object)0));
            queryParam.getParams().put("oddApplyId", new Parameter("eq", (Object)entity.getOddApplyId()));
            List oddEntities = super.queryList(queryParam, false);
            if (oddEntities != null && oddEntities.size() > 0) {
                throw new BusinessException("\u8be5\u7528\u5de5\u7533\u8bf7\u5355\u5df2\u88ab\u5f15\u7528");
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)1);
            updateWrapper.set(OddApplyEntity::getOddId, (Object)entity.getId());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getOddApplyId());
            this.oddApplyService.update((Wrapper)updateWrapper);
        }
        if (fileIds != null && fileIds.size() > 0) {
            this.fileApi.updateAttachRef(entity.getId(), fileIds);
        }
        this.saveDetails(oddInfoEntities, entity.getId(), operateType);
        queryParam = new QueryParam();
        queryParam.getParams().put("oddId", new Parameter("eq", (Object)entity.getId()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
        List dddRedirectEntityes = this.redirectService.queryList(queryParam, false);
        if (dddRedirectEntityes != null && dddRedirectEntityes.size() > 0) {
            entity.setRedirectFlag(1);
            BigDecimal zkmny = new BigDecimal("0");
            for (OddRedirectEntity oddRedirectEntity : dddRedirectEntityes) {
                zkmny = oddRedirectEntity.getMny().add(zkmny);
            }
            entity.setZkmny(zkmny);
        } else {
            entity.setRedirectFlag(0);
        }
        super.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    private void saveDetails(List<OddInfoEntity> infoList, Long oddId, String operateType) {
        if ("edit".equals(operateType)) {
            this.redirectService.remove((Wrapper)new QueryWrapper().eq((Object)"odd_id", (Object)oddId));
        }
        ArrayList<OddRedirectEntity> saveRedirects = new ArrayList<OddRedirectEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (OddInfoEntity info : infoList) {
            List<OddRedirectEntity> list;
            if ("add".equals(info.getRowState())) {
                info.setOddId(oddId);
                info.setInfoNcFlag(0);
                list = info.getOddRedirectEntities();
                this.oddInfoService.save((Object)info);
                if (list == null || list.size() <= 0) continue;
                for (OddRedirectEntity re : list) {
                    re.setInfoId(info.getId());
                    re.setOddId(oddId);
                    re.setId(null);
                    re.setRedirectNcFlag(0);
                    saveRedirects.add(re);
                }
                continue;
            }
            if ("edit".equals(info.getRowState())) {
                list = info.getOddRedirectEntities();
                this.oddInfoService.updateById((Object)info);
                if (list == null || list.size() <= 0) continue;
                for (OddRedirectEntity re : list) {
                    re.setInfoId(info.getId());
                    re.setOddId(oddId);
                    re.setId(null);
                    re.setRedirectNcFlag(0);
                    saveRedirects.add(re);
                }
                continue;
            }
            if (!"del".equals(info.getRowState())) continue;
            deleteIds.add(info.getId());
        }
        if (saveRedirects.size() > 0) {
            this.redirectService.saveBatch(saveRedirects);
        }
        if (deleteIds.size() > 0) {
            this.oddInfoService.removeByIds(deleteIds, false);
        }
    }

    @Override
    public void del(List<OddVO> vos) {
        List list = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", list));
        List oddEntities = super.queryList(queryParam, false);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (OddEntity entity : oddEntities) {
            if (entity.getSourceType() != 0) continue;
            ids.add(entity.getOddApplyId());
        }
        if (ids.size() > 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)0);
            updateWrapper.set(OddApplyEntity::getOddId, null);
            updateWrapper.in(BaseEntity::getId, ids);
            this.oddApplyService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public OddVO queryDetail(Long id) {
        OddEntity entity = (OddEntity)((Object)this.selectById(id));
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = (OddVO)BeanMapper.map((Object)((Object)entity), OddVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam = null;
            for (OddInfoVO infovo : oddInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter("eq", (Object)infovo.getId()));
                List redirectEntities = this.redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList((Iterable)redirectEntities, OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }

    @Override
    public CommonResponse<String> settleNc(OddSyncVo vo) {
        QueryParam queryParam;
        QueryParam queryParam2;
        List yinfo = vo.getYinfo();
        List ninfo = vo.getNinfo();
        List yredirect = vo.getYredirect();
        List nredirect = vo.getNredirect();
        if (yinfo != null && yinfo.size() > 0) {
            LambdaUpdateWrapper yupdateWrapper = new LambdaUpdateWrapper();
            yupdateWrapper.set(OddInfoEntity::getInfoNcFlag, (Object)1);
            yupdateWrapper.in(BaseEntity::getId, (Collection)yinfo);
            this.oddInfoService.update((Wrapper)yupdateWrapper);
        }
        if (ninfo != null && ninfo.size() > 0) {
            LambdaUpdateWrapper nupdateWrapper = new LambdaUpdateWrapper();
            nupdateWrapper.set(OddInfoEntity::getInfoNcFlag, (Object)0);
            nupdateWrapper.in(BaseEntity::getId, (Collection)ninfo);
            this.oddInfoService.update((Wrapper)nupdateWrapper);
        }
        if (yredirect != null && yredirect.size() > 0) {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, (Object)1);
            tupdateWrapper.in(BaseEntity::getId, (Collection)yredirect);
            this.redirectService.update((Wrapper)tupdateWrapper);
        }
        if (nredirect != null && nredirect.size() > 0) {
            LambdaUpdateWrapper fupdateWrapper = new LambdaUpdateWrapper();
            fupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, (Object)0);
            fupdateWrapper.in(BaseEntity::getId, (Collection)nredirect);
            this.redirectService.update((Wrapper)fupdateWrapper);
        }
        HashSet<Long> yids = new HashSet<Long>();
        if (yinfo != null && yinfo.size() > 0) {
            queryParam2 = new QueryParam();
            queryParam2.getParams().put("id", new Parameter("in", (Object)yinfo));
            List oddInfos = this.oddInfoService.queryList(queryParam2, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    yids.add(infoEntity.getOddId());
                }
            }
        }
        if (yredirect != null && yredirect.size() > 0) {
            queryParam2 = new QueryParam();
            queryParam2.getParams().put("id", new Parameter("in", (Object)yredirect));
            List redirects = this.redirectService.queryList(queryParam2, false);
            if (redirects != null && redirects.size() > 0) {
                for (Object redirectEntity : redirects) {
                    yids.add(((OddRedirectEntity)((Object)redirectEntity)).getOddId());
                }
            }
        }
        if (yids != null && yids.size() > 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddEntity::getSettleNcFlag, (Object)1);
            updateWrapper.in(BaseEntity::getId, yids);
            super.update((Wrapper)updateWrapper);
        }
        HashSet<Long> nids = new HashSet<Long>();
        if (ninfo != null && ninfo.size() > 0) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", (Object)ninfo));
            List oddInfos = this.oddInfoService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    nids.add(infoEntity.getOddId());
                }
            }
        }
        if (nredirect != null && nredirect.size() > 0) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", (Object)nredirect));
            List redirects = this.redirectService.queryList(queryParam, false);
            if (redirects != null && redirects.size() > 0) {
                for (OddRedirectEntity redirectEntity : redirects) {
                    nids.add(redirectEntity.getOddId());
                }
            }
        }
        if (nids != null && nids.size() > 0) {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            QueryParam queryParam3 = new QueryParam();
            queryParam3.getParams().put("oddId", new Parameter("in", nids));
            List oddInfos = this.oddInfoService.queryList(queryParam3, false);
            List redirects = this.redirectService.queryList(queryParam3, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity oi : oddInfos) {
                    if (!map.containsKey(oi.getOddId())) {
                        map.put(oi.getOddId(), 0);
                    }
                    if (oi.getInfoNcFlag() != 1) continue;
                    map.put(oi.getOddId(), (Integer)map.get(oi.getOddId()) + 1);
                }
            }
            if (redirects != null && redirects.size() > 0) {
                for (Object re : redirects) {
                    if (!map.containsKey(((OddRedirectEntity)((Object)re)).getOddId())) {
                        map.put(((OddRedirectEntity)((Object)re)).getOddId(), 0);
                    }
                    if (((OddRedirectEntity)((Object)re)).getRedirectNcFlag() != 1) continue;
                    map.put(((OddRedirectEntity)((Object)re)).getOddId(), (Integer)map.get(((OddRedirectEntity)((Object)re)).getOddId()) + 1);
                }
            }
            ArrayList<Long> oddids = new ArrayList<Long>();
            for (Long key : map.keySet()) {
                if ((Integer)map.get(key) != 0) continue;
                oddids.add(key);
            }
            if (oddids != null && oddids.size() > 0) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(OddEntity::getSettleNcFlag, (Object)0);
                updateWrapper.in(BaseEntity::getId, oddids);
                super.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }
}

