package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapDetailService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.GrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.util.ContextHolderUtils;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("grap") 
public class GrapBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${common.env.base-host}")
	private String BASE_HOST;

	@Autowired
	private IGrapService grapService;

	@Autowired
	private ISumGrapService sumGrapService;

	@Autowired
	private ISumGrapDetailService sumGrapDetailService;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public synchronized CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		GrapEntity entity = grapService.selectById(billId);
		GrapVO grapVO = BeanMapper.map(entity, GrapVO.class);

		// 推送进度台账
		if(grapVO.getSumGrapId() == null){
			SumGrapVO sumGrapVO = this.pushToSumGrap(grapVO);

			entity.setSumGrapId(sumGrapVO.getId());
			grapService.updateById(entity);
			logger.info("--> 单据：" + billId + "已汇总到：" + entity.getSumGrapId());
		}
		return CommonResponse.success();
	}

	/**
	 * 推送进度台账
	 * @param grapVO
	 * @return
	 */
	private SumGrapVO pushToSumGrap(GrapVO grapVO) {
		logger.info("--> 单据：" + grapVO.getId() + "汇总开始");
		List<GrapDetailVO> detailList = grapVO.getDetailList();
		LambdaQueryWrapper<SumGrapEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(SumGrapEntity::getContractId, grapVO.getContractId());
		// 查询自由态/审批驳回
		wrapper.and(x -> x.eq(SumGrapEntity::getBillState, 0).or().eq(SumGrapEntity::getBillState, 4) );
//		wrapper.eq(SumGrapEntity::getBillState, 0);
		List<SumGrapEntity> sumGrapList = sumGrapService.list(wrapper);
		// 明细及非末级Map
		SumGrapVO sumGrapVO = null;
		Map<String, SumGrapDetailVO> parentMap = new HashMap<>();// 非末级Map，key-infoId，value-非末级VO
		Map<Long, SumGrapDetailVO> sumDetailMap = new HashMap<>();// 子表Map，key-id，value-所有子表VO
		boolean isSum = false;// 是否已汇总
		if(CollectionUtils.isEmpty(sumGrapList)){
			// 新增进度台账
			sumGrapVO = this.getSumGrapVO(grapVO);// 构造主表VO
			// 子表
			if(CollectionUtils.isNotEmpty(detailList)){
				for(GrapDetailVO detail : detailList){
					this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
				}
				sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
			}
			sumGrapVO = sumGrapService.saveOrUpdate(sumGrapVO);
		} else {
			// 汇总进度台账
			SumGrapEntity sumGrapEntity = sumGrapService.selectById(sumGrapList.get(0).getId());
			sumGrapVO = BeanMapper.map(sumGrapEntity, SumGrapVO.class);
			if(CollectionUtils.isNotEmpty(detailList)) {
				// 已汇总进度计量明细主键
				List<Long> detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x!=null).collect(Collectors.toList());
				for (GrapDetailVO detail : detailList) {
					if(detailIds.contains(detail.getId())){
						isSum = true;
					}
				}
			}
			if(!isSum){
				sumGrapVO.setDescription(this.getSumStr(sumGrapVO.getDescription(), grapVO.getDescription()));// 汇总进度说明
				sumGrapVO.setSumMny(DecimalUtils.add(sumGrapVO.getSumMny(), grapVO.getSumMny()));// 汇总金额
				sumGrapVO.setSumApproveMny(DecimalUtils.add(sumGrapVO.getSumApproveMny(), grapVO.getSumMny()));// 汇总审批金额
				List<SumGrapDetailVO> sumDetailList = sumGrapVO.getDetailList();
				for(SumGrapDetailVO detail : sumDetailList){
					if(detail.getLeafFlag() == 0 && !parentMap.containsKey(detail.getInfoId())){
						parentMap.put(detail.getInfoId(), detail);
					}
					if(!sumDetailMap.containsKey(detail.getId())){
						sumDetailMap.put(detail.getId(), detail);
					}
				}
				if(CollectionUtils.isNotEmpty(detailList)) {
					// 已汇总进度计量明细主键
					List<Long> detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x!=null).collect(Collectors.toList());
					for (GrapDetailVO detail : detailList) {
						if(!detailIds.contains(detail.getId())){
							this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
						}
					}
					sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
				}
				sumGrapVO = sumGrapService.saveOrUpdate(sumGrapVO);
			}
		}
		logger.info("--> 汇总后进度台账VO：" + JSONObject.toJSONString(sumGrapVO));
		// 图片汇总
		if(!isSum){
			CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
					String.valueOf(grapVO.getId()), "BT201202000000001", "imgUpload1",
					String.valueOf(sumGrapVO.getId()), "BT201202000000002", "imgUpload1");
			CommonResponse<String> response2 = attachmentApi.copyFilesFromSourceBillToTargetBill(
					String.valueOf(grapVO.getId()), "BT201202000000001", "bill",
					String.valueOf(sumGrapVO.getId()), "BT201202000000002", "bill");
		}
		return sumGrapVO;
	}

	/**
	 * 构造主表VO
	 * @param grapVO
	 * @return
	 */
	private SumGrapVO getSumGrapVO(GrapVO grapVO) {
		SumGrapVO vo = new SumGrapVO();
		vo.setProjectId(grapVO.getProjectId());// 项目主键
		vo.setProjectName(grapVO.getProjectName());// 项目名称
		vo.setProjectSourceId(grapVO.getProjectSourceId());// 项目来源ID
		vo.setContractId(grapVO.getContractId());// 合同主键
		vo.setContractCode(grapVO.getContractCode());// 合同编码
		vo.setContractName(grapVO.getContractName());// 合同名称
		vo.setCropId(grapVO.getCropId());// 组织主键
		vo.setCropName(grapVO.getCropName());// 组织主键
		vo.setCropSourceId(grapVO.getCropSourceId());// 组织来源ID
		vo.setOrgId(grapVO.getOrgId());// 项目部主键
		vo.setOrgName(grapVO.getOrgName());// 项目部名称
		vo.setOrgSourceId(grapVO.getOrgSourceId());// 项目部来源ID
		vo.setSupplierId(grapVO.getSupplierId());// 供应商主键
		vo.setSupplierName(grapVO.getSupplierName());// 供应商名称
		vo.setSupplierSourceId(grapVO.getSupplierSourceId());// 供应商来源ID
		vo.setCreateUserId(InvocationInfoProxy.getUserid());// 制单人主键
		vo.setCreateUserName(sessionManager.getUserContext().getUserName());// 制单人名称
		vo.setUseState(0);// 是否NC已结算，0-未结算，1-已结算
		// 汇总
		vo.setSumMonth(new SimpleDateFormat("yyyy-MM").format(grapVO.getCreateDate()));
		vo.setSumMny(grapVO.getSumMny());// 汇总金额
		vo.setSumApproveMny(grapVO.getSumMny());// 汇总审核金额
		vo.setDescription(grapVO.getDescription());// 进度说明
		return vo;
	}

	/**
	 * 构造子表VO
	 * @param grapVO
	 * @param detail
	 * @param parentMap
	 * @param sumDetailMap
	 */
	private void dealSumDetailMap(GrapVO grapVO, GrapDetailVO detail, Map<String, SumGrapDetailVO> parentMap, Map<Long, SumGrapDetailVO> sumDetailMap) {
		String infoId = detail.getInfoId();
		// 新增末级
		SumGrapDetailVO vo = new SumGrapDetailVO();
		vo.setGrapId(grapVO.getId());// 计量单主键
		vo.setGrapDetailId(detail.getId());// 计量单子表主键
		vo.setInfoId(detail.getInfoId());// 合同清单主键
//		vo.setInfoCode(detail.getInfoCode());// 合同清单编码
//		vo.setInfoName(detail.getInfoName());// 合同清单名称
//		vo.setUnit(detail.getUnit());// 单位
//		vo.setPrice(detail.getPrice());// 单价
		vo.setNum(detail.getNum());// 数量
		vo.setApproveNum(detail.getNum());// 审批数量
		vo.setOldNum(detail.getNum());// 原始数量
		vo.setMny(detail.getMny());// 金额
		vo.setApproveMny(detail.getMny());// 审批金额
		vo.setConstruction(grapVO.getConstruction());// 施工部位
		vo.setDescription(grapVO.getDescription());// 进度说明
		vo.setCommitUserId(grapVO.getCreateUserId());// 提交人主键
		vo.setCommitUserName(grapVO.getCreateUserName());// 提交人名称
		// 处理非末级VO
		Long parentId = null;
		SumGrapDetailVO parentVO = null;
		if(!parentMap.containsKey(infoId)){
			// 新增
			parentId = IdWorker.getId();// 生成随机主键
			parentVO = new SumGrapDetailVO();
			parentVO.setId(parentId);// 主键
			parentVO.setInfoId(detail.getInfoId());// 合同清单主键
			parentVO.setInfoCode(detail.getInfoCode());// 合同清单编码
			parentVO.setInfoName(detail.getInfoName());// 合同清单名称
			parentVO.setUnit(detail.getUnit());// 单位
			parentVO.setPrice(detail.getPrice());// 单价
			parentVO.setNum(detail.getNum());// 数量
			parentVO.setApproveNum(detail.getNum());// 审批数量
			parentVO.setOldNum(detail.getNum());// 原始数量
			parentVO.setMny(detail.getMny());// 金额
			parentVO.setApproveMny(detail.getMny());// 审批金额
			parentVO.setConstruction(grapVO.getConstruction());// 施工部位
			parentVO.setLeafFlag(0);// 是否末级，0-否，1-是
			parentVO.setDetailIndex(String.valueOf(1 + parentMap.size()));// 序号
			parentMap.put(infoId, parentVO);
		} else {
			// 汇总
			parentVO = parentMap.get(infoId);
			parentId = parentVO.getId();
			parentVO.setNum(DecimalUtils.add(parentVO.getNum(), detail.getNum()));// 汇总数量
			parentVO.setApproveNum(DecimalUtils.add(parentVO.getApproveNum(), detail.getNum()));// 汇总审批数量
			parentVO.setOldNum(DecimalUtils.add(parentVO.getOldNum(), detail.getNum()));// 汇总原始数量
			parentVO.setMny(DecimalUtils.add(parentVO.getMny(), detail.getMny()));// 汇总金额
			parentVO.setApproveMny(DecimalUtils.add(parentVO.getApproveMny(), detail.getMny()));// 汇总审批金额
			String construction = this.getSumStr(parentVO.getConstruction(), grapVO.getConstruction());
			parentVO.setConstruction(construction);// 汇总施工部位
		}
		sumDetailMap.put(parentId, parentVO);// 放入非末级VO
		vo.setLeafFlag(1);// 是否末级，0-否，1-是
		vo.setParentId(parentId);// 父级主键
		vo.setDetailIndex(parentVO.getDetailIndex() + "." + this.getIndex(sumDetailMap, parentId));// 序号
		sumDetailMap.put(detail.getId(), vo);// 放入末级VO
	}

	/**
	 * 汇总字符串，去重并去空格
	 * @param sumStr
	 * @param str
	 * @return
	 */
	private String getSumStr(String sumStr, String str) {
		if(StringUtils.isNotEmpty(str)){
			str = str.replaceAll(" ", "");
		} else {
			return sumStr;
		}
		if(StringUtils.isNotEmpty(sumStr)){
			String[] strs = sumStr.split(",");
			Set<String> strSet = new HashSet<>(Arrays.asList(strs));
			if(!strSet.contains(str)){
				sumStr = sumStr + "," + str;
			}
			return sumStr;
		} else {
			return str;
		}
	}

	/**
	 * 获取子表末级排序
	 * @param map
	 * @param parentId
	 * @return
	 */
	private int getIndex(Map<Long, SumGrapDetailVO> map, Long parentId) {
		int index = 1;
		for(SumGrapDetailVO vo : map.values()){
			if(parentId.equals(vo.getParentId())){
				index += 1;
			}
		}
		return index;
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//		//是否被其他单据引用
//		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
//		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
//		if(res.isSuccess()) {//单据未被下游单据引用
//			return CommonResponse.success();
//		}else{
//			return CommonResponse.error(res.getMsg());
//		}
		GrapEntity entity = grapService.selectById(billId);
		if(entity.getUseState() != null && entity.getUseState() == 1){
			return CommonResponse.error("单据已被引用，不允许撤回！");
		}
		if(entity.getHistoryFlag() != null && entity.getHistoryFlag() == 1){
			return CommonResponse.error("历史数据，不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		GrapEntity entity = grapService.selectById(billId);
		GrapVO grapVO = BeanMapper.map(entity, GrapVO.class);

		// 从进度台账撤回
		if(sumGrapService.getById(grapVO.getSumGrapId()) != null){
			SumGrapVO sumGrapVO = this.withdrawFromSumGrapVO(grapVO);
		}
		entity.setSumGrapId(null);
		grapService.updateById(entity);
		logger.info("--> 单据：" + billId + "已取消汇总");
		return CommonResponse.success();
	}

	/**
	 * 从进度台账撤回
	 * @param grapVO
	 * @return
	 */
	private SumGrapVO withdrawFromSumGrapVO(GrapVO grapVO) {
		logger.info("--> 单据：" + grapVO.getId() + "取消汇总开始");
		SumGrapEntity sumGrapEntity = sumGrapService.selectById(grapVO.getSumGrapId());
		SumGrapVO sumGrapVO = BeanMapper.map(sumGrapEntity, SumGrapVO.class);
		List<SumGrapDetailVO> sumDetailList = sumGrapVO.getDetailList();
		Collections.sort(sumDetailList, new Comparator<SumGrapDetailVO>() {
			@Override
			public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
				Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000 - Double.valueOf(o2.getDetailIndex()) * 10000;
				int i = vlaue.intValue();
				return i;
			}
		});
		// 明细及非末级Map
		Map<Long, SumGrapDetailVO> parentMap = new HashMap<>();// 非末级Map，key-id，value-非末级VO
		Map<Long, SumGrapDetailVO> sumDetailMap = new LinkedHashMap<>();// 子表Map，key-id，value-所有子表VO
		if(CollectionUtils.isNotEmpty(sumDetailList)){
			for(SumGrapDetailVO vo : sumDetailList){
				if(vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getId())){
					parentMap.put(vo.getId(), vo);
				}
				if(!sumDetailMap.containsKey(vo.getId())){
					if(grapVO.getId().equals(vo.getGrapId())){
						vo.setRowState("del");
//							vo.setDetailIndex(null);
					}
					sumDetailMap.put(vo.getId(), vo);
				}
			}
		}
		// 构造子集
		if(CollectionUtils.isNotEmpty(sumDetailList)){
			for(SumGrapDetailVO vo : sumDetailList){
				Long parentId = vo.getParentId();
				if(parentMap.containsKey(parentId) && !"del".equals(vo.getRowState())){
					SumGrapDetailVO parentVO = parentMap.get(parentId);
					List<SumGrapDetailVO> children = parentVO.getChildren() != null ? parentVO.getChildren() : new ArrayList<>();
					if(!children.contains(vo)){
						children.add(vo);
					}
					parentVO.setChildren(children);
					parentMap.put(parentId, parentVO);
				}
			}
		}
		int parentRow = parentMap.size();// 非末级剩余行数
		// 重新计算非末级
		if(parentRow != 0){
			for(SumGrapDetailVO parentVO : parentMap.values()){
				List<SumGrapDetailVO> children = parentVO.getChildren();
				if(CollectionUtils.isNotEmpty(children)){
					BigDecimal num = null;// 汇总数量
					BigDecimal mny = null;// 汇总金额
					BigDecimal approveNum = null;// 汇总审批数量
					BigDecimal approveMny = null;// 汇总审批金额
					BigDecimal oldNum = null;// 汇总原始数量
					String construction = null;// 施工部位
					int index = 0;
					for(SumGrapDetailVO vo : children){
						num = DecimalUtils.add(num, vo.getNum());
						mny = DecimalUtils.add(mny, vo.getMny());
						approveNum = DecimalUtils.add(approveNum, vo.getApproveNum());
						approveMny = DecimalUtils.add(approveMny, vo.getApproveMny());
						oldNum = DecimalUtils.add(oldNum, vo.getOldNum());
						construction = this.getSumStr(construction, vo.getConstruction());
						index += 1;
						sumDetailMap.get(vo.getId()).setDetailIndex(parentVO.getDetailIndex() + "." + index);// 序号
					}
					parentVO.setNum(num);
					parentVO.setMny(mny);
					parentVO.setApproveNum(approveNum);
					parentVO.setApproveMny(approveMny);
					parentVO.setOldNum(oldNum);
					parentVO.setConstruction(construction);
					sumDetailMap.put(parentVO.getId(), parentVO);
				} else {
					parentVO.setRowState("del");
//						parentVO.setDetailIndex(null);
					sumDetailMap.put(parentVO.getId(), parentVO);
					parentRow -= 1;
				}
			}
		}
		sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
		// 重新计算表头
		if(sumDetailMap.size() > 0){
			BigDecimal sumMny = null;// 汇总金额
			BigDecimal sumApproveMny = null;// 汇总审核金额
			String description = null;// 进度说明
			for(SumGrapDetailVO vo : sumDetailMap.values()){
				if(vo.getLeafFlag() == 1 && !"del".equals(vo.getRowState())){
					sumMny = DecimalUtils.add(sumMny, vo.getMny());
					sumApproveMny = DecimalUtils.add(sumApproveMny, vo.getApproveMny());
					description = this.getSumStr(description, vo.getDescription());
				}
			}
			sumGrapVO.setSumMny(sumMny);
			sumGrapVO.setSumApproveMny(sumApproveMny);
			sumGrapVO.setDescription(description);
		}
		// 非末级行不为空则修改，否则删除
		if(parentRow > 0){
			logger.info("--> 汇总后进度台账VO：" + JSONObject.toJSONString(sumGrapVO));
			sumGrapService.saveOrUpdate(sumGrapVO);
		} else {
			logger.info("--> 进度台账VO：" + sumGrapVO.getId() + "已删除");
			sumGrapService.removeById(sumGrapVO.getId(), true);
		}
		// 删除已汇总的附件
		List<AttachmentVO> grapFileList = this.queryListBySourceId(grapVO.getId(), "BT201202000000001", "imgUpload1");
		List<AttachmentVO> sumGrapFileList = this.queryListBySourceId(sumGrapVO.getId(), "BT201202000000002", "imgUpload1");
        List<AttachmentVO> grapFileList2 = this.queryListBySourceId(grapVO.getId(), "BT201202000000001", "bill");
        List<AttachmentVO> sumGrapFileList2 = this.queryListBySourceId(sumGrapVO.getId(), "BT201202000000002", "bill");
        grapFileList.addAll(grapFileList2);
        sumGrapFileList.addAll(sumGrapFileList2);
		if(CollectionUtils.isNotEmpty(grapFileList) && CollectionUtils.isNotEmpty(sumGrapFileList)){
			Map<String, AttachmentVO> grapFileMap = grapFileList.stream().collect(Collectors.toMap(AttachmentVO::getFilePath, Function.identity()));
			List<String> ids = new ArrayList<>();
			for(AttachmentVO vo : sumGrapFileList){
				if(grapFileMap.containsKey(vo.getFilePath())){
					ids.add(String.valueOf(vo.getId()));
				}
			}
			if(CollectionUtils.isNotEmpty(ids)){
				attachmentApi.delete(String.join(",", ids));
			}
		}
		return sumGrapVO;
	}

	/**
	 * 查询附件信息
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 * @return
	 */
	private List<AttachmentVO> queryListBySourceId(Long sourceId, String billType, String sourceType){
		String url = BASE_HOST + "ejc-file-web/attachment/queryListBySourceId";
		Map<String, String> params = new HashMap();
		params.put("sourceId", String.valueOf(sourceId));
		params.put("billType", billType);
		params.put("sourceType", sourceType);
		try {
			String json = HttpTookit.get(url, params, ContextHolderUtils.getRequest());
			logger.info("请求：" + url +"?params={} 响应结果：{}", params, json);
			CommonResponse<JSONObject> response = JSONObject.parseObject(json, CommonResponse.class);
			String data = response.getData().getString("data");
			List<AttachmentVO> list = (List<AttachmentVO>) JSONArray.parseArray(data, AttachmentVO.class);
			return list;
		} catch (Exception e) {
			logger.error("获取文件信息异常，", e);
			return new ArrayList<>();
		}
	}

}
