package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.bean.OddRedirectEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddRedirectService;
import com.ejianc.business.fbxt.odd.vo.OddDetailVO;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.service.IOddService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 零星用工实体
 * 
 * @author generator
 * 
 */
@Service("oddService")
public class OddServiceImpl extends BaseServiceImpl<OddMapper, OddEntity> implements IOddService{
    private static final String ODD_CODE = "ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ODD_CODE,tenantId);
                if(billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            saveorUpdateVO.setOddSource(0);
            entity = BeanMapper.map(saveorUpdateVO, OddEntity.class);
            operateType = "add";
        }

        CommonResponse<OrgVO> orgVo = orgApi.getOneById(entity.getCropId());
        if(!orgVo.isSuccess()) {
            //return CommonResponse.error("列表查询失败, 查询组织信息失败！");
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        if(null!=orgVo.getData()){
            entity.setCropSourceId(orgVo.getData().getSourceId());
        }

        List<OddInfoEntity> oddInfoEntities = BeanMapper.mapList(saveorUpdateVO.getOddInfoEntities(),OddInfoEntity.class);  // 获取清单列表实体
        List<Long> fileIds = saveorUpdateVO.getFileIds();                 // 获取实体Odd的所有字段名称
        super.saveOrUpdate(entity);                                       // 保存OddEntity实体
        //零星用工自由态即回写 ，暂存不回写  删除时释放
        if(entity.getSourceType() == 0 && entity.getOddStatus()==1){      // 零星用工申请单的update功能
            //判断申请单重复
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, entity.getId()));
            queryParam.getParams().put("oddStatus", new Parameter(QueryParam.NE, 0));
            queryParam.getParams().put("oddApplyId", new Parameter(QueryParam.EQ, entity.getOddApplyId()));
            List<OddEntity> oddEntities = super.queryList(queryParam, false);
            if(oddEntities!=null&&oddEntities.size()>0){
//                return CommonResponse.error("该用工申请单已被引用");
                throw new BusinessException("该用工申请单已被引用");
            }
            //回写
            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag,1);
            updateWrapper.set(OddApplyEntity::getOddId,entity.getId());
            updateWrapper.eq(OddApplyEntity::getId,entity.getOddApplyId());
            oddApplyService.update(updateWrapper);
        }
        if(fileIds!=null&&fileIds.size()>0){                     // 4、实体字段是否为空的判断，用于关联文件
            fileApi.updateAttachRef(entity.getId(),fileIds);
        }
        saveDetails(oddInfoEntities,entity.getId(),operateType); // 5、saveDetails() 函数，details应该是oddInfo清单项的保存，，还有oddRedirect实体
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("oddId", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<OddRedirectEntity> dddRedirectEntityes = redirectService.queryList(queryParam,false); // 6、查询出转扣实体数据

        if(dddRedirectEntityes!=null&&dddRedirectEntityes.size()>0){
            entity.setRedirectFlag(1);
            BigDecimal zkmny= new BigDecimal("0");             // 7、查询出转扣实体之后，即可计算转扣金额的总和
            for (OddRedirectEntity oddRedirectEntity : dddRedirectEntityes) {
                zkmny = oddRedirectEntity.getMny().add(zkmny);
            }
            entity.setZkmny(zkmny);
        }else{
            entity.setRedirectFlag(0);
        }
        super.saveOrUpdate(entity);
        return CommonResponse.success("保存或修改单据成功！",this.queryDetail(entity.getId()));
    }
    private void saveDetails(List<OddInfoEntity> infoList,Long oddId,String operateType){
        if("edit".equals(operateType)){
            //删除所有
            redirectService.remove(new QueryWrapper<OddRedirectEntity>().eq("odd_id", oddId));
        }
        List<OddRedirectEntity> saveRedirects = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(OddInfoEntity info:infoList){
            if("add".equals(info.getRowState())) {
                info.setOddId(oddId);
                info.setInfoNcFlag(0);
                List<OddRedirectEntity> list = info.getOddRedirectEntities();
                oddInfoService.save(info);

                if(list!=null&&list.size()>0){
                    for(OddRedirectEntity re:list){
                        re.setInfoId(info.getId());
                        re.setOddId(oddId);
                        re.setId(null);
                        re.setRedirectNcFlag(0);
                        saveRedirects.add(re);
                    }
                }
            }else if("edit".equals(info.getRowState())) {
                List<OddRedirectEntity> list = info.getOddRedirectEntities();

                if(list!=null&&list.size()>0){
                    for(OddRedirectEntity re:list){
                        re.setInfoId(info.getId());
                        re.setOddId(oddId);
                        re.setId(null);
                        re.setRedirectNcFlag(0);
                        saveRedirects.add(re);
                    }
                }
            } else if("del".equals(info.getRowState())) {
                deleteIds.add(info.getId());
            }
        }
        if(saveRedirects.size()>0){
            redirectService.saveBatch(saveRedirects);
        }
        if(deleteIds.size()>0){
            oddInfoService.removeByIds(deleteIds, false);
        }
    }


    @Override
    public void del(List<OddVO> vos) {
        List<Long> list=vos.stream().map(OddVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, list));
        List<OddEntity> oddEntities = super.queryList(queryParam,false);
        List<Long> ids=new ArrayList<>();
        for(OddEntity entity:oddEntities){
            if(entity.getSourceType()==0){
                ids.add(entity.getOddApplyId());
            }
        }
        if(ids.size()>0){
            LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddApplyEntity::getRegisterFlag,0);
            updateWrapper.set(OddApplyEntity::getOddId,null);
            updateWrapper.in(OddApplyEntity::getId,ids);
            oddApplyService.update(updateWrapper);
        }
    }

    @Override
    public OddVO queryDetail(Long id) {
    	OddEntity entity = this.selectById(id);
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = BeanMapper.map(entity, OddVO.class);
        if(infoEntities!=null&&infoEntities.size()>0){
            List<OddInfoVO> oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam=null;
            for(OddInfoVO infovo:oddInfoVOS){
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<OddRedirectEntity> redirectEntities = redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList(redirectEntities, OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }

    @Override
    public List<OddDetailVO> queryDetailsList(Page<OddDetailVO> page, QueryWrapper queryWrapper) {
        return baseMapper.queryDetailsList(page, queryWrapper);
    }

    @Override
    public OddDetailVO queryRedirect(Long infoId) {
        return baseMapper.queryRedirect(infoId);
    }

    //同步nc是否已结算
    @Override
    public CommonResponse<String> settleNc(OddSyncVo vo) {
        List<Long> yinfo = vo.getYinfo();
        List<Long> ninfo = vo.getNinfo();
        List<Long> yredirect = vo.getYredirect();
        List<Long> nredirect = vo.getNredirect();

        if(yinfo!=null&&yinfo.size()>0){
            LambdaUpdateWrapper<OddInfoEntity> yupdateWrapper = new LambdaUpdateWrapper<>();
            yupdateWrapper.set(OddInfoEntity::getInfoNcFlag,1);
            yupdateWrapper.in(OddInfoEntity::getId,yinfo);
            oddInfoService.update(yupdateWrapper);
        }
        if(ninfo!=null&&ninfo.size()>0){
            LambdaUpdateWrapper<OddInfoEntity> nupdateWrapper = new LambdaUpdateWrapper<>();
            nupdateWrapper.set(OddInfoEntity::getInfoNcFlag,0);
            nupdateWrapper.in(OddInfoEntity::getId,ninfo);
            oddInfoService.update(nupdateWrapper);
        }
        if(yredirect!=null&&yredirect.size()>0){
            LambdaUpdateWrapper<OddRedirectEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag,1);
            tupdateWrapper.in(OddRedirectEntity::getId,yredirect);
            redirectService.update(tupdateWrapper);
        }
        if(nredirect!=null&&nredirect.size()>0){
            LambdaUpdateWrapper<OddRedirectEntity> fupdateWrapper = new LambdaUpdateWrapper<>();
            fupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag,0);
            fupdateWrapper.in(OddRedirectEntity::getId,nredirect);
            redirectService.update(fupdateWrapper);
        }
        //都改成是
        Set<Long> yids=new HashSet<>();
        if(yinfo!=null&&yinfo.size()>0){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, yinfo));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            if(oddInfos!=null&&oddInfos.size()>0){
                for(OddInfoEntity infoEntity:oddInfos){
                    yids.add(infoEntity.getOddId());
                }
            }
        }
        if(yredirect!=null&&yredirect.size()>0){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, yredirect));
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if(redirects!=null&&redirects.size()>0){
                for(OddRedirectEntity redirectEntity:redirects){
                    yids.add(redirectEntity.getOddId());
                }
            }
        }
        if(yids!=null&&yids.size()>0){
            LambdaUpdateWrapper<OddEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OddEntity::getSettleNcFlag,1);
            updateWrapper.in(OddEntity::getId,yids);
            super.update(updateWrapper);
        }

        //看情况改成否
        Set<Long> nids=new HashSet<>();
        if(ninfo!=null&&ninfo.size()>0){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ninfo));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            if(oddInfos!=null&&oddInfos.size()>0){
                for(OddInfoEntity infoEntity:oddInfos){
                    nids.add(infoEntity.getOddId());
                }
            }
        }
        if(nredirect!=null&&nredirect.size()>0){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, nredirect));
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if(redirects!=null&&redirects.size()>0){
                for(OddRedirectEntity redirectEntity:redirects){
                    nids.add(redirectEntity.getOddId());
                }
            }
        }
        if(nids!=null&&nids.size()>0){
            Map<Long,Integer> map=new HashMap<>();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("oddId", new Parameter(QueryParam.IN, nids));
            List<OddInfoEntity> oddInfos = oddInfoService.queryList(queryParam, false);
            List<OddRedirectEntity> redirects = redirectService.queryList(queryParam, false);
            if(oddInfos!=null&&oddInfos.size()>0){
                for(OddInfoEntity oi:oddInfos){
                    if(!map.containsKey(oi.getOddId())){
                        map.put(oi.getOddId(),0);
                    }
                    if(oi.getInfoNcFlag()==1){//是
                        map.put(oi.getOddId(),map.get(oi.getOddId())+1);
                    }
                }
            }
            if(redirects!=null&&redirects.size()>0){
                for(OddRedirectEntity re:redirects){
                    if(!map.containsKey(re.getOddId())){
                        map.put(re.getOddId(),0);
                    }
                    if(re.getRedirectNcFlag()==1){//是
                        map.put(re.getOddId(),map.get(re.getOddId())+1);
                    }
                }
            }
            List<Long> oddids=new ArrayList<>();
            for(Long key:map.keySet()){
                if(map.get(key)==0){
                    oddids.add(key);
                }
            }
            if(oddids!=null&&oddids.size()>0){
                LambdaUpdateWrapper<OddEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(OddEntity::getSettleNcFlag,0);
                updateWrapper.in(OddEntity::getId,oddids);
                super.update(updateWrapper);
            }
        }
        return CommonResponse.success("同步成功！");
    }
}
