/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.mapper.OddApplyMapper;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.vo.OddApplyVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddApplyRequest;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="oddApplyService")
public class OddApplyServiceImpl
extends BaseServiceImpl<OddApplyMapper, OddApplyEntity>
implements IOddApplyService {
    private static final String ODD_APPLY = "ODD_APPLY";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${openApi.wjOddApplyUrl}")
    private String wjOddApplyUrl;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<OddApplyVO> saveOrUpdate(OddApplyVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddApplyEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddApplyEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_APPLY, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OddApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddApplyEntity.class));
            operateType = "add";
        }
        CommonResponse orgVo = this.orgApi.getOneById(entity.getOrgId());
        if (!orgVo.isSuccess()) {
            return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setOrgSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        if (entity.getCropId() != null) {
            CommonResponse cropVo = this.orgApi.getOneById(entity.getCropId());
            if (!cropVo.isSuccess()) {
                return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null != cropVo.getData()) {
                entity.setCropSourceId(((OrgVO)cropVo.getData()).getSourceId());
            }
        }
        entity.setRegisterFlag(0);
        super.saveOrUpdate((Object)entity, false);
        OddApplyVO vo = (OddApplyVO)BeanMapper.map((Object)((Object)entity), OddApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public Boolean applyUsed(ApplyRequest request) {
        if (request.getIsused() != null && request.getIsused() == 0) {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)0);
            tupdateWrapper.set(OddApplyEntity::getOddId, null);
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
        } else {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)1);
            tupdateWrapper.set(OddApplyEntity::getOddId, (Object)request.getPkOdd());
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
        }
        return true;
    }

    @Override
    public Boolean suplcommit(OddApplyRequest request) {
        List bcFileList;
        LambdaUpdateWrapper tupdateWrapper;
        if (request.getOddStatus() != null && request.getOddStatus() == 1) {
            tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, (Object)2);
            tupdateWrapper.set(OddApplyEntity::getManager, (Object)request.getManager());
            tupdateWrapper.set(OddApplyEntity::getManagname, (Object)request.getManagname());
            tupdateWrapper.set(OddApplyEntity::getOpinion, (Object)request.getOpinion());
            tupdateWrapper.set(OddApplyEntity::getBillState, (Object)0);
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
        } else {
            tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, (Object)1);
            tupdateWrapper.set(OddApplyEntity::getManager, (Object)request.getManager());
            tupdateWrapper.set(OddApplyEntity::getManagname, (Object)request.getManagname());
            tupdateWrapper.set(OddApplyEntity::getOpinion, (Object)request.getOpinion());
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
        }
        String billType = "BT201123000000001";
        String sourceTypebc = "oddapplybc";
        CommonResponse fileResponse = this.attachmentApi.queryListBySourceId(request.getPkOddApply(), billType, sourceTypebc, null);
        if (fileResponse.isSuccess() && fileResponse.getData() != null && ((List)fileResponse.getData()).size() > 0) {
            List fileIds = ((List)fileResponse.getData()).stream().map(AttachmentVO::getId).collect(Collectors.toList());
            this.attachmentApi.delete(StringUtils.join(fileIds, (String)","));
        }
        if ((bcFileList = request.getBcfileList()) != null && bcFileList.size() > 0) {
            ArrayList<AttachmentVO> fileList = new ArrayList<AttachmentVO>();
            for (FileRelation f : bcFileList) {
                AttachmentVO file = new AttachmentVO();
                file.setBillType(billType);
                file.setSourceId(request.getPkOddApply());
                file.setSourceType(sourceTypebc);
                file.setFileName(f.getFileName());
                file.setFilePath(f.getFilePath());
                fileList.add(file);
            }
            this.attachmentApi.insertBatch(fileList);
        }
        return true;
    }

    @Override
    public CommonResponse<String> pushOddApply(Map<String, String> headers, OddApplyRequest copy) {
        String url = this.wjOddApplyUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }
}

