/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fbxt.odd.bean.OddImportEntity;
import com.ejianc.business.fbxt.odd.bean.OddImportInfoEntity;
import com.ejianc.business.fbxt.odd.mapper.OddImportMapper;
import com.ejianc.business.fbxt.odd.service.IOddImportInfoService;
import com.ejianc.business.fbxt.odd.service.IOddImportService;
import com.ejianc.business.fbxt.odd.vo.OddImportInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddImportVO;
import com.ejianc.business.fbxt.util.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="oddImportService")
public class OddImportServiceImpl
extends BaseServiceImpl<OddImportMapper, OddImportEntity>
implements IOddImportService {
    private static final String ODD_IMPORT = "ODD_IMPORT";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddImportInfoService infoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<OddImportVO> saveOrUpdate(OddImportVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddImportEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddImportEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddImportEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_IMPORT, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            saveorUpdateVO.setOddSource(Integer.valueOf(0));
            saveorUpdateVO.setImportFlag(Integer.valueOf(1));
            entity = (OddImportEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddImportEntity.class));
            operateType = "add";
        }
        CommonResponse orgVo = this.orgApi.getOneById(entity.getCropId());
        if (!orgVo.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setCropSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        super.saveOrUpdate((Object)entity, false);
        List<OddImportInfoEntity> infoList = entity.getInfoVOList();
        for (OddImportInfoEntity infoEntity : infoList) {
            infoEntity.setOddId(entity.getId());
            infoEntity.setInfoNcFlag(0);
        }
        if (CollectionUtil.isNotEmpty(infoList)) {
            this.infoService.saveOrUpdateBatch(infoList, infoList.size(), false);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public OddImportVO queryDetail(Long id) {
        OddImportEntity entity = (OddImportEntity)((Object)this.selectById(id));
        return (OddImportVO)BeanMapper.map((Object)((Object)entity), OddImportVO.class);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            ArrayList<OddImportInfoVO> successList = new ArrayList<OddImportInfoVO>();
            ArrayList<OddImportInfoVO> errorList = new ArrayList<OddImportInfoVO>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < result.size(); ++i) {
                Date tDate;
                Double par;
                List datas = (List)result.get(i);
                OddImportInfoVO vo = new OddImportInfoVO();
                vo.setExcelIndex(Integer.valueOf(i + 2));
                String warnType = "";
                boolean flag = false;
                String name = (String)datas.get(0);
                String code = (String)datas.get(1);
                String infoUnit = (String)datas.get(2);
                String num = (String)datas.get(3);
                String price = (String)datas.get(4);
                String mny = (String)datas.get(5);
                String beginTime = (String)datas.get(6);
                String endTime = (String)datas.get(7);
                long id = IdWorker.getId();
                vo.setId(Long.valueOf(id));
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "[\u7528\u5de5\u9879\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setName(name);
                }
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                    warnType = warnType + "[\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setCode(name);
                }
                if (StringUtils.isEmpty((CharSequence)infoUnit)) {
                    vo.setInfoUnit(null);
                    warnType = warnType + "[\u5355\u4f4d\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setInfoUnit(infoUnit);
                }
                if (StringUtils.isEmpty((CharSequence)num)) {
                    vo.setNum(null);
                    warnType = warnType + "[\u6570\u91cf\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setNum(new BigDecimal(num));
                }
                if (StringUtils.isEmpty((CharSequence)price)) {
                    vo.setPrice(null);
                    warnType = warnType + "[\u6570\u91cf\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setPrice(new BigDecimal(price));
                }
                String beginDate = null;
                String endDate = null;
                try {
                    par = Double.parseDouble(beginTime);
                    tDate = OddImportServiceImpl.DoubleToDate(par);
                    beginDate = sdf.format(tDate);
                }
                catch (NumberFormatException e) {
                    beginDate = beginTime;
                    this.logger.info("\u5f00\u59cb\u65f6\u95f4\u4e0d\u662f\u65e5\u671f\u683c\u5f0f");
                }
                try {
                    par = Double.parseDouble(endTime);
                    tDate = OddImportServiceImpl.DoubleToDate(par);
                    endDate = sdf.format(tDate);
                }
                catch (NumberFormatException e) {
                    endDate = endTime;
                    this.logger.info("\u7ed3\u675f\u65f6\u95f4\u4e0d\u662f\u65e5\u671f\u683c\u5f0f");
                }
                vo.setMny(MathUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getPrice()));
                vo.setBeginTime((Date)DateUtil.parse((String)beginDate));
                vo.setEndTime((Date)DateUtil.parse((String)endDate));
                vo.setSourceType(Integer.valueOf(1));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setRowState("add");
                if (flag) {
                    vo.setWarnType(warnType.substring(0, warnType.length() - 1));
                    errorList.add(vo);
                    continue;
                }
                successList.add(vo);
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000;
        tDate.setTime((long)((dVal - 25569.0) * 24.0 * 3600.0 * 1000.0 + (double)localOffset));
        return tDate;
    }
}

