package com.ejianc.business.fbxt.grap.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.fbxt.grap.bean.GrapDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 进度计量实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_fbxt_grap")
public class GrapEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="crop_id")
    private Long cropId; // 项目所属组织id
    @TableField(value = "crop_name")
    private String cropName; // 项目所属组织名称
    @TableField(value="crop_source_id")
    private String cropSourceId; // 项目所属组织来源id
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_source_id")
    private String orgSourceId; // 组织来源ID
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="contract_id")
    private String contractId; // 合同主键
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="supplier_id")
    private Long supplierId; // 设备供应商
    @TableField(value="supplier_source_id")
    private String supplierSourceId; // 供应商来源ID
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="history_flag")
    private Integer historyFlag; // 是否历史数据1-是，0-否
    @TableField(value="history_id")
    private String historyId; // 来源主键
    @TableField(value="history_system")
    private String historySystem; // 来源系统
    @TableField(value="use_state")
    private Integer useState; // 是否已汇总，0-未汇总，1-已汇总
    @TableField(value="save_state")
    private Integer saveState; // 保存状态（0-暂存态，1-保存态）
    @TableField(value="sum_mny")
    private java.math.BigDecimal sumMny; // 总计金额
    @TableField(value="construction")
    private String construction; // 施工部位
    @TableField(value="description")
    private String description; // 进度说明
    @TableField(value = "create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 编制日期
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者主键
    @TableField(value="create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value="sum_grap_id")
    private Long sumGrapId; // 汇总进度台账主键
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="grapDetailService",pidName = "grapId")
    private List<GrapDetailEntity> detailList = new ArrayList<>(); // 进度计量子表实体
    

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目来源ID
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源ID
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目所属组织id
     */
    public Long getCropId() {
        return cropId;
    }

    /**
     * 项目所属组织id
     */
    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    /**
     * 项目所属组织名称
     */
    public String getCropName() {
        return cropName;
    }

    /**
     * 项目所属组织名称
     */
    public void setCropName(String cropName) {
        this.cropName = cropName;
    }
    /**
     * 项目所属组织来源id
     */
    public String getCropSourceId() {
        return cropSourceId;
    }
    /**
     * 项目所属组织来源id
     */
    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }

    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源ID
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源ID
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同主键
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商来源ID
     */
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    /**
     * 供应商来源ID
     */
    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 是否历史数据1-是，0-否
     */
    public Integer getHistoryFlag() {
        return historyFlag;
    }

    /**
     * 是否历史数据1-是，0-否
     */
    public void setHistoryFlag(Integer historyFlag) {
        this.historyFlag = historyFlag;
    }
    /**
     * 来源主键
     */
    public String getHistoryId() {
        return historyId;
    }

    /**
     * 来源主键
     */
    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }
    /**
     * 来源系统
     */
    public String getHistorySystem() {
        return historySystem;
    }

    /**
     * 来源系统
     */
    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }
    /**
     * 是否已汇总，0-未汇总，1-已汇总
     */
    public Integer getUseState() {
        return useState;
    }

    /**
     * 是否已汇总，0-未汇总，1-已汇总
     */
    public void setUseState(Integer useState) {
        this.useState = useState;
    }
    /**
     * 保存状态（0-暂存态，1-保存态）
     */
    public Integer getSaveState() {
        return saveState;
    }

    /**
     * 保存状态（0-暂存态，1-保存态）
     */
    public void setSaveState(Integer saveState) {
        this.saveState = saveState;
    }
    /**
     * 总计金额
     */
    public java.math.BigDecimal getSumMny() {
        return sumMny;
    }

    /**
     * 总计金额
     */
    public void setSumMny(java.math.BigDecimal sumMny) {
        this.sumMny = sumMny;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 进度说明
     */
    public String getDescription() {
        return description;
    }

    /**
     * 进度说明
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 编制日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 创建者主键
     */
    public Long getCreateUserId() {
        return createUserId;
    }

    /**
     * 创建者主键
     */
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    /**
     * 创建者名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建者名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 汇总进度台账主键
     */
    public Long getSumGrapId() {
        return sumGrapId;
    }

    /**
     * 汇总进度台账主键
     */
    public void setSumGrapId(Long sumGrapId) {
        this.sumGrapId = sumGrapId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    /**
     * 进度计量子表实体
     */
    public List<GrapDetailEntity> getDetailList() {
        return detailList;
    }

    /**
     * 进度计量子表实体
     */
    public void setDetailList(List<GrapDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
