package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.bean.SumGrapDetailEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.mapper.SumGrapMapper;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.sync.api.IGrapSyncApi;
import com.ejianc.business.sync.cons.ModelCodeCons;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * 进度台账实体
 * 
 * @author generator
 * 
 */
@Service("sumGrapService")
public class SumGrapServiceImpl extends BaseServiceImpl<SumGrapMapper, SumGrapEntity> implements ISumGrapService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String FBXT_SUM_GRAP = "FBXT_SUM_GRAP";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IGrapSyncApi grapSyncApi;

    @Override
    public SumGrapVO saveOrUpdate(SumGrapVO saveorUpdateVO) {
        SumGrapEntity entity = BeanMapper.map(saveorUpdateVO, SumGrapEntity.class);
        // 处理树形子表
        List<SumGrapDetailVO> detailList = saveorUpdateVO.getDetailList();
        List<SumGrapDetailVO> childList = new ArrayList<>();
        for(SumGrapDetailVO detail : detailList){
            if(CollectionUtils.isNotEmpty(detail.getChildren())){
                childList.addAll(detail.getChildren());
            }
        }
        if(CollectionUtils.isNotEmpty(childList)){
            detailList.addAll(childList);
        }
        entity.setDetailList(BeanMapper.mapList(detailList, SumGrapDetailEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(FBXT_SUM_GRAP, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public SumGrapVO queryDetail(Long id) {
        SumGrapEntity entity = super.selectById(id);
        SumGrapVO vo = BeanMapper.map(entity, SumGrapVO.class);
        List<SumGrapDetailVO> list = new ArrayList<>();
        List<SumGrapDetailVO> detailList = vo.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(item -> {
                if(item.getParentId() == null){
                    list.add(item);
                }
            });
            list.forEach(item -> {
                List<SumGrapDetailVO> listd = new ArrayList<>();
                detailList.forEach(e -> {
                    if(item.getId().equals(e.getParentId())){
                        listd.add(e);
                    }
                });
                Collections.sort(listd, new Comparator<SumGrapDetailVO>() {
                    @Override
                    public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                        Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000 - Double.valueOf(o2.getDetailIndex()) * 10000;
                        int i = vlaue.intValue();
                        return i;
                    }
                });
                item.setChildren(listd);
            });
            Collections.sort(list, new Comparator<SumGrapDetailVO>() {
                @Override
                public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                    Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000 - Double.valueOf(o2.getDetailIndex()) * 10000;
                    int i = vlaue.intValue();
                    return i;
                }
            });
            vo.setDetailList(list);
        }
        return vo;
    }

    @Override
    public CommonResponse syncUseState(HttpServletRequest request) {
        logger.info("--> 同步NC中间表开始");
        String param = request.getParameter("param");
        JSONArray jsonArray = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是：" + param + "----");
        int day = jsonArray.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是：" + day + "----");
//        CommonResponse<List> response = grapSyncApi.getSyncImgList();
        CommonResponse<List> response = grapSyncApi.selectStatus(day);
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        logger.info("--> 获取NC中间表数据:" + JSONObject.toJSONString(response));
        List list = response.getData();
        List<Long> yids = new ArrayList<>();
        List<Long> nids = new ArrayList<>();
        for(int i = 0 ; i < list.size(); i++){
            Object obj = list.get(i);
            String str = obj != null ? JSONObject.toJSONString(obj) : "";
            JSONObject json = JSON.parseObject(str);
            String CSRCID = json.getString("CSRCID");
            String BISSETTLE = json.getString("BISSETTLE");
            if(StringUtils.isNotEmpty(CSRCID) && CSRCID.startsWith(ModelCodeCons.NC_JD)){
                Long id = Long.valueOf(CSRCID.substring(ModelCodeCons.NC_JD.length()));
                if("Y".equals(BISSETTLE)){
                    yids.add(id);
                } else {
                    nids.add(id);
                }
            }
        }
        logger.info("--> yids:" + JSONObject.toJSONString(yids));
        logger.info("--> nids:" + JSONObject.toJSONString(nids));
        if(CollectionUtils.isNotEmpty(yids)){
            LambdaUpdateWrapper<SumGrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(SumGrapEntity::getId, yids);
            updateWrapper.set(SumGrapEntity::getUseState, 1);
            super.update(updateWrapper);
        }
        if(CollectionUtils.isNotEmpty(nids)){
            LambdaUpdateWrapper<SumGrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(SumGrapEntity::getId, nids);
            updateWrapper.set(SumGrapEntity::getUseState, 0);
            super.update(updateWrapper);
        }
        return CommonResponse.success("执行成功！");
    }
}
