package com.ejianc.business.fbxt.comment.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fbxt.comment.bean.FbxtCommentEntity;
import com.ejianc.business.fbxt.comment.service.IFbxtCommentService;
import com.ejianc.business.fbxt.comment.vo.FbxtCommentVO;

/**
 * 分包协同审批历史实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("fbxtComment")
public class FbxtCommentController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IFbxtCommentService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FbxtCommentVO> saveOrUpdate(@RequestBody FbxtCommentVO saveorUpdateVO) {
    	FbxtCommentEntity entity = BeanMapper.map(saveorUpdateVO, FbxtCommentEntity.class);
    	service.saveOrUpdate(entity, false);
    	FbxtCommentVO vo = BeanMapper.map(entity, FbxtCommentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FbxtCommentVO> queryDetail(Long id) {
    	FbxtCommentEntity entity = service.selectById(id);
    	FbxtCommentVO vo = BeanMapper.map(entity, FbxtCommentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 根据业务主键查询审批历史
     */
    @RequestMapping(value = "/getListByPkBiz", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<FbxtCommentVO>> getListByPkBiz(Long pkBiz) {
        LambdaQueryWrapper<FbxtCommentEntity> queryWrapper = Wrappers.<FbxtCommentEntity>lambdaQuery();
        queryWrapper.eq(FbxtCommentEntity::getPkBiz, pkBiz);
        queryWrapper.orderByAsc(FbxtCommentEntity::getTs);
        List<FbxtCommentEntity> list = service.list(queryWrapper);
        List<FbxtCommentVO> planCommentVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            planCommentVOList = BeanMapper.mapList(list, FbxtCommentVO.class);
            for(int i = 0; i < planCommentVOList.size(); i++){
                planCommentVOList.get(i).setId(Long.valueOf(i));
            }
        }
        return CommonResponse.success("查询成功！",planCommentVOList);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FbxtCommentVO> vos) {
        service.removeByIds(vos.stream().map(FbxtCommentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FbxtCommentVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<FbxtCommentEntity> page = service.queryPage(param,false);
        IPage<FbxtCommentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FbxtCommentVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
