package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.vo.*;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.grap.mapper.GrapMapper;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.foundation.file.vo.AttachmentVO;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 进度计量实体
 * 
 * @author generator
 * 
 */
@Service("grapService")
public class GrapServiceImpl extends BaseServiceImpl<GrapMapper, GrapEntity> implements IGrapService{

    private static final String FBXT_GRAP = "FBXT_GRAP";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi iProjectApi;

    @Autowired
    private ISupplierApi iSupplierApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjAssUpApplyUrl}")
    private String wjAssUpApplyUrl;

    @Value("${img.serverPath}")
    private String serverPath;

    @Override
    public GrapVO saveOrUpdate(GrapVO saveorUpdateVO) {
        saveorUpdateVO.setSource("0");//记录来源   0是自制  1是供方
        GrapEntity entity = BeanMapper.map(saveorUpdateVO, GrapEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(FBXT_GRAP, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getCropId() != null){
            //查询项目部上级组织的的来源id
            CommonResponse<OrgVO> orgVO = orgApi.getOneById(entity.getCropId());
            if(!orgVO.isSuccess()) {
                throw new BusinessException("网络异常， 查询组织失败， 请稍后再试");
            }
            entity.setCropSourceId(orgVO.getData().getSourceId());
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, GrapVO.class);
    }
    @Override
    public Long assSaveOrUpdate(AssignmrnyBookVO assignmrnyBookVO) {
        ProjectRegisterVO projectRegisterVO =new ProjectRegisterVO();
        if(assignmrnyBookVO.getPkProject()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<ProjectRegisterVO> ponse =  iProjectApi.queryProjectBySourceId(assignmrnyBookVO.getPkProject());
            if(ponse.getData()==null) {
                throw new BusinessException("网络异常， 查询失败，请稍后再试");
            }
            projectRegisterVO=ponse.getData();
        }
        GrapVO grapVO=new GrapVO();
        //主表
        Long projectId =  projectRegisterVO.getId();
        grapVO.setCropId(projectRegisterVO.getOrgId());//项目所属组织id
        grapVO.setCropName(projectRegisterVO.getOrgName());
        grapVO.setCropSourceId(assignmrnyBookVO.getPkOrg());//项目所属组织来源id
        grapVO.setOrgId(projectRegisterVO.getProjectDepartmentId());//组织
        OrgVO orgVO =new OrgVO();
        if(projectRegisterVO.getProjectDepartmentId()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<OrgVO> orgVOCommonResponse = orgApi.getOneById(projectRegisterVO.getProjectDepartmentId());
            if(!orgVOCommonResponse.isSuccess()) {
                throw new BusinessException("网络异常， 查询组织失败， 请稍后再试");
            }
            orgVO = orgVOCommonResponse.getData();
        }
        grapVO.setOrgName(orgVO.getName());//组织名称
        grapVO.setOrgSourceId(orgVO.getSourceId());//组织来源id
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());//单据编号
        if(assignmrnyBookVO.getPkProject()!=null){
            grapVO.setProjectSourceId(assignmrnyBookVO.getPkProject());//项目来源Id
        }
        grapVO.setProjectId(projectId); //项目主键
        grapVO.setProjectName(assignmrnyBookVO.getProjectName());//项目名称
        grapVO.setContractId(assignmrnyBookVO.getPkContract()); //合同主键
        grapVO.setContractName(assignmrnyBookVO.getContractName()); // 合同名称
        grapVO.setSaveState(01);
        grapVO.setContractCode(assignmrnyBookVO.getContractCode());//合同编码
         //合同编码contract_code
        grapVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());//单据状态
        grapVO.setDescription(assignmrnyBookVO.getMemo());// 进度说明 description
        grapVO.setSource("1");//记录来源   0是自制  1是供方
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());//单据编号
        SupplierVO supplierVO =new SupplierVO();
        if(assignmrnyBookVO.getPkSupplier()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<SupplierVO> supplier =  iSupplierApi.queryBySourceId(assignmrnyBookVO.getPkSupplier());
           /* if(supplier.getData()==null) {
                throw new BusinessException("网络异常， 查询失败， 请稍后再试");
            }*/
            supplierVO=supplier.getData();
        }
      //  grapVO.setSupplierId(supplierVO.getId());    //数据类型待确认----------------------------------------------------
        grapVO.setSourceId(assignmrnyBookVO.getPkAssignmentBook());//供应商主键   现在传得是供方主键
//        grapVO.setSupplierName(supplierVO.getName());//供应商名称
        grapVO.setSupplierSourceId(assignmrnyBookVO.getPkSupplier());// 来源Id/主表Id
        grapVO.setConstruction(assignmrnyBookVO.getConstruction());//主表施工部位
        grapVO.setFeedback(assignmrnyBookVO.getFeedback());//存疑退回意见
        grapVO.setPkCreator(assignmrnyBookVO.getPkCreator());//编制人
        grapVO.setCreateDate(assignmrnyBookVO.getCreatorTime());//编制日期create_date
        grapVO.setSumMny(assignmrnyBookVO.getSumMany());//总计金额
        grapVO.setSaveState(0);//推送到五局默认暂存态度
        //子表
        List<GrapDetailVO> detailList = new ArrayList<>();
        for (AssignmentInfoVO assignmentInfoVO : assignmrnyBookVO.getAssInfoList()) {
            GrapDetailVO grapDetil = new GrapDetailVO();
            //grapDetil.setInfoCode(assignmentInfoVO.getPkBookInfo());//清单编码-----------------------------------------------------------------
            grapDetil.setInfoCode(assignmentInfoVO.getInfoCode());// 清单编码
            grapDetil.setInfoName(assignmentInfoVO.getInfoName());// 清单名称 infoName
            grapDetil.setUnit(assignmentInfoVO.getInfoUnit());// 单位
            ////  五局数量 存放 供方完成量  五局供方完成量 就存供方完成量
            grapDetil.setNum(assignmentInfoVO.getInfoCount());// 数量
            grapDetil.setPcaAmout(assignmentInfoVO.getInfoCount());
            grapDetil.setPrice(assignmentInfoVO.getPrice());// // 无税单价 price
            grapDetil.setMny(assignmentInfoVO.getMny());// // mny; // 金额
            grapDetil.setSite(assignmentInfoVO.getInfoSite());//施工部位
            detailList.add(grapDetil);
        }
        grapVO.setDetailList(detailList);
        GrapEntity entity = BeanMapper.map(grapVO, GrapEntity.class);
        boolean flat;
        flat=super.saveOrUpdate(entity, false);

        List<FileVO> fileVOList =assignmrnyBookVO.getFileList();
        if(fileVOList.size()!=0){
            flat=saveFile(fileVOList,entity.getId());
        }

        return entity.getId();
    }
    //保存推送照片信息
    public boolean saveFile(List<FileVO> fileVOList,Long id){
        //图片信息
        List<AttachmentVO> attachmentList = new ArrayList<>();
        for (FileVO fileVO : fileVOList) {
            AttachmentVO attachmentVO=new AttachmentVO();
            attachmentVO.setBillType("BT201202000000001");
            attachmentVO.setFileName(fileVO.getFileName());//文件名称
            attachmentVO.setFilePath(fileVO.getFilePath());//文件路径
            attachmentVO.setImgServerPath(serverPath);//服务地址路径
            attachmentVO.setOnlinePath(serverPath+fileVO.getFilePath());
            //所属模块主键
            attachmentVO.setSourceId(id);//所属模块主键
            attachmentVO.setSourceType("imgUpload1");
            attachmentVO.setTruePath(serverPath+fileVO.getFilePath());
            attachmentVO.setUploadUserName(" 供方平台");
            attachmentList.add(attachmentVO);
        }
        CommonResponse<String> flag = iAttachmentApi.insertBatch(attachmentList);
        if(!flag.getMsg().equals("新增成功") ){
            throw new BusinessException(flag.getMsg());
        }
        return true;
    }
    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if (redisTemplate.opsForValue().get("X-Open-Token") != null) {
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------" + redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        } else {
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if ("200".equals(json.get("code").toString())) {
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token, 6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                } else {
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常" + e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public Boolean sendMsg(BillStateVO billStateVO) {
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = pushOddJob(headers, billStateVO);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
        return true;
    }

    public CommonResponse<String> pushOddJob(Map<String, String> headers, BillStateVO copy) {
        String url = wjAssUpApplyUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }
}
