package com.ejianc.business.fbxt.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.concurrent.TimeUnit;

@Component
public class MsgUtil {
    private final Logger logger = LoggerFactory.getLogger(getClass());

//    @Value("${weChat.cgdd-agentid}")
//    private String cgddAgentid;
//
//    @Value("${weChat.cgdd-secret}")
//    private String cgddSecret;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Autowired
    private IPushMessageApi pushMessageApi;

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, Long id) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            //channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        if (messageType.contains("wjyApply") || messageType.contains("wjyOdd")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");// 系统管理员特殊处理
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        /*if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", cgddAgentid);
            weixineeParams.put("secret", cgddSecret);
//            weixineeParams.put("content", subject);
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", "消息提醒");
            weixineeParams.put("description", subject);
            weixineeParams.put("url", mobileUrl);
            weixineeParams.put("btntxt", "点击查看");

            parameter.setWeixineeParams(weixineeParams);
        }*/
        if (messageType.contains("wjyApply")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath + "cscec5b-fbxt-mobile/#/oddapply/card?id=" + id + "&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        if (messageType.contains("wjyOdd")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath + "cscec5b-fbxt-mobile/#/odd/card?id=" + id + "&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            logger.info("发送信息{}", JSONObject.toJSONString(parameter));
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    public String getCreateUserId(String createUserCode) {
        try {
            MetaDataUrlconstants urlconstants = (MetaDataUrlconstants) ContextUtil.getBean(MetaDataUrlconstants.class);
            if (StringUtils.isNotBlank(createUserCode) && StringUtils.isNotBlank(urlconstants.getBaseHost())) {
                String cacheKey = "refer_cache_key:idm-employee:" + createUserCode;
                RedisTemplate<String, Object> redisTemplate = (RedisTemplate) ContextUtil.getBean("redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject(cacheValue.toString());
                } else {
                    String referData = getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject(referData);
                    String referUrl = json.get("projectName").toString();
                    new HashMap();
                    Map<String, Object> reflist = (Map) json.get("refMapList");
                    reflist.put("userCode", createUserCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;

                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
                    } catch (Exception var13) {
                        ;
                    }

                    if (StringUtils.isNotBlank(jsonbackstr)) {
                        jsonObject = JSON.parseObject(jsonbackstr);
                        redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 5L, TimeUnit.DAYS);
                    }
                }

                if (jsonObject != null) {
                    return jsonObject.getString("id");
                }
            }
        } catch (Exception var14) {
            ;
        }

        return createUserCode;
    }

    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = (MetaDataUrlconstants) ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;

        try {
            backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, (Map) null);
        } catch (Exception var5) {
            ;
        }

        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject(jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
        }

        return data;
    }
}
