/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.fbxt.grap.Enum.BillSourceEnum;
import com.ejianc.business.fbxt.grap.Enum.ConfirmStatusEnum;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapDetailService;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapDetailService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.AssignmentInfoVO;
import com.ejianc.business.fbxt.grap.vo.GrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.grap.vo.SupplierConfirmVO;
import com.ejianc.business.fbxt.util.ContextHolderUtils;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="grap")
public class GrapBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IGrapService grapService;
    @Autowired
    private IGrapDetailService grapDetailService;
    @Autowired
    private ISumGrapService sumGrapService;
    @Autowired
    private ISumGrapDetailService sumGrapDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IGrapService iGrapService;
    @Autowired
    private IUserApi userApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        GrapEntity entity = (GrapEntity)((Object)this.grapService.selectById(billId));
        if (StringUtils.isNotBlank((String)entity.getSourceId()) && StringUtils.isNotBlank((String)entity.getSource()) && BillSourceEnum.\u4f9b\u65b9\u63a8\u9001.getCode().equals(entity.getSource())) {
            entity.setConfirmer(String.valueOf(InvocationInfoProxy.getUserid()));
            entity.setConfirmerName(((UserVO)this.userApi.findUserByUserId(InvocationInfoProxy.getUserid()).getData()).getUserName());
            entity.setFeedback("\u786e\u8ba4\u901a\u8fc7");
            entity.setConfirmerData(new Date());
            this.grapService.updateById((Object)entity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public synchronized CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        GrapEntity entity = (GrapEntity)((Object)this.grapService.selectById(billId));
        GrapVO grapVO = (GrapVO)BeanMapper.map((Object)((Object)entity), GrapVO.class);
        if (grapVO.getSumGrapId() == null) {
            SumGrapVO sumGrapVO = this.pushToSumGrap(grapVO);
            entity.setSumGrapId(sumGrapVO.getId());
            this.grapService.updateById((Object)entity);
            this.logger.info("--> \u5355\u636e\uff1a" + billId + "\u5df2\u6c47\u603b\u5230\uff1a" + entity.getSumGrapId());
        }
        if (StringUtils.isNotBlank((String)grapVO.getSourceId()) && StringUtils.isNotBlank((String)grapVO.getSource()) && BillSourceEnum.\u4f9b\u65b9\u63a8\u9001.getCode().equals(grapVO.getSource())) {
            SupplierConfirmVO billStateVO = new SupplierConfirmVO();
            billStateVO.setId(billId);
            billStateVO.setBillState(ConfirmStatusEnum.\u786e\u8ba4\u901a\u8fc7.getCode());
            String confirmer = StringUtils.isNotBlank((String)entity.getConfirmer()) ? entity.getConfirmer() : String.valueOf(InvocationInfoProxy.getUserid());
            billStateVO.setConfirmer(confirmer);
            String confirmerName = StringUtils.isNotBlank((String)entity.getConfirmerName()) ? entity.getConfirmerName() : ((UserVO)this.userApi.findUserByUserId(InvocationInfoProxy.getUserid()).getData()).getUserName();
            billStateVO.setConfirmerName(confirmerName);
            billStateVO.setFeedback("\u786e\u8ba4\u901a\u8fc7");
            billStateVO.setPkAssignmentBook(grapVO.getSourceId());
            billStateVO.setFlag(Integer.valueOf(1));
            ArrayList<AssignmentInfoVO> assignmentInfoVOList = new ArrayList<AssignmentInfoVO>();
            for (GrapDetailVO grapDetailVO : grapVO.getDetailList()) {
                AssignmentInfoVO assignmentInfoVO = new AssignmentInfoVO();
                assignmentInfoVO.setPkBookInfo(grapDetailVO.getSourceId());
                assignmentInfoVO.setInfoProjectNumber(grapDetailVO.getNum());
                assignmentInfoVOList.add(assignmentInfoVO);
                System.out.println(grapDetailVO.getSourceId() + "getSourceId999999999999999999999999999999999999999999999999999999999999999999");
                System.out.println(assignmentInfoVO.getPkBookInfo() + "getPkBookInfo999999999999999999999999999999999999999999999999999999999999999999");
                System.out.println(assignmentInfoVO.getInfoProjectNumber() + "getInfoProjectNumber999999999999999999999999999999999999999999999999999999999999999999");
                System.out.println(grapDetailVO.getNum() + "getNum999999999999999999999999999999999999999999999999999999999999999999");
            }
            System.out.println(billStateVO.getFlag() + "getFlag999999999999999999999999999999999999999999999999999999999999999999");
            billStateVO.setAssInfoList(assignmentInfoVOList);
            this.iGrapService.supplierConfirm(billStateVO);
        }
        return CommonResponse.success();
    }

    private SumGrapVO pushToSumGrap(GrapVO grapVO) {
        this.logger.info("--> \u5355\u636e\uff1a" + grapVO.getId() + "\u6c47\u603b\u5f00\u59cb");
        List detailList = grapVO.getDetailList();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SumGrapEntity::getContractId, (Object)grapVO.getContractId());
        wrapper.and(x -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(SumGrapEntity::getBillState, (Object)0)).or()).eq(SumGrapEntity::getBillState, (Object)4));
        List sumGrapList = this.sumGrapService.list((Wrapper)wrapper);
        SumGrapVO sumGrapVO = null;
        HashMap<String, SumGrapDetailVO> parentMap = new HashMap<String, SumGrapDetailVO>();
        HashMap<Long, SumGrapDetailVO> sumDetailMap = new HashMap<Long, SumGrapDetailVO>();
        boolean isSum = false;
        if (CollectionUtils.isEmpty((Collection)sumGrapList)) {
            sumGrapVO = this.getSumGrapVO(grapVO);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                for (GrapDetailVO detail : detailList) {
                    this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
                }
                sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
            }
            sumGrapVO = this.sumGrapService.saveOrUpdate(sumGrapVO);
        } else {
            SumGrapEntity sumGrapEntity = (SumGrapEntity)((Object)this.sumGrapService.selectById(((SumGrapEntity)((Object)sumGrapList.get(0))).getId()));
            sumGrapVO = (SumGrapVO)BeanMapper.map((Object)((Object)sumGrapEntity), SumGrapVO.class);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                List detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x != null).collect(Collectors.toList());
                for (GrapDetailVO detail : detailList) {
                    if (!detailIds.contains(detail.getId())) continue;
                    isSum = true;
                }
            }
            if (!isSum) {
                sumGrapVO.setDescription(this.getSumStr(sumGrapVO.getDescription(), grapVO.getDescription()));
                sumGrapVO.setSumMny(DecimalUtils.add((BigDecimal)sumGrapVO.getSumMny(), (BigDecimal)grapVO.getSumMny()));
                sumGrapVO.setSumApproveMny(DecimalUtils.add((BigDecimal)sumGrapVO.getSumApproveMny(), (BigDecimal)grapVO.getSumMny()));
                List sumDetailList = sumGrapVO.getDetailList();
                for (GrapDetailVO detail : sumDetailList) {
                    if (detail.getLeafFlag() == 0 && !parentMap.containsKey(detail.getInfoId())) {
                        parentMap.put(detail.getInfoId(), (SumGrapDetailVO)detail);
                    }
                    if (sumDetailMap.containsKey(detail.getId())) continue;
                    sumDetailMap.put(detail.getId(), (SumGrapDetailVO)detail);
                }
                if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                    List detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x != null).collect(Collectors.toList());
                    for (GrapDetailVO detail : detailList) {
                        if (detailIds.contains(detail.getId())) continue;
                        this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
                    }
                    sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
                }
                sumGrapVO = this.sumGrapService.saveOrUpdate(sumGrapVO);
            }
        }
        this.logger.info("--> \u6c47\u603b\u540e\u8fdb\u5ea6\u53f0\u8d26VO\uff1a" + JSONObject.toJSONString((Object)sumGrapVO));
        if (!isSum) {
            CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(grapVO.getId()), "BT201202000000001", "imgUpload1", String.valueOf(sumGrapVO.getId()), "BT201202000000002", "imgUpload1");
            CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(grapVO.getId()), "BT201202000000001", "bill", String.valueOf(sumGrapVO.getId()), "BT201202000000002", "bill");
        }
        return sumGrapVO;
    }

    private SumGrapVO getSumGrapVO(GrapVO grapVO) {
        SumGrapVO vo = new SumGrapVO();
        vo.setProjectId(grapVO.getProjectId());
        vo.setProjectName(grapVO.getProjectName());
        vo.setProjectSourceId(grapVO.getProjectSourceId());
        vo.setContractId(grapVO.getContractId());
        vo.setContractCode(grapVO.getContractCode());
        vo.setContractName(grapVO.getContractName());
        vo.setCropId(grapVO.getCropId());
        vo.setCropName(grapVO.getCropName());
        vo.setCropSourceId(grapVO.getCropSourceId());
        vo.setOrgId(grapVO.getOrgId());
        vo.setOrgName(grapVO.getOrgName());
        vo.setOrgSourceId(grapVO.getOrgSourceId());
        vo.setSupplierId(grapVO.getSupplierId());
        vo.setSupplierName(grapVO.getSupplierName());
        vo.setSupplierSourceId(grapVO.getSupplierSourceId());
        vo.setCreateUserId(InvocationInfoProxy.getUserid());
        vo.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        vo.setUseState(Integer.valueOf(0));
        vo.setSumMonth(new SimpleDateFormat("yyyy-MM").format(grapVO.getCreateDate()));
        vo.setSumMny(grapVO.getSumMny());
        vo.setSumApproveMny(grapVO.getSumMny());
        vo.setDescription(grapVO.getDescription());
        return vo;
    }

    private void dealSumDetailMap(GrapVO grapVO, GrapDetailVO detail, Map<String, SumGrapDetailVO> parentMap, Map<Long, SumGrapDetailVO> sumDetailMap) {
        String infoId = detail.getInfoId();
        SumGrapDetailVO vo = new SumGrapDetailVO();
        vo.setGrapId(grapVO.getId());
        vo.setGrapDetailId(detail.getId());
        vo.setInfoId(detail.getInfoId());
        vo.setNum(detail.getNum());
        vo.setApproveNum(detail.getNum());
        vo.setOldNum(detail.getNum());
        vo.setMny(detail.getMny());
        vo.setApproveMny(detail.getMny());
        vo.setConstruction(grapVO.getConstruction());
        vo.setDescription(grapVO.getDescription());
        vo.setCommitUserId(grapVO.getCreateUserId());
        vo.setCommitUserName(grapVO.getCreateUserName());
        Long parentId = null;
        SumGrapDetailVO parentVO = null;
        if (!parentMap.containsKey(infoId)) {
            parentId = IdWorker.getId();
            parentVO = new SumGrapDetailVO();
            parentVO.setId(parentId);
            parentVO.setInfoId(detail.getInfoId());
            parentVO.setInfoCode(detail.getInfoCode());
            parentVO.setInfoName(detail.getInfoName());
            parentVO.setUnit(detail.getUnit());
            parentVO.setPrice(detail.getPrice());
            parentVO.setNum(detail.getNum());
            parentVO.setApproveNum(detail.getNum());
            parentVO.setOldNum(detail.getNum());
            parentVO.setMny(detail.getMny());
            parentVO.setApproveMny(detail.getMny());
            parentVO.setConstruction(grapVO.getConstruction());
            parentVO.setLeafFlag(Integer.valueOf(0));
            parentVO.setDetailIndex(String.valueOf(1 + parentMap.size()));
            parentMap.put(infoId, parentVO);
        } else {
            parentVO = parentMap.get(infoId);
            parentId = parentVO.getId();
            parentVO.setNum(DecimalUtils.add((BigDecimal)parentVO.getNum(), (BigDecimal)detail.getNum()));
            parentVO.setApproveNum(DecimalUtils.add((BigDecimal)parentVO.getApproveNum(), (BigDecimal)detail.getNum()));
            parentVO.setOldNum(DecimalUtils.add((BigDecimal)parentVO.getOldNum(), (BigDecimal)detail.getNum()));
            parentVO.setMny(DecimalUtils.add((BigDecimal)parentVO.getMny(), (BigDecimal)detail.getMny()));
            parentVO.setApproveMny(DecimalUtils.add((BigDecimal)parentVO.getApproveMny(), (BigDecimal)detail.getMny()));
            String construction = this.getSumStr(parentVO.getConstruction(), grapVO.getConstruction());
            parentVO.setConstruction(construction);
        }
        sumDetailMap.put(parentId, parentVO);
        vo.setLeafFlag(Integer.valueOf(1));
        vo.setParentId(parentId);
        vo.setDetailIndex(parentVO.getDetailIndex() + "." + this.getIndex(sumDetailMap, parentId));
        sumDetailMap.put(detail.getId(), vo);
    }

    private String getSumStr(String sumStr, String str) {
        if (!StringUtils.isNotEmpty((String)str)) {
            return sumStr;
        }
        str = str.replaceAll(" ", "");
        if (StringUtils.isNotEmpty((String)sumStr)) {
            String[] strs = sumStr.split(",");
            HashSet<String> strSet = new HashSet<String>(Arrays.asList(strs));
            if (!strSet.contains(str)) {
                sumStr = sumStr + "," + str;
            }
            return sumStr;
        }
        return str;
    }

    private int getIndex(Map<Long, SumGrapDetailVO> map, Long parentId) {
        int index = 1;
        for (SumGrapDetailVO vo : map.values()) {
            if (!parentId.equals(vo.getParentId())) continue;
            ++index;
        }
        return index;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        GrapEntity entity = (GrapEntity)((Object)this.grapService.selectById(billId));
        if (entity.getUseState() != null && entity.getUseState() == 1) {
            return CommonResponse.error((String)"\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        if (entity.getHistoryFlag() != null && entity.getHistoryFlag() == 1) {
            return CommonResponse.error((String)"\u5386\u53f2\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        GrapEntity entity = (GrapEntity)((Object)this.grapService.selectById(billId));
        GrapVO grapVO = (GrapVO)BeanMapper.map((Object)((Object)entity), GrapVO.class);
        if (this.sumGrapService.getById(grapVO.getSumGrapId()) != null) {
            SumGrapVO sumGrapVO = this.withdrawFromSumGrapVO(grapVO);
        }
        entity.setSumGrapId(null);
        this.grapService.updateById((Object)entity);
        this.logger.info("--> \u5355\u636e\uff1a" + billId + "\u5df2\u53d6\u6d88\u6c47\u603b");
        return CommonResponse.success();
    }

    private SumGrapVO withdrawFromSumGrapVO(GrapVO grapVO) {
        int parentRow;
        this.logger.info("--> \u5355\u636e\uff1a" + grapVO.getId() + "\u53d6\u6d88\u6c47\u603b\u5f00\u59cb");
        SumGrapEntity sumGrapEntity = (SumGrapEntity)((Object)this.sumGrapService.selectById(grapVO.getSumGrapId()));
        SumGrapVO sumGrapVO = (SumGrapVO)BeanMapper.map((Object)((Object)sumGrapEntity), SumGrapVO.class);
        List sumDetailList = sumGrapVO.getDetailList();
        Collections.sort(sumDetailList, new Comparator<SumGrapDetailVO>(){

            @Override
            public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000.0 - Double.valueOf(o2.getDetailIndex()) * 10000.0;
                int i = vlaue.intValue();
                return i;
            }
        });
        HashMap<Long, Object> parentMap = new HashMap<Long, Object>();
        LinkedHashMap<Long, Object> sumDetailMap = new LinkedHashMap<Long, Object>();
        if (CollectionUtils.isNotEmpty((Collection)sumDetailList)) {
            for (Object vo : sumDetailList) {
                if (vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getId())) {
                    parentMap.put(vo.getId(), vo);
                }
                if (sumDetailMap.containsKey(vo.getId())) continue;
                if (grapVO.getId().equals(vo.getGrapId())) {
                    vo.setRowState("del");
                }
                sumDetailMap.put(vo.getId(), vo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)sumDetailList)) {
            for (Object vo : sumDetailList) {
                List children;
                Long parentId = vo.getParentId();
                if (!parentMap.containsKey(parentId) || "del".equals(vo.getRowState())) continue;
                SumGrapDetailVO parentVO = (SumGrapDetailVO)parentMap.get(parentId);
                List list = children = parentVO.getChildren() != null ? parentVO.getChildren() : new ArrayList();
                if (!children.contains(vo)) {
                    children.add(vo);
                }
                parentVO.setChildren(children);
                parentMap.put(parentId, parentVO);
            }
        }
        if ((parentRow = parentMap.size()) != 0) {
            for (SumGrapDetailVO parentVO : parentMap.values()) {
                List children = parentVO.getChildren();
                if (CollectionUtils.isNotEmpty((Collection)children)) {
                    Object num = null;
                    BigDecimal mny = null;
                    BigDecimal approveNum = null;
                    BigDecimal approveMny = null;
                    BigDecimal oldNum = null;
                    String construction = null;
                    int index = 0;
                    for (SumGrapDetailVO vo : children) {
                        num = DecimalUtils.add(num, (BigDecimal)vo.getNum());
                        mny = DecimalUtils.add(mny, (BigDecimal)vo.getMny());
                        approveNum = DecimalUtils.add(approveNum, (BigDecimal)vo.getApproveNum());
                        approveMny = DecimalUtils.add(approveMny, (BigDecimal)vo.getApproveMny());
                        oldNum = DecimalUtils.add(oldNum, (BigDecimal)vo.getOldNum());
                        construction = this.getSumStr(construction, vo.getConstruction());
                        ((SumGrapDetailVO)sumDetailMap.get(vo.getId())).setDetailIndex(parentVO.getDetailIndex() + "." + ++index);
                    }
                    parentVO.setNum(num);
                    parentVO.setMny(mny);
                    parentVO.setApproveNum(approveNum);
                    parentVO.setApproveMny(approveMny);
                    parentVO.setOldNum(oldNum);
                    parentVO.setConstruction(construction);
                    sumDetailMap.put(parentVO.getId(), parentVO);
                    continue;
                }
                parentVO.setRowState("del");
                sumDetailMap.put(parentVO.getId(), parentVO);
                --parentRow;
            }
        }
        sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
        if (sumDetailMap.size() > 0) {
            BigDecimal sumMny = null;
            BigDecimal sumApproveMny = null;
            String description = null;
            for (SumGrapDetailVO vo : sumDetailMap.values()) {
                if (vo.getLeafFlag() != 1 || "del".equals(vo.getRowState())) continue;
                sumMny = DecimalUtils.add(sumMny, (BigDecimal)vo.getMny());
                sumApproveMny = DecimalUtils.add(sumApproveMny, (BigDecimal)vo.getApproveMny());
                description = this.getSumStr(description, vo.getDescription());
            }
            sumGrapVO.setSumMny(sumMny);
            sumGrapVO.setSumApproveMny(sumApproveMny);
            sumGrapVO.setDescription(description);
        }
        if (parentRow > 0) {
            this.logger.info("--> \u6c47\u603b\u540e\u8fdb\u5ea6\u53f0\u8d26VO\uff1a" + JSONObject.toJSONString((Object)sumGrapVO));
            this.sumGrapService.saveOrUpdate(sumGrapVO);
        } else {
            this.logger.info("--> \u8fdb\u5ea6\u53f0\u8d26VO\uff1a" + sumGrapVO.getId() + "\u5df2\u5220\u9664");
            this.sumGrapService.removeById(sumGrapVO.getId(), true);
        }
        List<AttachmentVO> grapFileList = this.queryListBySourceId(grapVO.getId(), "BT201202000000001", "imgUpload1");
        List<AttachmentVO> sumGrapFileList = this.queryListBySourceId(sumGrapVO.getId(), "BT201202000000002", "imgUpload1");
        List<AttachmentVO> grapFileList2 = this.queryListBySourceId(grapVO.getId(), "BT201202000000001", "bill");
        List<AttachmentVO> sumGrapFileList2 = this.queryListBySourceId(sumGrapVO.getId(), "BT201202000000002", "bill");
        grapFileList.addAll(grapFileList2);
        sumGrapFileList.addAll(sumGrapFileList2);
        if (CollectionUtils.isNotEmpty(grapFileList) && CollectionUtils.isNotEmpty(sumGrapFileList)) {
            Map grapFileMap = grapFileList.stream().collect(Collectors.toMap(AttachmentVO::getFilePath, Function.identity()));
            ArrayList<String> ids = new ArrayList<String>();
            for (AttachmentVO vo : sumGrapFileList) {
                if (!grapFileMap.containsKey(vo.getFilePath())) continue;
                ids.add(String.valueOf(vo.getId()));
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                this.attachmentApi.delete(String.join((CharSequence)",", ids));
            }
        }
        return sumGrapVO;
    }

    private List<AttachmentVO> queryListBySourceId(Long sourceId, String billType, String sourceType) {
        String url = this.BASE_HOST + "ejc-file-web/attachment/queryListBySourceId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceId", String.valueOf(sourceId));
        params.put("billType", billType);
        params.put("sourceType", sourceType);
        try {
            String json = HttpTookit.get((String)url, params, (HttpServletRequest)ContextHolderUtils.getRequest());
            this.logger.info("\u8bf7\u6c42\uff1a" + url + "?params={} \u54cd\u5e94\u7ed3\u679c\uff1a{}", params, (Object)json);
            CommonResponse response = (CommonResponse)JSONObject.parseObject((String)json, CommonResponse.class);
            String data = ((JSONObject)response.getData()).getString("data");
            List list = JSONArray.parseArray((String)data, AttachmentVO.class);
            return list;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return new ArrayList<AttachmentVO>();
        }
    }
}

