/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.Enum.BillSourceEnum;
import com.ejianc.business.fbxt.grap.Enum.ConfirmStatusEnum;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.mapper.GrapMapper;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.vo.AssignmentInfoVO;
import com.ejianc.business.fbxt.grap.vo.AssignmrnyBookVO;
import com.ejianc.business.fbxt.grap.vo.FileVO;
import com.ejianc.business.fbxt.grap.vo.GrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.business.fbxt.grap.vo.SupplierConfirmVO;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="grapService")
public class GrapServiceImpl
extends BaseServiceImpl<GrapMapper, GrapEntity>
implements IGrapService {
    private static final String FBXT_GRAP = "FBXT_GRAP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private ISupplierApi iSupplierApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.wjAssUpApplyUrl}")
    private String wjAssUpApplyUrl;
    @Value(value="${img.serverPath}")
    private String serverPath;

    @Override
    public GrapVO saveOrUpdate(GrapVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId()) {
            saveorUpdateVO.setSource(BillSourceEnum.\u81ea\u5236.getCode());
        }
        GrapEntity entity = (GrapEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, GrapEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(FBXT_GRAP, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getCropId() != null) {
            CommonResponse orgVO = this.orgApi.getOneById(entity.getCropId());
            if (!orgVO.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCropSourceId(((OrgVO)orgVO.getData()).getSourceId());
        }
        super.saveOrUpdate((Object)entity, false);
        return (GrapVO)BeanMapper.map((Object)((Object)entity), GrapVO.class);
    }

    @Override
    public Long assSaveOrUpdate(AssignmrnyBookVO assignmrnyBookVO) {
        CommonResponse supplier;
        ProjectRegisterVO projectRegisterVO = new ProjectRegisterVO();
        if (assignmrnyBookVO.getPkProject() != null) {
            CommonResponse ponse = this.iProjectApi.queryProjectBySourceId(assignmrnyBookVO.getPkProject());
            if (ponse.getData() == null) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            projectRegisterVO = (ProjectRegisterVO)ponse.getData();
        }
        GrapVO grapVO = new GrapVO();
        Long projectId = projectRegisterVO.getId();
        grapVO.setCropId(projectRegisterVO.getOrgId());
        grapVO.setCropName(projectRegisterVO.getOrgName());
        grapVO.setCropSourceId(assignmrnyBookVO.getPkOrg());
        grapVO.setOrgId(projectRegisterVO.getProjectDepartmentId());
        OrgVO orgVO = new OrgVO();
        if (projectRegisterVO.getProjectDepartmentId() != null) {
            CommonResponse orgVOCommonResponse = this.orgApi.getOneById(projectRegisterVO.getProjectDepartmentId());
            if (!orgVOCommonResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            orgVO = (OrgVO)orgVOCommonResponse.getData();
        }
        grapVO.setOrgName(orgVO.getName());
        grapVO.setOrgSourceId(orgVO.getSourceId());
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());
        if (assignmrnyBookVO.getPkProject() != null) {
            grapVO.setProjectSourceId(assignmrnyBookVO.getPkProject());
        }
        grapVO.setProjectId(projectId);
        grapVO.setProjectName(assignmrnyBookVO.getProjectName());
        grapVO.setContractId(assignmrnyBookVO.getPkContract());
        grapVO.setContractName(assignmrnyBookVO.getContractName());
        grapVO.setContractCode(assignmrnyBookVO.getContractCode());
        grapVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        grapVO.setDescription(assignmrnyBookVO.getMemo());
        grapVO.setSource(BillSourceEnum.\u4f9b\u65b9\u63a8\u9001.getCode());
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());
        grapVO.setCreateUserName(assignmrnyBookVO.getCreatorName());
        if (assignmrnyBookVO.getPkSupplier() != null && (supplier = this.iSupplierApi.queryBySourceId(assignmrnyBookVO.getPkSupplier())).isSuccess()) {
            SupplierVO supplierVO = (SupplierVO)supplier.getData();
            grapVO.setSupplierId(supplierVO.getId());
            grapVO.setSupplierName(supplierVO.getName());
        }
        grapVO.setUseState(Integer.valueOf(0));
        grapVO.setSourceId(assignmrnyBookVO.getPkAssignmentBook());
        grapVO.setSupplierSourceId(assignmrnyBookVO.getPkSupplier());
        grapVO.setConstruction(assignmrnyBookVO.getConstruction());
        grapVO.setPkCreator(assignmrnyBookVO.getPkCreator());
        grapVO.setCreateDate(new Date());
        grapVO.setSumMny(assignmrnyBookVO.getSumMany());
        grapVO.setSaveState(Integer.valueOf(0));
        ArrayList<GrapDetailVO> detailList = new ArrayList<GrapDetailVO>();
        for (AssignmentInfoVO assignmentInfoVO : assignmrnyBookVO.getAssInfoList()) {
            GrapDetailVO grapDetil = new GrapDetailVO();
            grapDetil.setInfoId(assignmentInfoVO.getInfoId());
            grapDetil.setInfoCode(assignmentInfoVO.getInfoCode());
            grapDetil.setInfoName(assignmentInfoVO.getInfoName());
            grapDetil.setUnit(assignmentInfoVO.getInfoUnit());
            grapDetil.setNum(assignmentInfoVO.getInfoNumber());
            grapDetil.setPcaAmout(assignmentInfoVO.getInfoNumber());
            grapDetil.setPrice(assignmentInfoVO.getPrice());
            grapDetil.setMny(assignmentInfoVO.getMny());
            grapDetil.setSite(assignmentInfoVO.getInfoSite());
            grapDetil.setSourceId(assignmentInfoVO.getPkBookInfo());
            detailList.add(grapDetil);
        }
        grapVO.setDetailList(detailList);
        GrapEntity entity = (GrapEntity)((Object)BeanMapper.map((Object)grapVO, GrapEntity.class));
        super.saveOrUpdate((Object)entity, false);
        List fileVOList = assignmrnyBookVO.getFileList();
        if (CollectionUtils.isNotEmpty((Collection)fileVOList) && fileVOList.size() != 0) {
            this.saveFile(fileVOList, entity.getId());
        }
        return entity.getId();
    }

    public boolean saveFile(List<FileVO> fileVOList, Long id) {
        ArrayList<AttachmentVO> attachmentList = new ArrayList<AttachmentVO>();
        for (FileVO fileVO : fileVOList) {
            AttachmentVO attachmentVO = new AttachmentVO();
            attachmentVO.setBillType("BT201202000000001");
            attachmentVO.setFileName(fileVO.getFileName());
            attachmentVO.setFilePath(fileVO.getFilePath());
            attachmentVO.setImgServerPath(this.serverPath);
            attachmentVO.setOnlinePath(this.serverPath + fileVO.getFilePath());
            attachmentVO.setSourceId(id);
            attachmentVO.setSourceType("imgUpload1");
            attachmentVO.setTruePath(this.serverPath + fileVO.getFilePath());
            attachmentVO.setUploadUserName(" \u4f9b\u65b9\u5e73\u53f0");
            attachmentList.add(attachmentVO);
        }
        CommonResponse flag = this.iAttachmentApi.insertBatch(attachmentList);
        if (!flag.getMsg().equals("\u65b0\u589e\u6210\u529f")) {
            throw new BusinessException(flag.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<Boolean> supplierConfirm(SupplierConfirmVO billStateVO) {
        HashMap<String, String> headers;
        CommonResponse<String> tokenres;
        billStateVO.setPkAssignmentBook(((GrapEntity)((Object)this.selectById(billStateVO.getId()))).getSourceId());
        if (ConfirmStatusEnum.\u9a73\u56de\u4f9b\u65b9.getCode() == billStateVO.getBillState()) {
            super.removeById((Serializable)billStateVO.getId());
        }
        if ((tokenres = this.getAccessToken(headers = new HashMap<String, String>())).isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.pushGrap(headers, billStateVO);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + JSONObject.toJSONString(pushres));
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
        return CommonResponse.success((String)"\u6210\u529f\uff01", (Object)true);
    }

    public CommonResponse<String> pushGrap(Map<String, String> headers, SupplierConfirmVO copy) {
        String url = this.wjAssUpApplyUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }
}

