/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.ejianc.business.fbxt.odd.bean.OddImportInfoEntity;
import com.ejianc.business.fbxt.odd.service.IOddImportInfoService;
import com.ejianc.business.fbxt.odd.service.IOddImportService;
import com.ejianc.business.fbxt.odd.vo.OddImportInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddImportVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.business.sync.vo.OddInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="oddImport")
public class OddImportBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddImportService service;
    @Autowired
    private IOddSyncApi oddSyncApi;
    @Autowired
    private IOddImportInfoService infoService;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u96f6\u5de5\u5bfc\u5165\uff0c\u63d0\u4ea4\u524d\u56de\u8c03\u5f00\u59cb");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u96f6\u5de5\u5bfc\u5165\uff0c\u63d0\u4ea4\u540e\u56de\u8c03\u5f00\u59cb");
        QueryParam param = new QueryParam();
        param.getParams().put("odd_id", new Parameter("eq", (Object)billId));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List oddInfoEntities = this.infoService.queryList(param, false);
        for (OddImportInfoEntity oe : oddInfoEntities) {
            oe.setReviewMny(oe.getMny());
            oe.setReviewNum(oe.getNum());
            oe.setReviewPrice(oe.getPrice());
        }
        this.logger.info("\u67e5\u8be2\u7684\u6761\u6570\uff1a" + oddInfoEntities.size());
        this.infoService.saveOrUpdateBatch(oddInfoEntities);
        this.logger.info("---------------------------\u4fee\u6539\u5ba1\u6279\u91d1\u989d\uff0c\u63d0\u4ea4\u524d\u56de\u8c03\u7ed3\u675f");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (this.baseHost.contains("9080")) {
            QueryParam param = new QueryParam();
            param.getParams().put("odd_id", new Parameter("eq", (Object)billId));
            param.getParams().put("dr", new Parameter("eq", (Object)0));
            List oddInfoList = this.infoService.queryList(param, false);
            Iterator iterator = oddInfoList.iterator();
            while (iterator.hasNext()) {
                OddImportInfoEntity oe;
                oe.setReviewMny((oe = (OddImportInfoEntity)((Object)iterator.next())).getReviewMny() != null ? oe.getReviewMny() : oe.getMny());
                oe.setReviewNum(oe.getReviewNum() != null ? oe.getReviewNum() : oe.getNum());
                oe.setReviewPrice(oe.getReviewPrice() != null ? oe.getReviewPrice() : oe.getPrice());
            }
            this.infoService.saveOrUpdateBatch(oddInfoList);
            this.logger.info("---------------------------\u96f6\u5de5\u5bfc\u5165\u6570\u636e\u540c\u6b65\u81f3nc");
            OddImportVO importVO = this.service.queryDetail(billId);
            OddVO map = (OddVO)BeanMapper.map((Object)importVO, OddVO.class);
            com.ejianc.business.sync.vo.OddVO vo = (com.ejianc.business.sync.vo.OddVO)BeanMapper.map((Object)map, com.ejianc.business.sync.vo.OddVO.class);
            List oddInfoEntities = importVO.getInfoVOList();
            ArrayList<OddInfoVO> list = new ArrayList<OddInfoVO>();
            for (OddImportInfoVO info : oddInfoEntities) {
                OddInfoVO oddInfoVO = (OddInfoVO)BeanMapper.map((Object)info, OddInfoVO.class);
                list.add(oddInfoVO);
            }
            vo.setOddInfoEntities(list);
            this.logger.info("\u4e3b\u8868\u6765\u6e901\uff1a" + importVO.getOddSource());
            this.logger.info("\u4e3b\u8868\u6765\u6e902\uff1a" + map.getOddSource());
            vo.setOddSource(importVO.getOddSource());
            CommonResponse response = this.oddSyncApi.syncOddImport(vo);
            this.logger.info("+++++++++++++++++++++++++++\u6570\u636e\u540c\u6b65\u81f3nc");
            if (response.isSuccess()) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)"\u6570\u636e\u540c\u6b65\u81f3nc\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (this.baseHost.contains("9080")) {
            CommonResponse booleanResponse = this.oddSyncApi.syncFlag(billId);
            this.logger.debug("--------\uff1a" + booleanResponse.isSuccess());
            this.logger.debug("--------\uff1a" + booleanResponse.getData());
            if (booleanResponse.isSuccess()) {
                if (((Boolean)booleanResponse.getData()).booleanValue()) {
                    return CommonResponse.error((String)booleanResponse.getMsg());
                }
                CommonResponse delResponse = this.oddSyncApi.delSync(billId);
                this.logger.debug("+++++++\uff1a" + delResponse.isSuccess());
                this.logger.debug("+++++++\uff1a" + delResponse.getData());
                if (delResponse.isSuccess()) {
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)delResponse.getMsg());
            }
            return CommonResponse.error((String)booleanResponse.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

