/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.fbxt.grap.Enum.BillSourceEnum;
import com.ejianc.business.fbxt.grap.Enum.ConfirmStatusEnum;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.mapper.GrapMapper;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.AssignmentInfoVO;
import com.ejianc.business.fbxt.grap.vo.AssignmrnyBookVO;
import com.ejianc.business.fbxt.grap.vo.FileVO;
import com.ejianc.business.fbxt.grap.vo.GrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.grap.vo.SupplierConfirmVO;
import com.ejianc.business.fbxt.odd.bean.ReceiveEntity;
import com.ejianc.business.fbxt.odd.service.IReceiveService;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.fbxt.util.MsgUtil;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="grapService")
public class GrapServiceImpl
extends BaseServiceImpl<GrapMapper, GrapEntity>
implements IGrapService {
    private static final String FBXT_GRAP = "FBXT_GRAP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private ISupplierApi iSupplierApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private MsgUtil msgUtil;
    @Autowired
    private IReceiveService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.wjAssUpApplyUrl}")
    private String wjAssUpApplyUrl;
    @Value(value="${img.serverPath}")
    private String serverPath;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ISumGrapService sumGrapService;

    @Override
    public GrapVO saveOrUpdate(GrapVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId()) {
            saveorUpdateVO.setSource(BillSourceEnum.\u81ea\u5236.getCode());
        }
        GrapEntity entity = (GrapEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, GrapEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(FBXT_GRAP, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getCropId() != null) {
            CommonResponse orgVO = this.orgApi.getOneById(entity.getCropId());
            if (!orgVO.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCropSourceId(((OrgVO)orgVO.getData()).getSourceId());
        }
        super.saveOrUpdate((Object)entity, false);
        return (GrapVO)BeanMapper.map((Object)((Object)entity), GrapVO.class);
    }

    @Override
    public Long assSaveOrUpdate(AssignmrnyBookVO assignmrnyBookVO) {
        CommonResponse supplier;
        ProjectRegisterVO projectRegisterVO = new ProjectRegisterVO();
        if (assignmrnyBookVO.getPkProject() != null) {
            CommonResponse ponse = this.iProjectApi.queryProjectBySourceId(assignmrnyBookVO.getPkProject());
            if (ponse.getData() == null) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            projectRegisterVO = (ProjectRegisterVO)ponse.getData();
        }
        GrapVO grapVO = new GrapVO();
        Long projectId = projectRegisterVO.getId();
        grapVO.setCropId(projectRegisterVO.getOrgId());
        grapVO.setCropName(projectRegisterVO.getOrgName());
        grapVO.setCropSourceId(assignmrnyBookVO.getPkOrg());
        grapVO.setOrgId(projectRegisterVO.getProjectDepartmentId());
        OrgVO orgVO = new OrgVO();
        if (projectRegisterVO.getProjectDepartmentId() != null) {
            CommonResponse orgVOCommonResponse = this.orgApi.getOneById(projectRegisterVO.getProjectDepartmentId());
            if (!orgVOCommonResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            orgVO = (OrgVO)orgVOCommonResponse.getData();
        }
        grapVO.setOrgName(orgVO.getName());
        grapVO.setOrgSourceId(orgVO.getSourceId());
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());
        if (assignmrnyBookVO.getPkProject() != null) {
            grapVO.setProjectSourceId(assignmrnyBookVO.getPkProject());
        }
        grapVO.setProjectId(projectId);
        grapVO.setProjectName(assignmrnyBookVO.getProjectName());
        grapVO.setContractId(assignmrnyBookVO.getPkContract());
        grapVO.setContractName(assignmrnyBookVO.getContractName());
        grapVO.setContractCode(assignmrnyBookVO.getContractCode());
        grapVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        grapVO.setDescription(assignmrnyBookVO.getMemo());
        grapVO.setSource(BillSourceEnum.\u4f9b\u65b9\u63a8\u9001.getCode());
        grapVO.setBillCode(assignmrnyBookVO.getBillCode());
        grapVO.setCreateUserName(assignmrnyBookVO.getCreatorName());
        if (assignmrnyBookVO.getPkSupplier() != null && (supplier = this.iSupplierApi.queryBySourceId(assignmrnyBookVO.getPkSupplier())).isSuccess()) {
            SupplierVO supplierVO = (SupplierVO)supplier.getData();
            grapVO.setSupplierId(supplierVO.getId());
            grapVO.setSupplierName(supplierVO.getName());
        }
        grapVO.setUseState(Integer.valueOf(0));
        grapVO.setSourceId(assignmrnyBookVO.getPkAssignmentBook());
        grapVO.setSupplierSourceId(assignmrnyBookVO.getPkSupplier());
        grapVO.setConstruction(assignmrnyBookVO.getConstruction());
        grapVO.setPkCreator(assignmrnyBookVO.getPkCreator());
        grapVO.setCreateDate(new Date());
        grapVO.setSumMny(assignmrnyBookVO.getSumMany());
        grapVO.setSaveState(Integer.valueOf(0));
        ArrayList<GrapDetailVO> detailList = new ArrayList<GrapDetailVO>();
        for (AssignmentInfoVO assignmentInfoVO : assignmrnyBookVO.getAssInfoList()) {
            GrapDetailVO grapDetil = new GrapDetailVO();
            grapDetil.setInfoId(assignmentInfoVO.getInfoId());
            grapDetil.setInfoCode(assignmentInfoVO.getInfoCode());
            grapDetil.setInfoName(assignmentInfoVO.getInfoName());
            grapDetil.setUnit(assignmentInfoVO.getInfoUnit());
            grapDetil.setNum(assignmentInfoVO.getInfoNumber());
            grapDetil.setPcaAmout(assignmentInfoVO.getInfoNumber());
            grapDetil.setPrice(assignmentInfoVO.getPrice());
            grapDetil.setMny(assignmentInfoVO.getMny());
            grapDetil.setSite(assignmentInfoVO.getInfoSite());
            grapDetil.setSourceId(assignmentInfoVO.getPkBookInfo());
            detailList.add(grapDetil);
        }
        grapVO.setDetailList(detailList);
        GrapEntity entity = (GrapEntity)((Object)BeanMapper.map((Object)grapVO, GrapEntity.class));
        super.saveOrUpdate((Object)entity, false);
        List fileVOList = assignmrnyBookVO.getFileList();
        if (CollectionUtils.isNotEmpty((Collection)fileVOList) && fileVOList.size() != 0) {
            this.saveFile(fileVOList, entity.getId());
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BaseEntity::getDr, (Object)0);
        List receiveEntityList = this.service.list((Wrapper)query);
        for (ReceiveEntity receiveEntity : receiveEntityList) {
            Long userId = receiveEntity.getUserId();
            this.assBookMsg(entity, userId);
        }
        return entity.getId();
    }

    public void assBookMsg(GrapEntity entity, Long userId) {
        System.out.println(userId + "---------------------------------------------------------------------------");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("wjyGrap");
        String subject = "\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011\u63d0\u4ea4\u7684\u3010\u65bd\u5de5\u4efb\u52a1\u4e66_" + entity.getBillCode() + "_" + sdf.format(new Date()) + "\u3011\u9700\u8981\u786e\u8ba4\u6216\u9a73\u56de";
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(userId));
        String formurl = this.baseHost + "cscec5b-fbxt-frontend/#/grap/card?id=" + entity.getId();
        String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.msgUtil.sendMsg(messageType, sender, "task", subject, content, entity.getId());
    }

    public boolean saveFile(List<FileVO> fileVOList, Long id) {
        ArrayList<AttachmentVO> attachmentList = new ArrayList<AttachmentVO>();
        for (FileVO fileVO : fileVOList) {
            AttachmentVO attachmentVO = new AttachmentVO();
            attachmentVO.setBillType("BT201202000000001");
            attachmentVO.setFileName(fileVO.getFileName());
            attachmentVO.setFilePath(fileVO.getFilePath());
            attachmentVO.setImgServerPath(this.serverPath);
            attachmentVO.setOnlinePath(this.serverPath + fileVO.getFilePath());
            attachmentVO.setSourceId(id);
            attachmentVO.setSourceType("imgUpload1");
            attachmentVO.setTruePath(this.serverPath + fileVO.getFilePath());
            attachmentVO.setUploadUserName(" \u4f9b\u65b9\u5e73\u53f0");
            attachmentList.add(attachmentVO);
        }
        CommonResponse flag = this.iAttachmentApi.insertBatch(attachmentList);
        if (!flag.getMsg().equals("\u65b0\u589e\u6210\u529f")) {
            throw new BusinessException(flag.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<Boolean> supplierConfirm(SupplierConfirmVO billStateVO) {
        HashMap<String, String> headers;
        CommonResponse<String> tokenres;
        billStateVO.setPkAssignmentBook(((GrapEntity)((Object)this.selectById(billStateVO.getId()))).getSourceId());
        if (ConfirmStatusEnum.\u9a73\u56de\u4f9b\u65b9.getCode().equals(billStateVO.getBillState())) {
            super.removeById((Serializable)billStateVO.getId());
        }
        if ((tokenres = this.getAccessToken(headers = new HashMap<String, String>())).isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            this.logger.info("--> \u63a8\u9001\u4f9b\u65b9\u53c2\u6570-----VO\uff1a" + JSONObject.toJSONString((Object)billStateVO));
            CommonResponse<String> pushres = this.pushGrap(headers, billStateVO);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + JSONObject.toJSONString(pushres));
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
        return CommonResponse.success((String)"\u6210\u529f\uff01", (Object)true);
    }

    @Override
    public CommonResponse<String> pushToSumGrap(Long billId) {
        GrapEntity entity = (GrapEntity)((Object)this.selectById(billId));
        GrapVO grapVO = (GrapVO)BeanMapper.map((Object)((Object)entity), GrapVO.class);
        if (grapVO.getSumGrapId() == null) {
            SumGrapVO sumGrapVO = this.pushToSumGrap(grapVO);
            entity.setSumGrapId(sumGrapVO.getId());
            this.updateById((Object)entity);
            this.logger.info("--> \u5355\u636e\uff1a" + billId + "\u5df2\u6c47\u603b\u5230\uff1a" + entity.getSumGrapId());
        }
        if (StringUtils.isNotBlank((String)grapVO.getSourceId()) && StringUtils.isNotBlank((String)grapVO.getSource()) && BillSourceEnum.\u4f9b\u65b9\u63a8\u9001.getCode().equals(grapVO.getSource())) {
            SupplierConfirmVO billStateVO = new SupplierConfirmVO();
            billStateVO.setId(billId);
            billStateVO.setBillState(ConfirmStatusEnum.\u786e\u8ba4\u901a\u8fc7.getCode());
            String confirmer = StringUtils.isNotBlank((String)entity.getConfirmer()) ? entity.getConfirmer() : String.valueOf(InvocationInfoProxy.getUserid());
            billStateVO.setConfirmer(confirmer);
            String confirmerName = StringUtils.isNotBlank((String)entity.getConfirmerName()) ? entity.getConfirmerName() : ((UserVO)this.userApi.findUserByUserId(InvocationInfoProxy.getUserid()).getData()).getUserName();
            billStateVO.setConfirmerName(confirmerName);
            billStateVO.setFeedback("\u786e\u8ba4\u901a\u8fc7");
            billStateVO.setPkAssignmentBook(grapVO.getSourceId());
            billStateVO.setFlag(Integer.valueOf(1));
            ArrayList<AssignmentInfoVO> assignmentInfoVOList = new ArrayList<AssignmentInfoVO>();
            for (GrapDetailVO grapDetailVO : grapVO.getDetailList()) {
                if (grapDetailVO.getSourceId() == null) continue;
                AssignmentInfoVO assignmentInfoVO = new AssignmentInfoVO();
                assignmentInfoVO.setPkBookInfo(grapDetailVO.getSourceId());
                assignmentInfoVO.setInfoProjectNumber(grapDetailVO.getNum());
                assignmentInfoVOList.add(assignmentInfoVO);
            }
            if (CollectionUtils.isNotEmpty(assignmentInfoVOList)) {
                billStateVO.setAssInfoList(assignmentInfoVOList);
            }
            this.supplierConfirm(billStateVO);
        }
        return CommonResponse.success();
    }

    private SumGrapVO pushToSumGrap(GrapVO grapVO) {
        this.logger.info("--> \u5355\u636e\uff1a" + grapVO.getId() + "\u6c47\u603b\u5f00\u59cb");
        List detailList = grapVO.getDetailList();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SumGrapEntity::getContractId, (Object)grapVO.getContractId());
        wrapper.and(x -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(SumGrapEntity::getBillState, (Object)0)).or()).eq(SumGrapEntity::getBillState, (Object)4));
        List sumGrapList = this.sumGrapService.list((Wrapper)wrapper);
        SumGrapVO sumGrapVO = null;
        HashMap<String, SumGrapDetailVO> parentMap = new HashMap<String, SumGrapDetailVO>();
        HashMap<Long, SumGrapDetailVO> sumDetailMap = new HashMap<Long, SumGrapDetailVO>();
        boolean isSum = false;
        if (CollectionUtils.isEmpty((Collection)sumGrapList)) {
            sumGrapVO = this.getSumGrapVO(grapVO);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                for (GrapDetailVO detail : detailList) {
                    this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
                }
                sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
            }
            sumGrapVO = this.sumGrapService.saveOrUpdate(sumGrapVO);
        } else {
            SumGrapEntity sumGrapEntity = (SumGrapEntity)((Object)this.sumGrapService.selectById(((SumGrapEntity)((Object)sumGrapList.get(0))).getId()));
            sumGrapVO = (SumGrapVO)BeanMapper.map((Object)((Object)sumGrapEntity), SumGrapVO.class);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                List detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x != null).collect(Collectors.toList());
                for (GrapDetailVO detail : detailList) {
                    if (!detailIds.contains(detail.getId())) continue;
                    isSum = true;
                }
            }
            if (!isSum) {
                sumGrapVO.setDescription(this.getSumStr(sumGrapVO.getDescription(), grapVO.getDescription()));
                sumGrapVO.setSumMny(DecimalUtils.add((BigDecimal)sumGrapVO.getSumMny(), (BigDecimal)grapVO.getSumMny()));
                sumGrapVO.setSumApproveMny(DecimalUtils.add((BigDecimal)sumGrapVO.getSumApproveMny(), (BigDecimal)grapVO.getSumMny()));
                List sumDetailList = sumGrapVO.getDetailList();
                for (GrapDetailVO detail : sumDetailList) {
                    if (detail.getLeafFlag() == 0 && !parentMap.containsKey(detail.getInfoId())) {
                        parentMap.put(detail.getInfoId(), (SumGrapDetailVO)detail);
                    }
                    if (sumDetailMap.containsKey(detail.getId())) continue;
                    sumDetailMap.put(detail.getId(), (SumGrapDetailVO)detail);
                }
                if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                    List detailIds = sumGrapVO.getDetailList().stream().map(SumGrapDetailVO::getGrapDetailId).filter(x -> x != null).collect(Collectors.toList());
                    for (GrapDetailVO detail : detailList) {
                        if (detailIds.contains(detail.getId())) continue;
                        this.dealSumDetailMap(grapVO, detail, parentMap, sumDetailMap);
                    }
                    sumGrapVO.setDetailList(new ArrayList(sumDetailMap.values()));
                }
                sumGrapVO = this.sumGrapService.saveOrUpdate(sumGrapVO);
            }
        }
        this.logger.info("--> \u6c47\u603b\u540e\u8fdb\u5ea6\u53f0\u8d26VO\uff1a" + JSONObject.toJSONString((Object)sumGrapVO));
        if (!isSum) {
            CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(grapVO.getId()), "BT201202000000001", "imgUpload1", String.valueOf(sumGrapVO.getId()), "BT201202000000002", "imgUpload1");
            CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(grapVO.getId()), "BT201202000000001", "bill", String.valueOf(sumGrapVO.getId()), "BT201202000000002", "bill");
        }
        return sumGrapVO;
    }

    private SumGrapVO getSumGrapVO(GrapVO grapVO) {
        SumGrapVO vo = new SumGrapVO();
        vo.setProjectId(grapVO.getProjectId());
        vo.setProjectName(grapVO.getProjectName());
        vo.setProjectSourceId(grapVO.getProjectSourceId());
        vo.setContractId(grapVO.getContractId());
        vo.setContractCode(grapVO.getContractCode());
        vo.setContractName(grapVO.getContractName());
        vo.setCropId(grapVO.getCropId());
        vo.setCropName(grapVO.getCropName());
        vo.setCropSourceId(grapVO.getCropSourceId());
        vo.setOrgId(grapVO.getOrgId());
        vo.setOrgName(grapVO.getOrgName());
        vo.setOrgSourceId(grapVO.getOrgSourceId());
        vo.setSupplierId(grapVO.getSupplierId());
        vo.setSupplierName(grapVO.getSupplierName());
        vo.setSupplierSourceId(grapVO.getSupplierSourceId());
        vo.setCreateUserId(InvocationInfoProxy.getUserid());
        vo.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        vo.setUseState(Integer.valueOf(0));
        vo.setSumMonth(new SimpleDateFormat("yyyy-MM").format(grapVO.getCreateDate()));
        vo.setSumMny(grapVO.getSumMny());
        vo.setSumApproveMny(grapVO.getSumMny());
        vo.setDescription(grapVO.getDescription());
        return vo;
    }

    private void dealSumDetailMap(GrapVO grapVO, GrapDetailVO detail, Map<String, SumGrapDetailVO> parentMap, Map<Long, SumGrapDetailVO> sumDetailMap) {
        String infoId = detail.getInfoId();
        SumGrapDetailVO vo = new SumGrapDetailVO();
        vo.setGrapId(grapVO.getId());
        vo.setGrapDetailId(detail.getId());
        vo.setInfoId(detail.getInfoId());
        vo.setNum(detail.getNum());
        vo.setApproveNum(detail.getNum());
        vo.setOldNum(detail.getNum());
        vo.setMny(detail.getMny());
        vo.setApproveMny(detail.getMny());
        vo.setConstruction(grapVO.getConstruction());
        vo.setDescription(grapVO.getDescription());
        vo.setCommitUserId(grapVO.getCreateUserId());
        vo.setCommitUserName(grapVO.getCreateUserName());
        Long parentId = null;
        SumGrapDetailVO parentVO = null;
        if (!parentMap.containsKey(infoId)) {
            parentId = IdWorker.getId();
            parentVO = new SumGrapDetailVO();
            parentVO.setId(parentId);
            parentVO.setInfoId(detail.getInfoId());
            parentVO.setInfoCode(detail.getInfoCode());
            parentVO.setInfoName(detail.getInfoName());
            parentVO.setUnit(detail.getUnit());
            parentVO.setPrice(detail.getPrice());
            parentVO.setNum(detail.getNum());
            parentVO.setApproveNum(detail.getNum());
            parentVO.setOldNum(detail.getNum());
            parentVO.setMny(detail.getMny());
            parentVO.setApproveMny(detail.getMny());
            parentVO.setConstruction(grapVO.getConstruction());
            parentVO.setLeafFlag(Integer.valueOf(0));
            parentVO.setDetailIndex(String.valueOf(1 + parentMap.size()));
            parentMap.put(infoId, parentVO);
        } else {
            parentVO = parentMap.get(infoId);
            parentId = parentVO.getId();
            parentVO.setNum(DecimalUtils.add((BigDecimal)parentVO.getNum(), (BigDecimal)detail.getNum()));
            parentVO.setApproveNum(DecimalUtils.add((BigDecimal)parentVO.getApproveNum(), (BigDecimal)detail.getNum()));
            parentVO.setOldNum(DecimalUtils.add((BigDecimal)parentVO.getOldNum(), (BigDecimal)detail.getNum()));
            parentVO.setMny(DecimalUtils.add((BigDecimal)parentVO.getMny(), (BigDecimal)detail.getMny()));
            parentVO.setApproveMny(DecimalUtils.add((BigDecimal)parentVO.getApproveMny(), (BigDecimal)detail.getMny()));
            String construction = this.getSumStr(parentVO.getConstruction(), grapVO.getConstruction());
            parentVO.setConstruction(construction);
        }
        sumDetailMap.put(parentId, parentVO);
        vo.setLeafFlag(Integer.valueOf(1));
        vo.setParentId(parentId);
        vo.setDetailIndex(parentVO.getDetailIndex() + "." + this.getIndex(sumDetailMap, parentId));
        sumDetailMap.put(detail.getId(), vo);
    }

    private String getSumStr(String sumStr, String str) {
        if (!StringUtils.isNotEmpty((String)str)) {
            return sumStr;
        }
        str = str.replaceAll(" ", "");
        if (StringUtils.isNotEmpty((String)sumStr)) {
            String[] strs = sumStr.split(",");
            HashSet<String> strSet = new HashSet<String>(Arrays.asList(strs));
            if (!strSet.contains(str)) {
                sumStr = sumStr + "," + str;
            }
            return sumStr;
        }
        return str;
    }

    private int getIndex(Map<Long, SumGrapDetailVO> map, Long parentId) {
        int index = 1;
        for (SumGrapDetailVO vo : map.values()) {
            if (!parentId.equals(vo.getParentId())) continue;
            ++index;
        }
        return index;
    }

    public CommonResponse<String> pushGrap(Map<String, String> headers, SupplierConfirmVO copy) {
        String url = this.wjAssUpApplyUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }
}

