package com.ejianc.business.fbxt.odd.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddSetEntity;
import com.ejianc.business.fbxt.odd.cons.BillCons;
import com.ejianc.business.fbxt.odd.cons.FileBizType;
import com.ejianc.business.fbxt.odd.cons.Sysmark;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoApplyService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.service.IOddSetService;
import com.ejianc.business.fbxt.odd.vo.sysupl.BodyApplyResponse;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoApply;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("oddApply")
public class OddApplyBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IOddApplyService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddInfoApplyService oddInfoApplyService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOddService oddService;
    @Autowired
    private IOddSetService oddSetService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        // 暂存提交需要修改暂存状态
//		LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
//		updateWrapper.set(OddApplyEntity::getOddStatus,1);
//		updateWrapper.eq(OddApplyEntity::getId,billId);
//		service.update(updateWrapper);

        QueryParam param = new QueryParam();
        param.getParams().put("odd_apply_id", new Parameter(QueryParam.EQ, billId));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<OddInfoApplyEntity> oddInfoEntities = oddInfoApplyService.queryList(param, false);
        for (OddInfoApplyEntity oe : oddInfoEntities) {
            oe.setReviewMny(oe.getMny());
            oe.setReviewNum(oe.getNum());
            oe.setReviewPrice(oe.getPrice());
        }
        oddInfoApplyService.saveOrUpdateBatch(oddInfoEntities);
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //0是直审，2是有审批流
//		if(state == 0){
//			LambdaUpdateWrapper<OddApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
//			updateWrapper.set(OddApplyEntity::getOddStatus,1);
//			updateWrapper.eq(OddApplyEntity::getId,billId);
//			service.update(updateWrapper);
//		}
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //1是直审，2是有审批流
        OddApplyEntity entity = service.selectById(billId);
        LambdaQueryWrapper<OddSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OddSetEntity::getOrgId, entity.getCropId());
        queryWrapper.eq(OddSetEntity::getDr, 0);
        OddSetEntity setEntity = oddSetService.getOne(queryWrapper);

        // 是否启用供方协同，0-未启用，1-已启用
        Boolean suppStatus = (setEntity == null || null == setEntity.getSuppStatus()) ? false : setEntity.getSuppStatus();
        // 是否供方确认，0-不需确认，1-需确认
        Boolean confirmStatus = (setEntity == null || null == setEntity.getConfirmStatus()) ? false : setEntity.getConfirmStatus();

        if (suppStatus) {// 判断是否要同步到供方
            String billType = BillCons.APPLY_BILL_TYPE;
            String sourceType = BillCons.APPLY_SOURCE_TYPE;// 原始附件类型
            String sourceTypebc = BillCons.APPLY_SOURCE_TYPE_BC;// 补充附件类型
            //  审批通过之后，向供方同步申请单，明细、附件等，公众号发消息

            OddApplyRequest copy = mapOdd(entity);
            List<OddInfoApply> applies = new ArrayList<>();
            List<OddInfoApplyEntity> oddInfoApplyEntities = entity.getOddInfoApplyEntities();
            if (oddInfoApplyEntities != null && oddInfoApplyEntities.size() > 0) {
                for (OddInfoApplyEntity info : oddInfoApplyEntities) {
                    applies.add(mapInfo(info));
                }
            }
            copy.setOddInfoList(applies);
            // 处理附件
            List<FileRelation> gzfileList = new ArrayList<>();
            List<FileRelation> bcfileList = new ArrayList<>();
            CommonResponse<List<AttachmentVO>> fileResponse = attachmentApi.queryListBySourceId(billId, billType, null, null);
            if (fileResponse.isSuccess() && fileResponse.getData() != null && fileResponse.getData().size() > 0) {
                List<AttachmentVO> fileList = fileResponse.getData();
                for (AttachmentVO fileVo : fileList) {
                    FileRelation file = new FileRelation();
                    file.setFileName(fileVo.getFileName());
                    file.setFilePath(fileVo.getFilePath());
                    file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
                    file.setFileBizPk(billId.toString());
                    file.setDr(0);
                    file.setFileBiz(FileBizType.FILE_BIZ_ODDAPPLY);// 用工申请附件业务标识
                    if (fileVo.getSourceType().equals(sourceType)) {
                        file.setBizType(FileBizType.FILE_APPLY_TYPE);// 原始附件
                        gzfileList.add(file);
                    }
                    if (fileVo.getSourceType().equals(sourceTypebc)) {
                        file.setBizType(FileBizType.FILE_SUPL_TYPE);// 补充附件
                        bcfileList.add(file);
                    }
                }
            }
            copy.setGzfileList(gzfileList);
            copy.setBcfileList(bcfileList);
            copy.setSysmark(Sysmark.SYS_MARK);// 广东公司为"gd";河南公司为"hn"
            if (!confirmStatus) {
                copy.setOddStatus(5);// 推送供方，但不需要确认
            }

            //推送供方
            Map<String, String> headers = new HashMap<>();
            CommonResponse<String> tokenres = oddService.getAccessToken(headers);
            if (tokenres.isSuccess()) {
                logger.info("++++++++++++++获取供方token+++--" + headers);
                CommonResponse<String> pushres = service.pushOddApply(headers, copy);
                logger.info("获取推送供方结果--" + pushres);
                if (!pushres.isSuccess()) {
                    throw new BusinessException("同步申请单到供方失败");
                }
            } else {
                throw new BusinessException("系统推送供方时，获取供方access_token异常");
            }
            // 修改单据状态
            LambdaUpdateWrapper<OddApplyEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            if (confirmStatus) {
                tupdateWrapper.set(OddApplyEntity::getPassFlag, 0);// 待供方确认
            } else {
                tupdateWrapper.set(OddApplyEntity::getPassFlag, 1);// 推送供方，但不需要确认
            }
            tupdateWrapper.eq(OddApplyEntity::getId, billId);
            service.update(tupdateWrapper);
        } else {
            LambdaUpdateWrapper<OddApplyEntity> tupdateWrapper = new LambdaUpdateWrapper<>();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, -1);// 已确认（不需要供方确认）
            tupdateWrapper.eq(OddApplyEntity::getId, billId);
            service.update(tupdateWrapper);
        }

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //被引用的不能弃审
        OddApplyEntity entity = service.selectById(billId);
        Integer passFlag = entity.getPassFlag();
        //供方是否通过，-1：不需要确认，0-待确认，1-已确认，2-已驳回
        if(passFlag == -1){
            // 可以弃审
            if (entity.getRegisterFlag() == 1) {
                return CommonResponse.error("申请单已登记，不能弃审");
            }
        }
        if(passFlag == 0){
            // 不能弃审
            return CommonResponse.error("申请单待供方确认，不能弃审");
        }
        if(passFlag == 1){
            // 暂不支持
            return CommonResponse.error("申请单已同步至供方，暂不支持弃审");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    private OddApplyRequest mapOdd(OddApplyEntity entity) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OddApplyRequest request = new OddApplyRequest();
        request.setPkOddApply(entity.getId());
        request.setOddCode(entity.getBillCode());
        request.setPkOrg(entity.getCropSourceId());// 来源
        request.setMemo(entity.getMemo());         // 备注
        request.setPkProject(entity.getProjectSourceId());
        request.setProjectName(entity.getProjectName());
        request.setPkContract(entity.getContractId());
        request.setContractName(entity.getContractName());
        request.setContractCode(entity.getContractCode());
        request.setPkSupplier(entity.getSupplierSourceId());
        request.setSupplierName(entity.getSupplierName());
        request.setCreateDate(sdf.format(entity.getCreateDate()));
        request.setOddType(useTypeRef2Integer(entity.getUseType()));// 0 零星用工 1 临时机械 2 变更签证
        request.setBelong(belong2Integer(entity.getBelong()));// 0 维修、1 业主原因、2 临建、3 合同及设计变更、4 安全文明施工、5 其他
        request.setOddDesc(entity.getUseDesc());
        request.setPkUser(entity.getCreateUserCode());
        request.setName(entity.getCreateName());
        request.setOddStatus(4);// 0-暂存，1-供方存疑，2-提交，3-审批中，4-待确认，5-供方确认
        request.setOddInfoStatus(null);// 这是干嘛的？？
        request.setPricesum(entity.getApplyMny());//总价
        request.setSumcheck(entity.getReviewMny());//审核总价
        //request.setsumredirect;//转扣总价
        request.setTs(entity.getCreateTime());
        //private List<String> pkList;
        /**
         * 是否被引用，0-否，1-是
         */
        request.setIsused(entity.getRegisterFlag());
        /**
         * 用工单主键
         */
        request.setPkOdd(entity.getOddId());
        /**
         * 经办人
         */
        request.setManager(entity.getManager());
        /**
         * 经办人姓名
         */
        request.setManagname(entity.getManagname());
        /**
         * 意见
         */
        request.setOpinion(entity.getOpinion());
        //系统标识，广东公司为"gd";河南公司为"hn"
        //request.setsysmark;
        /**
         * 是否转扣，0-否，1-是
         */
        request.setIsredirect(entity.getRedirectFlag());
        /**
         * 施工部位
         */
        request.setLocation(entity.getPlanBody());


        return request;
    }

    private OddInfoApply mapInfo(OddInfoApplyEntity entity) {
        OddInfoApply request = new OddInfoApply();

        request.setInfoCode(entity.getCode());
        request.setPkOddinfoApply(entity.getId());
        request.setPkOddApply(entity.getOddApplyId());
        request.setInfoName(entity.getName());//用工项
        request.setInfoAmount(null);//合同数量
        request.setUnitPrice(entity.getPrice());//单价
        request.setInfoUnit(entity.getInfoUnit());//单位
        request.setSumPrice(entity.getMny());//金额=单价*申请数量
        request.setInfoAmountCheck(null);
        request.setUnitPriceCheck(entity.getReviewPrice());
        request.setSumPriceCheck(entity.getReviewMny());//审核金额
        request.setBeginTime(null);
        request.setEndTime(null);
        request.setBefUrl(null);
        request.setAftUrl(null);
        /**
         * 申请数量
         */
        request.setApplyAmount(entity.getNum());
        /**
         * 审核申请数量
         */
        request.setApplyAmountCheck(entity.getReviewNum());
        /**
         * 来源
         */
        request.setPkContractinfo(entity.getSourceId());

        return request;
    }

    private Integer useTypeRef2Integer(Long id) {
        // 0 零星用工 1 临时机械 2 变更签证
        Integer useType = null;
        switch (id.toString()) {
            case "1330815360484229121":
                useType = 0;
                break;
            case "1330815434631135234":
                useType = 1;
                break;
            case "1330815490885140481":
                useType = 2;
                break;
            default:
                useType = null;
                break;
        }
        return useType;
    }

    private Integer belong2Integer(Long id) {
        // 0 维修、1 业主原因、2 临建、3 合同及设计变更、4 安全文明施工、5 其他
        Integer belong = null;
        switch (id.toString()) {
            case "1330815675283521538":
                belong = 0;
                break;
            case "1330815744443400193":
                belong = 1;
                break;
            case "1330815794078793730":
                belong = 2;
                break;
            case "1330815908893671426":
                belong = 3;
                break;
            case "1330816008898461698":
                belong = 4;
                break;
            case "1330816053479718913":
                belong = 5;
                break;
            default:
                belong = null;
                break;
        }
        return belong;
    }
}
