package com.ejianc.business.fbxt.grap.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.vo.AssignmrnyBookVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SupplierConfirmVO;
import com.ejianc.business.fbxt.grap.vo.GrapVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 进度计量实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("grap")
public class GrapController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IGrapService service;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改（saveState=0为暂存，saveState=1为保存）
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GrapVO> saveOrUpdate(@RequestBody GrapVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }
    /**
     * @Description saveOrUpdate 供方推送 新增
     */
    @RequestMapping(value = "/assSave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> assSaveOrUpdate(@RequestBody AssignmrnyBookVO assignmrnyBookVO) {
        return CommonResponse.success("插入数据成功！", service.assSaveOrUpdate(assignmrnyBookVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GrapVO> queryDetail(Long id) {
    	GrapEntity entity = service.selectById(id);
    	GrapVO vo = BeanMapper.map(entity, GrapVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GrapVO> vos) {
        for(GrapVO vo : vos){
            LambdaQueryWrapper<GrapEntity> query = new LambdaQueryWrapper<>();
            // 校验
            query.eq(GrapEntity::getSource,1);
            query.eq(GrapEntity::getId, vo.getId());
            query.eq(GrapEntity::getDr, 0);
            List<GrapEntity> grapEntities = service.list(query);
            if (CollectionUtils.isNotEmpty(grapEntities)){
                throw new BusinessException("来源是供方申请不允许删除！");
            }
        }
        service.removeByIds(vos.stream().map(GrapVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表（saveState=0为暂存，saveState=1为保存）
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GrapVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 权限隔离 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        // 默认查看保存态
        if(!param.getParams().containsKey("saveState")){
            param.getParams().put("saveState", new Parameter(QueryParam.EQ, 1));
        }
        IPage<GrapEntity> page = service.queryPage(param,false);
        IPage<GrapVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GrapVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description getcount 暂存条数
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/getcount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        param.getParams().put("saveState", new Parameter(QueryParam.EQ, 0));
        CommonResponse<IPage<GrapVO>> response = this.queryList(param);
        return CommonResponse.success("查询成功！",response.getData().getTotal());
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<GrapVO>> res = this.queryList(param);
        List<GrapVO> list = new ArrayList<>();
        if(res.isSuccess() && res.getData() != null && CollectionUtils.isNotEmpty(res.getData().getRecords())){
            list = res.getData().getRecords();
            list.forEach(vo -> {
                String useStateName = "";
                if(vo.getUseState() != null && vo.getUseState() == 1) {
                    useStateName = "是";
                } else {
                    useStateName = "否";
                }
                vo.setUseStateName(useStateName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("grap-export.xlsx", beans, response);
    }
    //五局调用供方
    @RequestMapping(value = "/supplierConfirm", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> supplierConfirm(@RequestBody SupplierConfirmVO billStateVO) {
        return service.supplierConfirm(billStateVO);
    }

    //根据项目查询自制 供方数据条数
    @RequestMapping(value = "/querySourceNumber", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Integer> querySourceNumber(@RequestBody GrapVO grapVO) {
        LambdaQueryWrapper<GrapEntity> query = new LambdaQueryWrapper<>();
        query.eq(GrapEntity::getSource,grapVO.getSource());
        query.eq(GrapEntity::getSaveState, 0);
        query.eq(GrapEntity::getDr, 0);
        query.eq(GrapEntity::getTenantId, InvocationInfoProxy.getTenantid());
        query.eq(GrapEntity::getProjectId, grapVO.getProjectId());
        List<GrapEntity> grapEntities = service.list(query);
        Integer sum=  Integer.valueOf(grapEntities.size());
        return CommonResponse.success("查询成功！",sum);
    }

    /**
     * @Description pushToSumGrap
     * @param billId
     */
    @RequestMapping(value = "/pushToSumGrap", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushToSumGrap(@RequestParam(value = "billId") Long billId) {
        return service.pushToSumGrap(billId);
    }
}
