/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.bean.SumGrapDetailEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.mapper.SumGrapMapper;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.sysupl.SumGrapDetailRequset;
import com.ejianc.business.fbxt.odd.vo.sysupl.SumGrapRequset;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sync.api.IGrapSyncApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sumGrapService")
public class SumGrapServiceImpl
extends BaseServiceImpl<SumGrapMapper, SumGrapEntity>
implements ISumGrapService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FBXT_SUM_GRAP = "FBXT_SUM_GRAP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IGrapSyncApi grapSyncApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOddService oddService;
    @Value(value="${openApi.wjSumGrapUrl}")
    private String wjSumGrapUrl;
    @Value(value="${openApi.wjDelSumGrapUrl}")
    private String wjDelSumGrapUrl;

    @Override
    public SumGrapVO saveOrUpdate(SumGrapVO saveorUpdateVO) {
        SumGrapEntity entity = (SumGrapEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SumGrapEntity.class));
        CommonResponse project = this.projectApi.queryProjectBySourceId(entity.getProjectSourceId());
        if (!project.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u8be6\u60c5\u5931\u8d25\uff01");
        }
        entity.setRealCorpId(((ProjectRegisterVO)project.getData()).getRealCorpId());
        entity.setRealNcCorp(((ProjectRegisterVO)project.getData()).getRealNcCorp());
        entity.setRealCorpName(((ProjectRegisterVO)project.getData()).getRealCorpName());
        List detailList = saveorUpdateVO.getDetailList();
        ArrayList childList = new ArrayList();
        for (SumGrapDetailVO detail : detailList) {
            if (!CollectionUtils.isNotEmpty((Collection)detail.getChildren())) continue;
            childList.addAll(detail.getChildren());
        }
        if (CollectionUtils.isNotEmpty(childList)) {
            detailList.addAll(childList);
        }
        entity.setDetailList(BeanMapper.mapList((Iterable)detailList, SumGrapDetailEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(FBXT_SUM_GRAP, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setConfirmFlag(0);
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public SumGrapVO queryDetail(Long id) {
        SumGrapEntity entity = (SumGrapEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        SumGrapVO vo = (SumGrapVO)BeanMapper.map((Object)((Object)entity), SumGrapVO.class);
        ArrayList list = new ArrayList();
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(item -> {
                if (item.getParentId() == null) {
                    list.add(item);
                }
            });
            list.forEach(item -> {
                ArrayList listd = new ArrayList();
                detailList.forEach(e -> {
                    if (item.getId().equals(e.getParentId())) {
                        listd.add(e);
                    }
                });
                Collections.sort(listd, new Comparator<SumGrapDetailVO>(){

                    @Override
                    public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                        Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000.0 - Double.valueOf(o2.getDetailIndex()) * 10000.0;
                        int i = vlaue.intValue();
                        return i;
                    }
                });
                item.setChildren(listd);
            });
            Collections.sort(list, new Comparator<SumGrapDetailVO>(){

                @Override
                public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                    Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000.0 - Double.valueOf(o2.getDetailIndex()) * 10000.0;
                    int i = vlaue.intValue();
                    return i;
                }
            });
            vo.setDetailList(list);
        }
        return vo;
    }

    @Override
    public CommonResponse syncUseState(HttpServletRequest request) {
        this.logger.info("--> \u540c\u6b65NC\u4e2d\u95f4\u8868\u5f00\u59cb");
        String param = request.getParameter("param");
        JSONArray jsonArray = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        int day = jsonArray.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + day + "----");
        CommonResponse response = this.grapSyncApi.selectStatus(Integer.valueOf(day));
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.logger.info("--> \u83b7\u53d6NC\u4e2d\u95f4\u8868\u6570\u636e:" + JSONObject.toJSONString((Object)response));
        List list = (List)response.getData();
        ArrayList<Long> yids = new ArrayList<Long>();
        ArrayList<Long> nids = new ArrayList<Long>();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            String str = obj != null ? JSONObject.toJSONString(obj) : "";
            JSONObject json = JSON.parseObject((String)str);
            String CSRCID = json.getString("CSRCID");
            String BISSETTLE = json.getString("BISSETTLE");
            if (!StringUtils.isNotEmpty((CharSequence)CSRCID) || !CSRCID.startsWith("ST-")) continue;
            Long id = Long.valueOf(CSRCID.substring("ST-".length()));
            if ("Y".equals(BISSETTLE)) {
                yids.add(id);
                continue;
            }
            nids.add(id);
        }
        this.logger.info("--> yids:" + JSONObject.toJSONString(yids));
        this.logger.info("--> nids:" + JSONObject.toJSONString(nids));
        if (CollectionUtils.isNotEmpty(yids)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, yids);
            updateWrapper.set(SumGrapEntity::getUseState, (Object)1);
            super.update((Wrapper)updateWrapper);
        }
        if (CollectionUtils.isNotEmpty(nids)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, nids);
            updateWrapper.set(SumGrapEntity::getUseState, (Object)0);
            super.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> confirmFlagUpdate(String id, Integer confirmFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(SumGrapEntity::getConfirmFlag, (Object)confirmFlag);
        boolean flag = this.update((Wrapper)updateWrapper);
        if (flag) {
            return CommonResponse.success((String)"\u4f9b\u65b9\u786e\u8ba4\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u4f9b\u65b9\u786e\u8ba4\u5931\u8d25\uff01");
    }

    @Override
    public void pushSumGrap(SumGrapVO sumGrapVO) {
        SumGrapRequset sumGrapRequset = this.grapOrRequest(sumGrapVO);
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.oddService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.pushSumGrap(headers, sumGrapRequset);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    public CommonResponse<String> pushSumGrap(Map<String, String> headers, SumGrapRequset copy) {
        String url = this.wjSumGrapUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }

    @Override
    public void delSumGrap(SumGrapVO sumGrapVO) {
        SumGrapRequset sumGrapRequset = this.grapOrRequest(sumGrapVO);
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.oddService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.delSumGrap(headers, sumGrapRequset);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    public CommonResponse<String> delSumGrap(Map<String, String> headers, SumGrapRequset copy) {
        String url = this.wjDelSumGrapUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }

    public SumGrapRequset grapOrRequest(SumGrapVO sumGrapVO) {
        SumGrapRequset sumGrapRequset = new SumGrapRequset();
        sumGrapRequset.setPkGrap(sumGrapVO.getId().toString());
        sumGrapRequset.setBillState(sumGrapVO.getBillState());
        sumGrapRequset.setBillCode(sumGrapVO.getBillCode());
        sumGrapRequset.setProjectId(sumGrapVO.getProjectId().toString());
        sumGrapRequset.setProjectName(sumGrapVO.getProjectName());
        sumGrapRequset.setProjectSourceId(sumGrapVO.getProjectSourceId());
        sumGrapRequset.setRealCorpId(sumGrapVO.getRealCorpId().toString());
        sumGrapRequset.setRealNcCorp(sumGrapVO.getRealNcCorp());
        sumGrapRequset.setRealCorpName(sumGrapVO.getRealCorpName());
        sumGrapRequset.setOrgId(sumGrapVO.getOrgId().toString());
        sumGrapRequset.setOrgSourceId(sumGrapVO.getOrgSourceId());
        sumGrapRequset.setOrgName(sumGrapVO.getOrgName());
        sumGrapRequset.setContractId(sumGrapVO.getContractId());
        sumGrapRequset.setContractName(sumGrapVO.getContractName());
        sumGrapRequset.setContractCode(sumGrapVO.getContractCode());
        sumGrapRequset.setSupplierId(sumGrapVO.getSupplierSourceId());
        sumGrapRequset.setSupplierName(sumGrapVO.getSupplierName());
        sumGrapRequset.setSupplierSourceId(sumGrapVO.getSupplierSourceId());
        sumGrapRequset.setHistoryFlag(sumGrapVO.getHistoryFlag());
        sumGrapRequset.setHistoryId(sumGrapVO.getHistoryId());
        sumGrapRequset.setHistorySystem(sumGrapVO.getHistorySystem());
        sumGrapRequset.setUseState(sumGrapVO.getUseState());
        sumGrapRequset.setDescription(sumGrapVO.getDescription());
        sumGrapRequset.setSumMonth(sumGrapVO.getSumMonth());
        sumGrapRequset.setSumMny(sumGrapVO.getSumMny());
        sumGrapRequset.setSumApproveMny(sumGrapVO.getSumApproveMny());
        sumGrapRequset.setMemo(sumGrapVO.getMemo());
        sumGrapRequset.setBillState(sumGrapVO.getBillState());
        sumGrapRequset.setConfirmFlag(sumGrapVO.getConfirmFlag());
        sumGrapRequset.setTs(new Date());
        if (sumGrapRequset.getProjectSourceId() != null) {
            CommonResponse ponse = this.projectApi.queryProjectBySourceId(sumGrapRequset.getProjectSourceId());
            if (ponse.getData() == null) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)ponse.getData();
            sumGrapRequset.setCorpId(projectRegisterVO.getOrgId());
            sumGrapRequset.setCorpName(projectRegisterVO.getOrgName());
            sumGrapRequset.setCorpSourceId(projectRegisterVO.getSourceOrgId());
        }
        if (CollectionUtils.isNotEmpty((Collection)sumGrapVO.getDetailList())) {
            sumGrapRequset.setDetailList(this.grapOrGrapRequest(sumGrapVO.getDetailList()));
        }
        return sumGrapRequset;
    }

    public List<SumGrapDetailRequset> grapOrGrapRequest(List<SumGrapDetailVO> sumGrapDetailVOList) {
        ArrayList<SumGrapDetailRequset> sumGrapDetailRequsetList = new ArrayList<SumGrapDetailRequset>();
        for (SumGrapDetailVO sumGrapDetailVO : sumGrapDetailVOList) {
            if (null != sumGrapDetailVO.getParentId()) continue;
            SumGrapDetailRequset sumGrapDetailRequset = new SumGrapDetailRequset();
            sumGrapDetailRequset.setPkGrapDetail(sumGrapDetailVO.getId().toString());
            sumGrapDetailRequset.setPkGrap(sumGrapDetailVO.getSumGrapId().toString());
            sumGrapDetailRequset.setMemo(sumGrapDetailVO.getMemo());
            sumGrapDetailRequset.setCommitUserId(sumGrapDetailVO.getCommitUserId());
            sumGrapDetailRequset.setCommitUserName(sumGrapDetailVO.getCommitUserName());
            sumGrapDetailRequset.setInfoId(sumGrapDetailVO.getInfoId());
            sumGrapDetailRequset.setInfoCode(sumGrapDetailVO.getInfoCode());
            sumGrapDetailRequset.setInfoName(sumGrapDetailVO.getInfoName());
            sumGrapDetailRequset.setUnit(sumGrapDetailVO.getUnit());
            sumGrapDetailRequset.setNum(sumGrapDetailVO.getNum());
            sumGrapDetailRequset.setPrice(sumGrapDetailVO.getPrice());
            sumGrapDetailRequset.setMny(sumGrapDetailVO.getMny());
            sumGrapDetailRequset.setConstruction(sumGrapDetailVO.getConstruction());
            sumGrapDetailRequset.setDescription(sumGrapDetailVO.getDescription());
            sumGrapDetailRequset.setParentId(sumGrapDetailVO.getParentId());
            sumGrapDetailRequset.setLeafFlag(sumGrapDetailVO.getLeafFlag());
            sumGrapDetailRequset.setApproveNum(sumGrapDetailVO.getApproveNum());
            sumGrapDetailRequset.setApproveMny(sumGrapDetailVO.getApproveMny());
            sumGrapDetailRequset.setDetailIndex(sumGrapDetailVO.getDetailIndex());
            sumGrapDetailRequset.setOldNum(sumGrapDetailVO.getOldNum());
            sumGrapDetailRequset.setTs(new Date());
            sumGrapDetailRequsetList.add(sumGrapDetailRequset);
        }
        return sumGrapDetailRequsetList;
    }
}

