/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.bean.OddRedirectEntity;
import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddRedirectService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddDetailVO;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddWriteBackRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.PcaOdd;
import com.ejianc.business.fbxt.odd.vo.sysupl.PcaOddInfo;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.fbxt.util.MsgUtil;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.business.sync.vo.OddRedirectVO;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="oddService")
public class OddServiceImpl
extends BaseServiceImpl<OddMapper, OddEntity>
implements IOddService {
    private static final String ODD_CODE = "ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;
    @Autowired
    private IOddInfoApplyService oddInfoApplyService;
    @Autowired
    private IOddSyncApi oddSyncApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ISupplierApi supplierApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.wjOddJobUrl}")
    private String wjOddJobUrl;
    @Value(value="${openApi.wjOddPcaUrl}")
    private String wjOddPcaUrl;
    @Value(value="${openApi.wjOddPcaDelUrl}")
    private String wjOddPcaDelUrl;
    @Value(value="${openApi.wjOddApplyUsedUrl}")
    private String wjOddApplyUsedUrl;
    @Value(value="${openApi.wjOddApplyBatchNoUsedUrl}")
    private String wjOddApplyBatchNoUsedUrl;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private MsgUtil msgUtil;

    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        QueryParam queryParam;
        CommonResponse project;
        CommonResponse orgVo;
        this.logger.error("odd save json is " + JSONObject.toJSONString((Object)saveorUpdateVO));
        CommonResponse response = this.oddSyncApi.nameContain((com.ejianc.business.sync.vo.OddVO)BeanMapper.map((Object)saveorUpdateVO, com.ejianc.business.sync.vo.OddVO.class));
        this.logger.error(JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        if (saveorUpdateVO.getOddStatus() != null && saveorUpdateVO.getOddStatus() == 0) {
            this.dealInfo(saveorUpdateVO.getOddInfoEntities());
        } else {
            this.isEnter(saveorUpdateVO.getOddInfoEntities());
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            saveorUpdateVO.setOddSource(Integer.valueOf(0));
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "add";
        }
        CommonResponse cropVo = this.orgApi.getOneById(entity.getCropId());
        if (!cropVo.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != cropVo.getData()) {
            entity.setCropSourceId(((OrgVO)cropVo.getData()).getSourceId());
        }
        if (!(orgVo = this.orgApi.getOneById(entity.getOrgId())).isSuccess()) {
            return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setOrgSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        if (!(project = this.projectApi.queryProjectBySourceId(entity.getProjectSourceId())).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u8be6\u60c5\u5931\u8d25\uff01");
        }
        entity.setRealCorpId(((ProjectRegisterVO)project.getData()).getRealCorpId());
        entity.setRealNcCorp(((ProjectRegisterVO)project.getData()).getRealNcCorp());
        entity.setRealCorpName(((ProjectRegisterVO)project.getData()).getRealCorpName());
        List oddInfoEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getOddInfoEntities(), OddInfoEntity.class);
        List fileIds = saveorUpdateVO.getFileIds();
        entity.setImportFlag(0);
        if (CollectionUtils.isNotEmpty((Collection)oddInfoEntities)) {
            for (OddInfoEntity oddInfoEntity : oddInfoEntities) {
                oddInfoEntity.setInfoNcFlag(0);
                StringBuffer zkcontract = new StringBuffer();
                StringBuffer zkcorpname = new StringBuffer();
                if (CollectionUtils.isNotEmpty(oddInfoEntity.getOddRedirectEntities())) {
                    for (OddRedirectEntity oddRedirectEntity : oddInfoEntity.getOddRedirectEntities()) {
                        if (oddRedirectEntity.getContractName() != null) {
                            zkcontract.append(oddRedirectEntity.getContractName() + ",");
                        }
                        if (oddRedirectEntity.getSuppliername() == null) continue;
                        zkcorpname.append(oddRedirectEntity.getSuppliername() + ",");
                    }
                    if (zkcontract.length() > 0) {
                        zkcontract.deleteCharAt(zkcontract.length() - 1);
                    }
                    if (zkcorpname.length() > 0) {
                        zkcorpname.deleteCharAt(zkcorpname.length() - 1);
                    }
                    oddInfoEntity.setZkcontract(zkcontract.toString());
                    oddInfoEntity.setZkcorpname(zkcorpname.toString());
                    continue;
                }
                oddInfoEntity.setZkcontract(null);
                oddInfoEntity.setZkcorpname(null);
            }
        }
        entity.setOddInfoEntities(oddInfoEntities);
        LambdaQueryWrapper lambda1 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambda1.eq(OddEntity::getProjectId, (Object)saveorUpdateVO.getProjectId())).eq(OddEntity::getContractId, (Object)saveorUpdateVO.getContractId())).eq(OddEntity::getSettleNcFlag, (Object)1);
        List oddEntityList = this.list((Wrapper)lambda1);
        oddEntityList.stream().map(OddEntity::getReviewMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.saveOrUpdate((Object)entity, false);
        if (entity.getOddApplyId() != null) {
            this.syncApplyFile(entity.getOddApplyId(), entity.getId());
        }
        if ("edit".equals(operateType)) {
            this.redirectService.remove((Wrapper)new QueryWrapper().eq((Object)"odd_id", (Object)entity.getId()));
        }
        ArrayList<OddRedirectEntity> saveRedirects = new ArrayList<OddRedirectEntity>();
        for (OddInfoEntity info : entity.getOddInfoEntities()) {
            List<OddRedirectEntity> list = info.getOddRedirectEntities();
            if (!CollectionUtils.isNotEmpty(list)) continue;
            for (OddRedirectEntity re : list) {
                re.setInfoId(info.getId());
                re.setOddId(entity.getId());
                re.setId(null);
                re.setRedirectNcFlag(0);
                saveRedirects.add(re);
            }
        }
        if (CollectionUtils.isNotEmpty(saveRedirects)) {
            this.redirectService.saveBatch(saveRedirects);
        }
        if (entity.getSourceType() == 0 && entity.getOddStatus() == 1) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            queryParam.getParams().put("oddStatus", new Parameter("ne", (Object)0));
            queryParam.getParams().put("oddApplyId", new Parameter("eq", (Object)entity.getOddApplyId()));
            List oddEntities = super.queryList(queryParam, false);
            if (oddEntities != null && oddEntities.size() > 0) {
                throw new BusinessException("\u8be5\u7528\u5de5\u7533\u8bf7\u5355\u5df2\u88ab\u5f15\u7528");
            }
            OddApplyEntity oddApplyEntity = (OddApplyEntity)((Object)this.oddApplyService.selectById(entity.getOddApplyId()));
            if (oddApplyEntity.getPassFlag() != null && oddApplyEntity.getPassFlag() != -1) {
                String url = this.wjOddApplyUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOdd(entity.getId());
                request.setPkOddApply(entity.getOddApplyId());
                request.setIsused(Integer.valueOf(1));
                this.writeBackApplyToSupl(request, url);
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)1);
            updateWrapper.set(OddApplyEntity::getOddId, (Object)entity.getId());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getOddApplyId());
            this.oddApplyService.update((Wrapper)updateWrapper);
        }
        if (fileIds != null && fileIds.size() > 0) {
            this.fileApi.updateAttachRef(entity.getId(), fileIds);
        }
        queryParam = new QueryParam();
        queryParam.getParams().put("oddId", new Parameter("eq", (Object)entity.getId()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
        List dddRedirectEntityes = this.redirectService.queryList(queryParam, false);
        if (dddRedirectEntityes != null && dddRedirectEntityes.size() > 0) {
            entity.setRedirectFlag(1);
            BigDecimal zkmny = new BigDecimal("0");
            for (OddRedirectEntity oddRedirectEntity : dddRedirectEntityes) {
                zkmny = ComputeUtil.safeAdd((BigDecimal)zkmny, (BigDecimal)oddRedirectEntity.getMny());
            }
            entity.setZkmny(zkmny);
        } else {
            entity.setRedirectFlag(0);
            entity.setZkmny(null);
        }
        this.saveOrUpdate((Object)entity);
        OddVO vo = (OddVO)BeanMapper.map((Object)((Object)entity), OddVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private boolean syncApplyFile(Long oddApplyId, Long oddId) {
        ArrayList returnAttachList = new ArrayList();
        CommonResponse attachmentRes = this.attachmentApi.queryListBySourceId(oddApplyId, "BT201123000000001", "oddapply", null);
        if (attachmentRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)attachmentRes.getData()))) {
            List oddApplyAttachmentList = (List)attachmentRes.getData();
            for (AttachmentVO applyAttach : oddApplyAttachmentList) {
                applyAttach.setSourceId(oddId);
                applyAttach.setBillType("BT201123000000002");
                applyAttach.setSourceType("odd");
                applyAttach.setId(null);
                applyAttach.setCreateUserCode(null);
                applyAttach.setCreateTime(null);
                applyAttach.setUpdateUserCode(null);
                applyAttach.setUpdateTime(null);
            }
            CommonResponse flag = this.attachmentApi.insertBatch(oddApplyAttachmentList);
            if (!flag.getMsg().equals("\u65b0\u589e\u6210\u529f")) {
                throw new BusinessException(flag.getMsg());
            }
        }
        return true;
    }

    private void dealInfo(List<OddInfoVO> oddInfoVOS) {
        if (CollectionUtils.isNotEmpty(oddInfoVOS)) {
            for (OddInfoVO infoVO : oddInfoVOS) {
                infoVO.setNum(infoVO.getNum() == null ? BigDecimal.ZERO : infoVO.getNum());
            }
        }
    }

    private void isEnter(List<OddInfoVO> infoVOList) {
        if (CollectionUtils.isEmpty(infoVOList)) {
            throw new BusinessException("\u5b50\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (OddInfoVO vo : infoVOList) {
            if (vo.getName() == null || vo.getName().length() <= 0) {
                throw new BusinessException("\u7528\u5de5\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getNum() == null) {
                throw new BusinessException("\u6e05\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getCode() == null || vo.getCode().length() <= 0) {
                throw new BusinessException("\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getInfoUnit() == null || vo.getInfoUnit().length() <= 0) {
                throw new BusinessException("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getPrice() == null) {
                throw new BusinessException("\u65e0\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getBeginTime() == null) {
                throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getEndTime() != null) continue;
            throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void del(List<OddVO> vos) {
        List list = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", list));
        List oddEntities = super.queryList(queryParam, false);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (OddEntity entity : oddEntities) {
            if (entity.getSourceType() == 2) {
                throw new BusinessException("\u4f9b\u65b9\u540c\u6b65\u7684\u96f6\u5de5\u5355\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            if (entity.getSourceType() != 0) continue;
            ids.add(entity.getOddApplyId());
        }
        if (ids.size() > 0) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getDr, (Object)0);
            lambda.in(BaseEntity::getId, ids);
            List applyEntities = this.oddApplyService.list((Wrapper)lambda);
            ArrayList<Long> pkOddApplyList = new ArrayList<Long>();
            for (OddApplyEntity applyEntity : applyEntities) {
                if (applyEntity.getPassFlag() == null || applyEntity.getPassFlag() == -1) continue;
                pkOddApplyList.add(applyEntity.getId());
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)0);
            updateWrapper.set(OddApplyEntity::getOddId, null);
            updateWrapper.in(BaseEntity::getId, ids);
            this.oddApplyService.update((Wrapper)updateWrapper);
            if (pkOddApplyList.size() > 0) {
                String url = this.wjOddApplyBatchNoUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOddApplyList(pkOddApplyList);
                this.writeBackApplyToSupl(request, url);
            }
        }
    }

    @Override
    public OddVO queryDetail(Long id) {
        OddEntity entity = (OddEntity)((Object)this.selectById(id));
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = (OddVO)BeanMapper.map((Object)((Object)entity), OddVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam = null;
            for (OddInfoVO infovo : oddInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter("eq", (Object)infovo.getId()));
                List redirectEntities = this.redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList((Iterable)redirectEntities, com.ejianc.business.fbxt.odd.vo.OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }

    @Override
    public List<OddDetailVO> queryDetailsList(Page<OddDetailVO> page, QueryWrapper queryWrapper) {
        return ((OddMapper)this.baseMapper).queryDetailsList(page, queryWrapper);
    }

    @Override
    public List<OddDetailVO> queryDetailsListConcat(Page<OddDetailVO> page, QueryWrapper queryWrapper) {
        return ((OddMapper)this.baseMapper).queryDetailsListConcat(page, queryWrapper);
    }

    @Override
    public OddDetailVO queryRedirect(Long infoId) {
        return ((OddMapper)this.baseMapper).queryRedirect(infoId);
    }

    @Override
    public CommonResponse<String> settleNc(OddSyncVo vo) {
        QueryParam queryParam;
        QueryParam queryParam2;
        List yinfo = vo.getYinfo();
        List ninfo = vo.getNinfo();
        List yredirect = vo.getYredirect();
        List nredirect = vo.getNredirect();
        if (yinfo != null && yinfo.size() > 0) {
            LambdaUpdateWrapper yupdateWrapper = new LambdaUpdateWrapper();
            yupdateWrapper.set(OddInfoEntity::getInfoNcFlag, (Object)1);
            yupdateWrapper.in(BaseEntity::getId, (Collection)yinfo);
            this.oddInfoService.update((Wrapper)yupdateWrapper);
        }
        if (ninfo != null && ninfo.size() > 0) {
            LambdaUpdateWrapper nupdateWrapper = new LambdaUpdateWrapper();
            nupdateWrapper.set(OddInfoEntity::getInfoNcFlag, (Object)0);
            nupdateWrapper.in(BaseEntity::getId, (Collection)ninfo);
            this.oddInfoService.update((Wrapper)nupdateWrapper);
        }
        if (yredirect != null && yredirect.size() > 0) {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, (Object)1);
            tupdateWrapper.in(BaseEntity::getId, (Collection)yredirect);
            this.redirectService.update((Wrapper)tupdateWrapper);
        }
        if (nredirect != null && nredirect.size() > 0) {
            LambdaUpdateWrapper fupdateWrapper = new LambdaUpdateWrapper();
            fupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, (Object)0);
            fupdateWrapper.in(BaseEntity::getId, (Collection)nredirect);
            this.redirectService.update((Wrapper)fupdateWrapper);
        }
        HashSet<Long> yids = new HashSet<Long>();
        if (yinfo != null && yinfo.size() > 0) {
            queryParam2 = new QueryParam();
            queryParam2.getParams().put("id", new Parameter("in", (Object)yinfo));
            List oddInfos = this.oddInfoService.queryList(queryParam2, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    yids.add(infoEntity.getOddId());
                }
            }
        }
        if (yredirect != null && yredirect.size() > 0) {
            queryParam2 = new QueryParam();
            queryParam2.getParams().put("id", new Parameter("in", (Object)yredirect));
            List redirects = this.redirectService.queryList(queryParam2, false);
            if (redirects != null && redirects.size() > 0) {
                for (Object redirectEntity : redirects) {
                    yids.add(((OddRedirectEntity)((Object)redirectEntity)).getOddId());
                }
            }
        }
        if (yids != null && yids.size() > 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddEntity::getSettleNcFlag, (Object)1);
            updateWrapper.in(BaseEntity::getId, yids);
            super.update((Wrapper)updateWrapper);
        }
        HashSet<Long> nids = new HashSet<Long>();
        if (ninfo != null && ninfo.size() > 0) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", (Object)ninfo));
            List oddInfos = this.oddInfoService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    nids.add(infoEntity.getOddId());
                }
            }
        }
        if (nredirect != null && nredirect.size() > 0) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", (Object)nredirect));
            List redirects = this.redirectService.queryList(queryParam, false);
            if (redirects != null && redirects.size() > 0) {
                for (Object redirectEntity : redirects) {
                    nids.add(((OddRedirectEntity)((Object)redirectEntity)).getOddId());
                }
            }
        }
        if (nids != null && nids.size() > 0) {
            List<Long> longList = ((OddMapper)this.baseMapper).querySettleFlag(new ArrayList<Long>(nids));
            ArrayList<Long> oddids = new ArrayList<Long>();
            HashSet<Long> set = new HashSet<Long>(longList);
            for (Long id : nids) {
                if (set.contains(id)) continue;
                oddids.add(id);
            }
            if (oddids != null && oddids.size() > 0) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(OddEntity::getSettleNcFlag, (Object)0);
                updateWrapper.in(BaseEntity::getId, oddids);
                super.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @Override
    public Boolean suplInsert(com.ejianc.business.fbxt.odd.vo.sysupl.OddVO request) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String billType = "BT201123000000002";
        OddEntity entity = null;
        String applyCreateUserCode = null;
        if (null != request.getPkOddApply()) {
            OddApplyEntity applyEntity = (OddApplyEntity)((Object)this.oddApplyService.selectById(request.getPkOddApply()));
            applyCreateUserCode = applyEntity.getCreateUserCode();
            entity = (OddEntity)((Object)BeanMapper.map((Object)((Object)applyEntity), OddEntity.class));
            entity.setOddApplyId(request.getPkOddApply());
            entity.setOddApplyBillCode(applyEntity.getBillCode());
        } else {
            CommonResponse response1;
            entity = new OddEntity();
            entity.setContractId(request.getPkContract());
            entity.setContractCode(request.getContractCode());
            entity.setContractName(request.getContractName());
            entity.setUseDesc(request.getOddDesc());
            entity.setUseMny(request.getPricesum());
            entity.setReviewMny(request.getSumcheck());
            entity.setUseType(Long.valueOf("1330815360484229121"));
            entity.setUseTypeName("\u96f6\u661f\u7528\u5de5");
            entity.setBelong(Long.valueOf("1330815675283521538"));
            entity.setBelongName("\u7ef4\u4fee");
            entity.setPlanBody(request.getPlanBody());
            CommonResponse response = this.projectApi.queryProjectBySourceId(request.getPkProject());
            if (response.isSuccess() && null != response.getData()) {
                ProjectRegisterVO registerVO = (ProjectRegisterVO)response.getData();
                entity.setProjectId(registerVO.getId());
                entity.setProjectName(registerVO.getName());
                entity.setProjectSourceId(registerVO.getSourceId());
                entity.setRealCorpId(registerVO.getRealCorpId());
                entity.setRealNcCorp(registerVO.getRealNcCorp());
                entity.setRealCorpName(registerVO.getRealCorpName());
                entity.setOrgId(registerVO.getProjectDepartmentId());
                entity.setOrgName(registerVO.getName());
                entity.setOrgSourceId(registerVO.getSourceId());
                response1 = this.orgApi.getOneById(registerVO.getOrgId());
                if (!response1.isSuccess() || null == response1.getData()) {
                    throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
            } else {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            OrgVO orgVO = (OrgVO)response1.getData();
            entity.setCropId(orgVO.getId());
            entity.setCropName(orgVO.getName());
            entity.setCropSourceId(orgVO.getSourceId());
            CommonResponse commonResponse = this.supplierApi.queryBySourceId(request.getPkSupplier());
            if (commonResponse.isSuccess() && null != commonResponse.getData()) {
                SupplierVO supplierVO = (SupplierVO)commonResponse.getData();
                entity.setSupplierId(String.valueOf(supplierVO.getId()));
                entity.setSupplierName(supplierVO.getName());
                entity.setSupplierSourceId(request.getPkSupplier());
            } else {
                throw new BusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        entity.setId(null);
        entity.setBillCode(request.getOddCode());
        try {
            entity.setCreateDate(sdf.parse(request.getCreateDate()));
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        entity.setUseMny(request.getPricesum());
        entity.setReviewMny(request.getSumcheck());
        entity.setSourceType(2);
        entity.setOddStatus(1);
        entity.setBillState(0);
        entity.setRedirectFlag(request.getRedirectStatus());
        entity.setCreateName(request.getName());
        entity.setSettleNcFlag(0);
        entity.setOddSource(0);
        entity.setImportFlag(0);
        entity.setSourceId(request.getPkOdd());
        entity.setZkmny(request.getSumredirect());
        super.saveOrUpdate((Object)entity);
        List oddInfoList = request.getOddInfoList();
        if (oddInfoList != null && oddInfoList.size() > 0) {
            ArrayList<OddInfoEntity> oddInfoEntities = new ArrayList<OddInfoEntity>();
            for (com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo : oddInfoList) {
                AttachmentVO file;
                OddInfoEntity oddInfoEntity = this.mapInfo(vo, entity.getId());
                oddInfoEntities.add(oddInfoEntity);
                List befFileList = vo.getBefFileList();
                List aftFileList = vo.getAftFileList();
                ArrayList<AttachmentVO> fileList = new ArrayList<AttachmentVO>();
                if (befFileList != null && befFileList.size() > 0) {
                    for (FileRelation f : befFileList) {
                        file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("before_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath(f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(Long.valueOf(10123L));
                        fileList.add(file);
                    }
                }
                if (aftFileList != null && aftFileList.size() > 0) {
                    for (FileRelation f : aftFileList) {
                        file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("after_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath(f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(Long.valueOf(10123L));
                        fileList.add(file);
                    }
                }
                if (fileList.size() <= 0) continue;
                this.attachmentApi.insertBatch(fileList);
            }
            this.oddInfoService.saveOrUpdateBatch(oddInfoEntities);
        }
        if (null != entity.getOddApplyId()) {
            this.writeBackApply(entity.getId(), entity.getOddApplyId(), true);
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            messageType.add("wjyOdd");
            String subject = "\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011\u63d0\u4ea4\u7684\u3010\u96f6\u661f\u7528\u5de5\u5ba1\u6279\u5355_" + entity.getBillCode() + "_" + sdf.format(new Date()) + "\u3011\u9700\u8981\u786e\u8ba4\u6216\u9a73\u56de";
            ArrayList<String> sender = new ArrayList<String>();
            String createUserId = this.msgUtil.getCreateUserId(applyCreateUserCode);
            sender.add(createUserId);
            String formurl = this.baseHost + "cscec5b-fbxt-frontend/#/odd/card?id=" + entity.getId();
            String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.msgUtil.sendMsg(messageType, sender, "task", subject, content, entity.getId());
        }
        return true;
    }

    @Override
    public Boolean confirmSupply(OddVO request, Integer oddStatus) {
        OddEntity odd = (OddEntity)((Object)super.selectById((Serializable)request.getId()));
        if (BillStatusEnum.\u786e\u8ba4\u9a73\u56de.getCode() == oddStatus) {
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            if (null != odd.getOddApplyId()) {
                this.writeBackApply(odd.getId(), odd.getOddApplyId(), false);
            }
            super.removeById((Serializable)request.getId());
            this.sendMsg(odd, oddStatus);
        } else {
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            super.saveOrUpdate((Object)odd);
        }
        return true;
    }

    private OddInfoEntity mapInfo(com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo, Long oddId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OddInfoEntity res = new OddInfoEntity();
        if (null != vo.getPkApplyInfo()) {
            OddInfoApplyEntity oddInfoApplyEntity = (OddInfoApplyEntity)((Object)this.oddInfoApplyService.selectById(vo.getPkApplyInfo()));
            res.setSourceType(oddInfoApplyEntity.getSourceType());
            res.setSourceId(oddInfoApplyEntity.getSourceId());
            res.setInfoApplyId(vo.getPkApplyInfo());
            res.setPkMeasdoc(oddInfoApplyEntity.getPkMeasdoc());
        } else {
            res.setSourceType(0);
            res.setSourceId(vo.getSourceId());
            res.setPkAmountlist(vo.getPkAmountlist());
            res.setHtywnr(vo.getHtywnr());
            res.setPkMeasdoc(vo.getPkMeasdoc());
        }
        res.setId(null);
        res.setOddId(oddId);
        res.setName(vo.getInfoName());
        res.setNum(vo.getInfoAmount());
        res.setApplyNum(vo.getApplyAmount());
        res.setPrice(vo.getUnitPrice());
        res.setMny(vo.getSumPrice());
        res.setCode(vo.getInfoCode());
        res.setInfoUnit(vo.getInfoUnit());
        res.setReviewNum(vo.getInfoAmountCheck());
        res.setReviewPrice(vo.getUnitPriceCheck());
        res.setReviewMny(vo.getSumPriceCheck());
        try {
            res.setBeginTime(sdf.parse(vo.getBeginTime()));
            res.setEndTime(sdf.parse(vo.getEndTime()));
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        res.setZkcontract(null);
        res.setZkcorpname(null);
        res.setSumRedirectMny(BigDecimal.ZERO);
        res.setFileType(String.valueOf(IdWorker.getId()));
        res.setInfoNcFlag(0);
        return res;
    }

    private void writeBackApply(Long pkOdd, Long pkOddApply, boolean isUsed) {
        ApplyRequest request = new ApplyRequest();
        request.setPkOddApply(pkOddApply);
        if (isUsed) {
            request.setPkOdd(pkOdd);
        } else {
            request.setIsused(Integer.valueOf(0));
        }
        this.oddApplyService.applyUsed(request);
    }

    private void writeBackApplyToSupl(ApplyRequest request, String url) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.oddApplyUsed(headers, request, url);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    @Override
    public void sendMsg(OddEntity odd, Integer oddStatus) {
        OddWriteBackRequest request = new OddWriteBackRequest();
        request.setPkOdd(odd.getSourceId());
        request.setSourceId(odd.getId());
        request.setOddStatus(oddStatus);
        request.setConfirmer(odd.getConfirmer());
        request.setConfirmerName(odd.getConfirmerName());
        request.setConfirmerNote(odd.getConfirmerNote());
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.pushOddJob(headers, request);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    @Override
    public Map<Long, String> queryDefDoc(String useTypeDefCode) {
        CommonResponse listCommonResponse = this.defdocApi.queryDetailListByDefdocCode(useTypeDefCode, null);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            HashMap<Long, String> docMap = new HashMap<Long, String>();
            for (Map map : data) {
                docMap.put(Long.parseLong(map.get("id").toString()), map.get("name").toString());
            }
            return docMap;
        }
        throw new BusinessException("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25!");
    }

    @Override
    public CommonResponse<String> pushToNc(Long id) {
        if (this.baseHost.contains("9080")) {
            this.logger.info("---------------------------\u6570\u636e\u540c\u6b65\u81f3nc");
            OddVO oddVO = this.queryDetail(id);
            com.ejianc.business.sync.vo.OddVO map = (com.ejianc.business.sync.vo.OddVO)BeanMapper.map((Object)oddVO, com.ejianc.business.sync.vo.OddVO.class);
            List oddInfoEntities = oddVO.getOddInfoEntities();
            ArrayList<com.ejianc.business.sync.vo.OddInfoVO> list = new ArrayList<com.ejianc.business.sync.vo.OddInfoVO>();
            for (OddInfoVO info : oddInfoEntities) {
                List oddRedirectEntities = info.getOddRedirectEntities();
                List redirectVO = BeanMapper.mapList((Iterable)oddRedirectEntities, OddRedirectVO.class);
                com.ejianc.business.sync.vo.OddInfoVO oddInfoVO = (com.ejianc.business.sync.vo.OddInfoVO)BeanMapper.map((Object)info, com.ejianc.business.sync.vo.OddInfoVO.class);
                oddInfoVO.setOddRedirectEntities(redirectVO);
                list.add(oddInfoVO);
            }
            map.setOddInfoEntities(list);
            this.logger.info("\u4e3b\u8868\u6765\u6e901\uff1a" + oddVO.getOddSource());
            this.logger.info("\u4e3b\u8868\u6765\u6e902\uff1a" + map.getOddSource());
            map.setOddSource(oddVO.getOddSource());
            CommonResponse response = this.oddSyncApi.syncOdd(map);
            this.logger.info("+++++++++++++++++++++++++++\u6570\u636e\u540c\u6b65\u81f3nc");
            if (response.isSuccess()) {
                com.ejianc.business.sync.vo.OddVO data = (com.ejianc.business.sync.vo.OddVO)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)data.getOddInfoEntities())) {
                    ArrayList<Object> infoEntities = new ArrayList<Object>();
                    for (com.ejianc.business.sync.vo.OddInfoVO oddInfoVO : data.getOddInfoEntities()) {
                        if (1 != oddInfoVO.getSourceType()) continue;
                        infoEntities.add(BeanMapper.map((Object)oddInfoVO, OddInfoEntity.class));
                    }
                    if (CollectionUtils.isNotEmpty(infoEntities)) {
                        this.oddInfoService.updateBatchById(infoEntities, infoEntities.size());
                    }
                }
                return CommonResponse.success();
            }
            return CommonResponse.error((String)"\u6570\u636e\u540c\u6b65\u81f3nc\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5565\u4e5f\u6ca1\u5e72");
    }

    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> pushOddJob(Map<String, String> headers, OddWriteBackRequest copy) {
        String url = this.wjOddJobUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }

    public CommonResponse<String> oddApplyUsed(Map<String, String> headers, ApplyRequest copy, String url) {
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }

    public CommonResponse<String> pushPcaOdd(Map<String, String> headers, PcaOdd copy) {
        String url = this.wjOddPcaUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }

    public CommonResponse<String> delPcaOdd(Map<String, String> headers, PcaOdd copy) {
        String url = this.wjOddPcaDelUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }

    @Override
    public CommonResponse<String> confirmState(String oddId, Integer confirmState) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)oddId);
        updateWrapper.set(OddEntity::getConfirmState, (Object)confirmState);
        boolean flag = this.update((Wrapper)updateWrapper);
        if (flag) {
            return CommonResponse.success((String)"\u4f9b\u65b9\u786e\u8ba4\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u4f9b\u65b9\u786e\u8ba4\u5931\u8d25\uff01");
    }

    @Override
    public void pushOdd(OddVO odd) {
        PcaOdd pcaOdd = this.oddorPcaOdd(odd);
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.pushPcaOdd(headers, pcaOdd);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    @Override
    public void delPcaOdd(OddVO odd) {
        PcaOdd pcaOdd = this.oddorPcaOdd(odd);
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.delPcaOdd(headers, pcaOdd);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    public PcaOdd oddorPcaOdd(OddVO odd) {
        PcaOdd pcaOdd = new PcaOdd();
        pcaOdd.setPkOdd(odd.getId().toString());
        pcaOdd.setBillCode(odd.getBillCode());
        pcaOdd.setProjectId(odd.getProjectId().toString());
        pcaOdd.setProjectName(odd.getProjectName());
        pcaOdd.setProjectSourceId(odd.getProjectSourceId());
        pcaOdd.setOrgId(odd.getOrgId().toString());
        pcaOdd.setOrgSourceId(odd.getOrgSourceId());
        pcaOdd.setOrgName(odd.getOrgName());
        pcaOdd.setContractId(odd.getContractId());
        pcaOdd.setContractName(odd.getContractName());
        pcaOdd.setContractCode(odd.getContractCode());
        pcaOdd.setSupplierId(odd.getSupplierSourceId());
        pcaOdd.setSupplierName(odd.getSupplierName());
        pcaOdd.setCreateDate(odd.getCreateDate());
        pcaOdd.setUseTypeName(odd.getUseTypeName());
        pcaOdd.setBelongName(odd.getBelongName());
        pcaOdd.setPlanBody(odd.getPlanBody());
        pcaOdd.setUseDesc(odd.getUseDesc());
        pcaOdd.setUseMny(odd.getUseMny());
        pcaOdd.setReviewMny(odd.getReviewMny());
        pcaOdd.setSourceType(odd.getSourceType());
        pcaOdd.setOddApplyId(odd.getOddApplyId() == null ? null : odd.getOddApplyId().toString());
        pcaOdd.setOddApplyBillCode(odd.getOddApplyBillCode() == null ? null : odd.getOddApplyBillCode().toString());
        pcaOdd.setOddStatus(odd.getOddStatus());
        pcaOdd.setBillState(odd.getBillState());
        pcaOdd.setRedirectFlag(odd.getRedirectFlag());
        pcaOdd.setCreateName(odd.getCreateName());
        pcaOdd.setSettleNcFlag(odd.getSettleNcFlag());
        pcaOdd.setOddSource(odd.getOddSource());
        pcaOdd.setImportFlag(odd.getImportFlag());
        pcaOdd.setMemo(odd.getMemo());
        pcaOdd.setRealCorpId(odd.getRealCorpId() == null ? null : odd.getRealCorpId().toString());
        pcaOdd.setRealNcCorp(odd.getRealNcCorp());
        pcaOdd.setRealCorpName(odd.getRealCorpName());
        pcaOdd.setSourceId(odd.getId().toString());
        pcaOdd.setConfirmer(odd.getConfirmer());
        pcaOdd.setConfirmerName(odd.getConfirmerName());
        pcaOdd.setConfirmFlag(Integer.valueOf(0));
        pcaOdd.setConfirmerNote(odd.getConfirmerNote());
        pcaOdd.setZkmny(odd.getZkmny());
        pcaOdd.setSumSettle(odd.getSumSettle());
        pcaOdd.setCreateTime(odd.getCreateTime());
        pcaOdd.setUpdateTime(odd.getUpdateTime());
        pcaOdd.setTs(new Date());
        if (pcaOdd.getProjectSourceId() != null) {
            CommonResponse ponse = this.projectApi.queryProjectBySourceId(pcaOdd.getProjectSourceId());
            if (ponse.getData() == null) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)ponse.getData();
            pcaOdd.setCorpId(projectRegisterVO.getOrgId());
            pcaOdd.setCorpName(projectRegisterVO.getOrgName());
            pcaOdd.setCorpSourceId(projectRegisterVO.getSourceOrgId());
        }
        if (CollectionUtils.isNotEmpty((Collection)odd.getOddInfoEntities())) {
            pcaOdd.setOddInfoList(this.oddInfoorPcaOddInfo(odd.getOddInfoEntities()));
        }
        return pcaOdd;
    }

    public List<PcaOddInfo> oddInfoorPcaOddInfo(List<OddInfoVO> oddInfoVOList) {
        ArrayList<PcaOddInfo> pcaOddInfoList = new ArrayList<PcaOddInfo>();
        for (OddInfoVO odd : oddInfoVOList) {
            PcaOddInfo pcaOdd = new PcaOddInfo();
            pcaOdd.setPkOddInfo(odd.getId().toString());
            pcaOdd.setPkOdd(odd.getOddId().toString());
            pcaOdd.setInfoApplyId(odd.getInfoApplyId() == null ? null : odd.getInfoApplyId().toString());
            pcaOdd.setName(odd.getName());
            pcaOdd.setNum(odd.getNum());
            pcaOdd.setApplyNum(odd.getApplyNum());
            pcaOdd.setPrice(odd.getPrice());
            pcaOdd.setMny(odd.getMny());
            pcaOdd.setCode(odd.getCode());
            pcaOdd.setInfoUnit(odd.getInfoUnit());
            pcaOdd.setReviewNum(odd.getReviewNum());
            pcaOdd.setReviewPrice(odd.getReviewPrice());
            pcaOdd.setReviewMny(odd.getReviewMny());
            pcaOdd.setSourceType(odd.getSourceType());
            pcaOdd.setFirstApply(odd.getFirstApply());
            pcaOdd.setSourceId(odd.getId().toString());
            pcaOdd.setBeginTime(odd.getBeginTime());
            pcaOdd.setEndTime(odd.getEndTime());
            pcaOdd.setZkcontract(odd.getZkcontract());
            pcaOdd.setZkcorpname(odd.getZkcorpname());
            pcaOdd.setSumRedirectMny(odd.getSumRedirectMny());
            pcaOdd.setFileType(odd.getFileType());
            pcaOdd.setInfoNcFlag(odd.getInfoNcFlag());
            pcaOdd.setPkMeasdoc(odd.getPkMeasdoc());
            pcaOdd.setPkAmountlist(odd.getPkAmountlist());
            pcaOdd.setHtywnr(odd.getHtywnr());
            pcaOdd.setTs(new Date());
            pcaOddInfoList.add(pcaOdd);
        }
        return pcaOddInfoList;
    }
}

