package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.fbxt.grap.bean.SumGrapDetailEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.mapper.SumGrapMapper;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapDetailVO;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.sysupl.SumGrapDetailRequset;
import com.ejianc.business.fbxt.odd.vo.sysupl.SumGrapRequset;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sync.api.IGrapSyncApi;
import com.ejianc.business.sync.cons.ModelCodeCons;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * 进度台账实体
 *
 * @author generator
 *
 */
@Service("sumGrapService")
public class SumGrapServiceImpl extends BaseServiceImpl<SumGrapMapper, SumGrapEntity> implements ISumGrapService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String FBXT_SUM_GRAP = "FBXT_SUM_GRAP";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IGrapSyncApi grapSyncApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IOddService oddService;

    @Value("${openApi.wjSumGrapUrl}")
    private String wjSumGrapUrl;

    @Value("${openApi.wjDelSumGrapUrl}")
    private String wjDelSumGrapUrl;

    @Override
    public SumGrapVO saveOrUpdate(SumGrapVO saveorUpdateVO) {
        SumGrapEntity entity = BeanMapper.map(saveorUpdateVO, SumGrapEntity.class);

        // 查询项目部NC 实际所属组织的的来源id
        CommonResponse<ProjectRegisterVO> project = projectApi.queryProjectBySourceId(entity.getProjectSourceId());
        if(project.isSuccess()){
            entity.setRealCorpId(project.getData().getRealCorpId());
            entity.setRealNcCorp(project.getData().getRealNcCorp());
            entity.setRealCorpName(project.getData().getRealCorpName());
        }
        else {
            throw new BusinessException("查询项目信息详情失败！");
        }

        // 处理树形子表
        List<SumGrapDetailVO> detailList = saveorUpdateVO.getDetailList();
        List<SumGrapDetailVO> childList = new ArrayList<>();
        for(SumGrapDetailVO detail : detailList){
            if(CollectionUtils.isNotEmpty(detail.getChildren())){
                childList.addAll(detail.getChildren());
            }
        }
        if(CollectionUtils.isNotEmpty(childList)){
            detailList.addAll(childList);
        }
        entity.setDetailList(BeanMapper.mapList(detailList, SumGrapDetailEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(FBXT_SUM_GRAP, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setConfirmFlag(0);
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public SumGrapVO queryDetail(Long id) {
        SumGrapEntity entity = super.selectById(id);
        if (entity == null) {
            throw new BusinessException("该单据已被删除，请刷新后重试");
        }
        SumGrapVO vo = BeanMapper.map(entity, SumGrapVO.class);
        List<SumGrapDetailVO> list = new ArrayList<>();
        List<SumGrapDetailVO> detailList = vo.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(item -> {
                if(item.getParentId() == null){
                    list.add(item);
                }
            });
            list.forEach(item -> {
                List<SumGrapDetailVO> listd = new ArrayList<>();
                detailList.forEach(e -> {
                    if(item.getId().equals(e.getParentId())){
                        listd.add(e);
                    }
                });
                Collections.sort(listd, new Comparator<SumGrapDetailVO>() {
                    @Override
                    public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                        Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000 - Double.valueOf(o2.getDetailIndex()) * 10000;
                        int i = vlaue.intValue();
                        return i;
                    }
                });
                item.setChildren(listd);
            });
            Collections.sort(list, new Comparator<SumGrapDetailVO>() {
                @Override
                public int compare(SumGrapDetailVO o1, SumGrapDetailVO o2) {
                    Double vlaue = Double.valueOf(o1.getDetailIndex()) * 10000 - Double.valueOf(o2.getDetailIndex()) * 10000;
                    int i = vlaue.intValue();
                    return i;
                }
            });
            vo.setDetailList(list);
        }
        return vo;
    }

    @Override
    public CommonResponse syncUseState(HttpServletRequest request) {
        logger.info("--> 同步NC中间表开始");
        String param = request.getParameter("param");
        JSONArray jsonArray = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是：" + param + "----");
        int day = jsonArray.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是：" + day + "----");
//        CommonResponse<List> response = grapSyncApi.getSyncImgList();
        CommonResponse<List> response = grapSyncApi.selectStatus(day);
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        logger.info("--> 获取NC中间表数据:" + JSONObject.toJSONString(response));
        List list = response.getData();
        List<Long> yids = new ArrayList<>();
        List<Long> nids = new ArrayList<>();
        for(int i = 0 ; i < list.size(); i++){
            Object obj = list.get(i);
            String str = obj != null ? JSONObject.toJSONString(obj) : "";
            JSONObject json = JSON.parseObject(str);
            String CSRCID = json.getString("CSRCID");
            String BISSETTLE = json.getString("BISSETTLE");
            if(StringUtils.isNotEmpty(CSRCID) && CSRCID.startsWith(ModelCodeCons.NC_JD)){
                Long id = Long.valueOf(CSRCID.substring(ModelCodeCons.NC_JD.length()));
                if("Y".equals(BISSETTLE)){
                    yids.add(id);
                } else {
                    nids.add(id);
                }
            }
        }
        logger.info("--> yids:" + JSONObject.toJSONString(yids));
        logger.info("--> nids:" + JSONObject.toJSONString(nids));
        if(CollectionUtils.isNotEmpty(yids)){
            LambdaUpdateWrapper<SumGrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(SumGrapEntity::getId, yids);
            updateWrapper.set(SumGrapEntity::getUseState, 1);
            super.update(updateWrapper);
        }
        if(CollectionUtils.isNotEmpty(nids)){
            LambdaUpdateWrapper<SumGrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(SumGrapEntity::getId, nids);
            updateWrapper.set(SumGrapEntity::getUseState, 0);
            super.update(updateWrapper);
        }
        return CommonResponse.success("执行成功！");
    }

    @Override
    public CommonResponse<String> confirmFlagUpdate(String id,Integer confirmFlag) {
        LambdaUpdateWrapper<SumGrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SumGrapEntity::getId, id);
        updateWrapper.set(SumGrapEntity::getConfirmFlag,confirmFlag);
        boolean flag = update(updateWrapper);
        if(flag){
            return CommonResponse.success("供方确认成功！");
        }else{
            return CommonResponse.success("供方确认失败！");
        }

    }

    @Override
    public void pushSumGrap(SumGrapVO sumGrapVO) {
        SumGrapRequset sumGrapRequset = grapOrRequest(sumGrapVO);
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = oddService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = pushSumGrap(headers, sumGrapRequset);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }

    public CommonResponse<String> pushSumGrap(Map<String, String> headers, SumGrapRequset copy) {
        String url = wjSumGrapUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }

    @Override
    public void delSumGrap(SumGrapVO sumGrapVO) {
        SumGrapRequset sumGrapRequset = grapOrRequest(sumGrapVO);
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = oddService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = delSumGrap(headers, sumGrapRequset);
            logger.info("获取推送供方结果--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("甲方系统报错，回滚数据");
            }
        } else {
            throw new BusinessException("系统推送供方时，获取供方access_token异常");
        }
    }


    public CommonResponse<String> delSumGrap(Map<String, String> headers, SumGrapRequset copy) {
        String url = wjDelSumGrapUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(copy).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方异常!");
        }
    }


    public SumGrapRequset grapOrRequest(SumGrapVO sumGrapVO ) {
        SumGrapRequset sumGrapRequset = new SumGrapRequset();
        sumGrapRequset.setPkGrap(sumGrapVO.getId().toString());
        sumGrapRequset.setBillState(sumGrapVO.getBillState());
        sumGrapRequset.setBillCode(sumGrapVO.getBillCode());
        sumGrapRequset.setProjectId(sumGrapVO.getProjectId().toString());
        sumGrapRequset.setProjectName(sumGrapVO.getProjectName());
        sumGrapRequset.setProjectSourceId(sumGrapVO.getProjectSourceId());
        sumGrapRequset.setRealCorpId(sumGrapVO.getRealCorpId().toString());
        sumGrapRequset.setRealNcCorp(sumGrapVO.getRealNcCorp());
        sumGrapRequset.setRealCorpName(sumGrapVO.getRealCorpName());
        sumGrapRequset.setOrgId(sumGrapVO.getOrgId().toString());
        sumGrapRequset.setOrgSourceId(sumGrapVO.getOrgSourceId());
        sumGrapRequset.setOrgName(sumGrapVO.getOrgName());
        sumGrapRequset.setContractId(sumGrapVO.getContractId());
        sumGrapRequset.setContractName(sumGrapVO.getContractName());
        sumGrapRequset.setContractCode(sumGrapVO.getContractCode());
        sumGrapRequset.setSupplierId(sumGrapVO.getSupplierSourceId());
        sumGrapRequset.setSupplierName(sumGrapVO.getSupplierName());
        sumGrapRequset.setSupplierSourceId(sumGrapVO.getSupplierSourceId());
        sumGrapRequset.setHistoryFlag(sumGrapVO.getHistoryFlag());
        sumGrapRequset.setHistoryId(sumGrapVO.getHistoryId());
        sumGrapRequset.setHistorySystem(sumGrapVO.getHistorySystem());
        sumGrapRequset.setUseState(sumGrapVO.getUseState());
        sumGrapRequset.setDescription(sumGrapVO.getDescription());
        sumGrapRequset.setSumMonth(sumGrapVO.getSumMonth());
        sumGrapRequset.setSumMny(sumGrapVO.getSumMny());
        sumGrapRequset.setSumApproveMny(sumGrapVO.getSumApproveMny());
        sumGrapRequset.setMemo(sumGrapVO.getMemo());
        sumGrapRequset.setBillState(sumGrapVO.getBillState());
        sumGrapRequset.setConfirmFlag(sumGrapVO.getConfirmFlag());
        sumGrapRequset.setTs(new Date());

        if(sumGrapRequset.getProjectSourceId()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<ProjectRegisterVO> ponse =  projectApi.queryProjectBySourceId(sumGrapRequset.getProjectSourceId());
            if(ponse.getData()==null) {
                throw new BusinessException("网络异常， 查询失败，请稍后再试");
            }
            ProjectRegisterVO projectRegisterVO = ponse.getData();
            sumGrapRequset.setCorpId(projectRegisterVO.getOrgId());//项目所属组织id
            sumGrapRequset.setCorpName(projectRegisterVO.getOrgName());
            sumGrapRequset.setCorpSourceId(projectRegisterVO.getSourceOrgId());//项目所属组织来源id
        }

        if(CollectionUtils.isNotEmpty(sumGrapVO.getDetailList())){
            sumGrapRequset.setDetailList(grapOrGrapRequest(sumGrapVO.getDetailList()));
        }
        return sumGrapRequset;
    }

    public List<SumGrapDetailRequset> grapOrGrapRequest(List<SumGrapDetailVO> sumGrapDetailVOList ) {
        List<SumGrapDetailRequset> sumGrapDetailRequsetList = new ArrayList<>();
        for(SumGrapDetailVO sumGrapDetailVO : sumGrapDetailVOList) {
            if(null == sumGrapDetailVO.getParentId()){
                SumGrapDetailRequset sumGrapDetailRequset = new SumGrapDetailRequset();
                sumGrapDetailRequset.setPkGrapDetail(sumGrapDetailVO.getId().toString());
                sumGrapDetailRequset.setPkGrap(sumGrapDetailVO.getSumGrapId().toString());
                sumGrapDetailRequset.setMemo(sumGrapDetailVO.getMemo());
                sumGrapDetailRequset.setCommitUserId(sumGrapDetailVO.getCommitUserId());
                sumGrapDetailRequset.setCommitUserName(sumGrapDetailVO.getCommitUserName());
                sumGrapDetailRequset.setInfoId(sumGrapDetailVO.getInfoId());
                sumGrapDetailRequset.setInfoCode(sumGrapDetailVO.getInfoCode());
                sumGrapDetailRequset.setInfoName(sumGrapDetailVO.getInfoName());
                sumGrapDetailRequset.setUnit(sumGrapDetailVO.getUnit());
                sumGrapDetailRequset.setNum(sumGrapDetailVO.getNum());
                sumGrapDetailRequset.setPrice(sumGrapDetailVO.getPrice());
                sumGrapDetailRequset.setMny(sumGrapDetailVO.getMny());
                sumGrapDetailRequset.setConstruction(sumGrapDetailVO.getConstruction());
                sumGrapDetailRequset.setDescription(sumGrapDetailVO.getDescription());
               /* sumGrapDetailRequset.setGrapId(sumGrapDetailVO.getGrapId() == null ? null : sumGrapDetailVO.getGrapId().toString());
                sumGrapDetailRequset.setGrapDetailId(sumGrapDetailVO.getGrapDetailId() == null ? null : sumGrapDetailVO.getGrapDetailId().toString());*/
                sumGrapDetailRequset.setParentId(sumGrapDetailVO.getParentId());
                sumGrapDetailRequset.setLeafFlag(sumGrapDetailVO.getLeafFlag());
                sumGrapDetailRequset.setApproveNum(sumGrapDetailVO.getApproveNum());
                sumGrapDetailRequset.setApproveMny(sumGrapDetailVO.getApproveMny());
                sumGrapDetailRequset.setDetailIndex(sumGrapDetailVO.getDetailIndex());
                sumGrapDetailRequset.setOldNum(sumGrapDetailVO.getOldNum());
                sumGrapDetailRequset.setTs(new Date());
                sumGrapDetailRequsetList.add(sumGrapDetailRequset);
            }
        }
        return sumGrapDetailRequsetList;
    }
}
