package com.ejianc.business.fbxt.odd.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.fbxt.grap.bean.RecordEntity;
import com.ejianc.business.fbxt.odd.vo.OddImportInfoVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.fbxt.odd.bean.OddImportInfoEntity;
/**
 * 零星用工导入实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_fbxt_odd")
public class OddImportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源id
    @TableField(value="crop_id")
    private Long cropId; // 项目所属组织id
    @TableField(value="crop_source_id")
    private String cropSourceId; // 项目所属组织来源id
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_source_id")
    private String orgSourceId; // 组织来源id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="contract_id")
    private String contractId; // 合同
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private String supplierId; // 供方主键
    @TableField(value="supplier_name")
    private String supplierName; // 供方名称
    @TableField(value="create_date")
    private java.util.Date createDate; // 单据日期，自己的
    @TableField(value="use_type")
    private Long useType; // 用工类型，档案
    @TableField(value="belong")
    private Long belong; // 费用归属，档案
    @TableField(value="plan_body")
    private String planBody; // 施工部位
    @TableField(value="use_desc")
    private String useDesc; // 用工内容
    @TableField(value="use_mny")
    private java.math.BigDecimal useMny; // 用工金额
    @TableField(value="review_mny")
    private java.math.BigDecimal reviewMny; // 审核金额
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型,0-参照申请，1-自制
    @TableField(value="odd_apply_id")
    private Long oddApplyId; // 用工申请主键
    @TableField(value="odd_apply_bill_code")
    private String oddApplyBillCode; // 申请单编号
    @TableField(value="odd_status")
    private Integer oddStatus; // 暂存状态，0-暂存，1-已提交
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="redirect_flag")
    private Integer redirectFlag; // 是否转扣，0-否，1-是
    @TableField(value="create_name")
    private String createName; // 申请人
    @TableField(value="settle_nc_flag")
    private Integer settleNcFlag; // nc是否结算，0-否，1-是
    @TableField(value="odd_source")
    private Integer oddSource; // 数据来源，0-新增，1-历史数据
    @TableField(value="zkmny")
    private java.math.BigDecimal zkmny; // 表体转扣金额合计
    @TableField(value="crop_name")
    private String cropName; // 所属公司
    @TableField(value="import_flag")
    private Integer importFlag; // 是否是导入数据，0-否，1-是
    @TableField(value = "memo")
    private String memo; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="oddImportInfoService", pidName = "oddId")
    private List<OddImportInfoEntity> infoVOList = new ArrayList<>(); // 零星用工导入申请单实体

    /**
     * 供方来源主键
     */
    @TableField(value = "source_id")
    private Long sourceId;

    /**
     * 确认人
     */
    private String confirmer;

    /**
     * 确认人名称
     */
    @TableField("confirmer_name")
    private String confirmerName;

    /**
     * 确认意见
     */
    @TableField("confirmer_note")
    private String confirmerNote;

    @TableField(exist=false)
    @SubEntity(serviceName="recordService",pidName = "billId")
    private List<RecordEntity> recordList = new ArrayList<>(); // 修改记录实体

    public List<RecordEntity> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<RecordEntity> recordList) {
        this.recordList = recordList;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getConfirmer() {
        return confirmer;
    }

    public void setConfirmer(String confirmer) {
        this.confirmer = confirmer;
    }

    public String getConfirmerName() {
        return confirmerName;
    }

    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }

    public String getConfirmerNote() {
        return confirmerNote;
    }

    public void setConfirmerNote(String confirmerNote) {
        this.confirmerNote = confirmerNote;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目来源id
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源id
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 项目所属组织id
     */
    public Long getCropId() {
        return cropId;
    }

    /**
     * 项目所属组织id
     */
    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    /**
     * 项目所属组织来源id
     */
    public String getCropSourceId() {
        return cropSourceId;
    }

    /**
     * 项目所属组织来源id
     */
    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源id
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源id
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供方主键
     */
    public String getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 单据日期，自己的
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 单据日期，自己的
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 用工类型，档案
     */
    public Long getUseType() {
        return useType;
    }

    /**
     * 用工类型，档案
     */
    public void setUseType(Long useType) {
        this.useType = useType;
    }
    /**
     * 费用归属，档案
     */
    public Long getBelong() {
        return belong;
    }

    /**
     * 费用归属，档案
     */
    public void setBelong(Long belong) {
        this.belong = belong;
    }
    /**
     * 施工部位
     */
    public String getPlanBody() {
        return planBody;
    }

    /**
     * 施工部位
     */
    public void setPlanBody(String planBody) {
        this.planBody = planBody;
    }
    /**
     * 用工内容
     */
    public String getUseDesc() {
        return useDesc;
    }

    /**
     * 用工内容
     */
    public void setUseDesc(String useDesc) {
        this.useDesc = useDesc;
    }
    /**
     * 用工金额
     */
    public java.math.BigDecimal getUseMny() {
        return useMny;
    }

    /**
     * 用工金额
     */
    public void setUseMny(java.math.BigDecimal useMny) {
        this.useMny = useMny;
    }
    /**
     * 审核金额
     */
    public java.math.BigDecimal getReviewMny() {
        return reviewMny;
    }

    /**
     * 审核金额
     */
    public void setReviewMny(java.math.BigDecimal reviewMny) {
        this.reviewMny = reviewMny;
    }
    /**
     * 来源类型,0-参照申请，1-自制
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型,0-参照申请，1-自制
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 用工申请主键
     */
    public Long getOddApplyId() {
        return oddApplyId;
    }

    /**
     * 用工申请主键
     */
    public void setOddApplyId(Long oddApplyId) {
        this.oddApplyId = oddApplyId;
    }
    /**
     * 申请单编号
     */
    public String getOddApplyBillCode() {
        return oddApplyBillCode;
    }

    /**
     * 申请单编号
     */
    public void setOddApplyBillCode(String oddApplyBillCode) {
        this.oddApplyBillCode = oddApplyBillCode;
    }
    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public Integer getOddStatus() {
        return oddStatus;
    }

    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public void setOddStatus(Integer oddStatus) {
        this.oddStatus = oddStatus;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 是否转扣，0-否，1-是
     */
    public Integer getRedirectFlag() {
        return redirectFlag;
    }

    /**
     * 是否转扣，0-否，1-是
     */
    public void setRedirectFlag(Integer redirectFlag) {
        this.redirectFlag = redirectFlag;
    }
    /**
     * 申请人
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 申请人
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }
    /**
     * nc是否结算，0-否，1-是
     */
    public Integer getSettleNcFlag() {
        return settleNcFlag;
    }

    /**
     * nc是否结算，0-否，1-是
     */
    public void setSettleNcFlag(Integer settleNcFlag) {
        this.settleNcFlag = settleNcFlag;
    }
    /**
     * 数据来源，0-新增，1-历史数据
     */
    public Integer getOddSource() {
        return oddSource;
    }

    /**
     * 数据来源，0-新增，1-历史数据
     */
    public void setOddSource(Integer oddSource) {
        this.oddSource = oddSource;
    }
    /**
     * 表体转扣金额合计
     */
    public java.math.BigDecimal getZkmny() {
        return zkmny;
    }

    /**
     * 表体转扣金额合计
     */
    public void setZkmny(java.math.BigDecimal zkmny) {
        this.zkmny = zkmny;
    }
    /**
     * 所属公司
     */
    public String getCropName() {
        return cropName;
    }

    /**
     * 所属公司
     */
    public void setCropName(String cropName) {
        this.cropName = cropName;
    }
    /**
     * 是否是导入数据，0-否，1-是
     */
    public Integer getImportFlag() {
        return importFlag;
    }

    /**
     * 是否是导入数据，0-否，1-是
     */
    public void setImportFlag(Integer importFlag) {
        this.importFlag = importFlag;
    }

    /**
     * 零星用工导入申请单实体
     */
    public List<OddImportInfoEntity> getInfoVOList() {
        return infoVOList;
    }

    /**
     * 零星用工导入申请单实体
     */
    public void setInfoVOList(List<OddImportInfoEntity> infoVOList) {
        this.infoVOList = infoVOList;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
