package com.ejianc.business.fbxt.comment.controller;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.comment.bean.MatSyncRecordEntity;
import com.ejianc.business.fbxt.comment.service.IMatSyncRecordService;
import com.ejianc.business.fbxt.comment.vo.MatSyncRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资关系同步记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("/api/matsync")
public class MatSyncRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMatSyncRecordService service;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value = "/insertBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> insert(@RequestBody List<MatSyncRecordVO> recordVOList) {
    	List<MatSyncRecordEntity> list = BeanMapper.mapList(recordVOList, MatSyncRecordEntity.class);
    	for(MatSyncRecordEntity recordEntity : list){
    	    recordEntity.setCorpName(orgApi.findBySourceId(recordEntity.getPkCorp()).getData().getName());
        }
    	service.saveOrUpdateBatch(list);
    	return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSyncRecordVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MatSyncRecordVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MatSyncRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatSyncRecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("corpName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<MatSyncRecordEntity> page = service.queryPage(param,false);
        IPage<MatSyncRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatSyncRecordVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @GetMapping("/updateSyncFlag")
    @ResponseBody
    public CommonResponse<String> updateSyncFlag(@RequestParam(value = "id") Long id, @RequestParam(value = "syncFlag") Integer syncFlag) {
        LambdaUpdateWrapper<MatSyncRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(MatSyncRecordEntity::getId, id);
        updateWrapper.set(MatSyncRecordEntity::getSyncFlag, syncFlag);
        service.update(updateWrapper);
        return CommonResponse.success("更新同步状态成功！");
    }
}
