package com.ejianc.business.fbxt.news.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 新闻实体
 *
 * @author generator
 *
 */
 @TableName("ejc_fbxt_news")
public class NewsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value="supplier_name")
    private String supplierName; // 发送对象集合
    @TableField(value="title")
    private String title; // 新闻标题
    @TableField(value="publish_flag")
    private Integer publishFlag; // 是否发布 ， 1：发布 ， 0：未发布
    @TableField(value="top_flag")
    private Integer topFlag; // 是否置顶, 1:置顶 ， 0： 取消置顶
    @TableField(value="publish_user")
    private String publishUser; // 发布人
    @TableField(value="publish_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date publishTime; // 发布时间
    @TableField(value="introduce")
    private String introduce; // 简介
    @TableField(value="content")
    private String content; // 内容
    @TableField(value="author")
    private String author; // 作者
    @TableField(value="enclosure_path")
    private String enclosurePath; // 附件地址
    @TableField(value="org_id")
    private Long orgId; // 发布组织ID
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="real_corp_id")
    private Long realCorpId; // NC所属组织ID
    @TableField(value="real_nc_corp")
    private String realNcCorp; // NC所属组织PK
    @TableField(value="real_corp_name")
    private String realCorpName; // NC所属组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织主键
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="type")
    private Integer type; // 发送类型1:全部2:部分供应商
    @TableField(value="memo")
    private String memo; // 备注


    @TableField(exist=false)
    @SubEntity(serviceName="newsSupplierService", pidName = "newsId")
    private List<NewsSupplierEntity> detailList = new ArrayList<>(); // 新闻子表实体

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Integer getPublishFlag() {
        return publishFlag;
    }

    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    public Integer getTopFlag() {
        return topFlag;
    }

    public void setTopFlag(Integer topFlag) {
        this.topFlag = topFlag;
    }
    public String getPublishUser() {
        return publishUser;
    }

    public void setPublishUser(String publishUser) {
        this.publishUser = publishUser;
    }
    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }
    public String getIntroduce() {
        return introduce;
    }

    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }
    public String getEnclosurePath() {
        return enclosurePath;
    }

    public void setEnclosurePath(String enclosurePath) {
        this.enclosurePath = enclosurePath;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }
    public String getRealNcCorp() {
        return realNcCorp;
    }

    public void setRealNcCorp(String realNcCorp) {
        this.realNcCorp = realNcCorp;
    }
    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<NewsSupplierEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<NewsSupplierEntity> detailList) {
        this.detailList = detailList;
    }
}
