package com.ejianc.business.fbxt.odd.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.odd.bean.OddSetEntity;
import com.ejianc.business.fbxt.odd.bean.ReceiveEntity;
import com.ejianc.business.fbxt.odd.service.IOddSetService;
import com.ejianc.business.fbxt.odd.service.IReceiveService;
import com.ejianc.business.fbxt.odd.vo.OddSetVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.google.gson.Gson;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包协同设置实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("oddSet")
public class OddSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOddSetService service;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IProjectApi projectApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddSetVO> saveOrUpdate(@RequestBody OddSetVO saveorUpdateVO) {
    	OddSetEntity entity = BeanMapper.map(saveorUpdateVO, OddSetEntity.class);
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        // 校验是否有接收人
        LambdaQueryWrapper<ReceiveEntity> query = new LambdaQueryWrapper<>();
        query.eq(ReceiveEntity::getSetId, saveorUpdateVO.getId());
        List<ReceiveEntity> entities =  receiveService.list(query);
        if (CollectionUtils.isNotEmpty(entities)){
            receiveService.removeByIds(entities.stream().map(ReceiveEntity::getId).collect(Collectors.toList()),true);
        }
    	service.saveOrUpdate(entity, false);
    	OddSetVO vo = BeanMapper.map(entity, OddSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 根据组织主键查询详情
     * @param orgId
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddSetVO> queryDetail(Long orgId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
    	List<OddSetEntity> list = service.queryList(queryParam,false);
    	OddSetVO vo = new OddSetVO();
    	if(CollectionUtils.isNotEmpty(list)){
            vo = BeanMapper.map(service.selectById(list.get(0).getId()), OddSetVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 根据组织主键查询详情
     * @param orgId
     */
    @RequestMapping(value = "/queryDetail2", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddSetVO> queryDetail2(Long orgId) {
        CommonResponse<OrgVO> orgVo = orgApi.getOneById(orgId);
        OddSetVO vo = new OddSetVO();
        if(!orgVo.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        if (null != orgVo.getData()) {
            if (orgVo.getData().getOrgType() == 5) {
                orgId = orgVo.getData().getParentId();
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            List<OddSetEntity> list = service.queryList(queryParam,false);
            if(CollectionUtils.isNotEmpty(list)){
                vo = BeanMapper.map(service.selectById(list.get(0).getId()), OddSetVO.class);
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddSetVO> vos) {
        service.removeByIds(vos.stream().map(OddSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddSetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<OddSetEntity> page = service.queryPage(param,false);
        IPage<OddSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 根据传入的项目主键加类型，查询为“是”的详情
     *  @param pkProject 项目来源主键
     *  @param queryType 类型：1-是否允许供应商自制发起用工单，2-是否允许供应商超量发起施工任务书,3-是否供应商需要确认后发起施工任务书
     */
    @RequestMapping(value = "/queryOddSet", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddSetVO> queryOddSet(@RequestParam String pkProject, @RequestParam Integer queryType) {
        CommonResponse<ProjectRegisterVO> projResponse = projectApi.queryProjectBySourceId(pkProject);
        if (!projResponse.isSuccess()) {
            return CommonResponse.error("查询项目信息失败！");
        }
        CommonResponse<OrgVO> response = orgApi.getOneById(projResponse.getData().getProjectDepartmentId());
        if (!response.isSuccess()) {
            return CommonResponse.error("查询组织信息失败！");
        }
        logger.info("组织信息："+new Gson().toJson(response));
        LambdaQueryWrapper<OddSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        if (1 == queryType) {
            queryWrapper.eq(OddSetEntity::getSuppOddAdd, true);
        }else if (2 == queryType) {
            queryWrapper.eq(OddSetEntity::getSuppAssbookExcess, true);
        }else if(3 == queryType){
            queryWrapper.eq(OddSetEntity::getSetConstructionAssignment, true);
        }else {
            return CommonResponse.error("不支持的查询类型！");
        }
        List<OddSetEntity> oddSetEntities = service.list(queryWrapper);
        Map<Long, OddSetEntity> map = oddSetEntities.stream().collect(Collectors.toMap(OddSetEntity::getOrgId, Function.identity(), (key1, key2) -> key1));
        String[] innerCodeArr = response.getData().getInnerCode().split("\\|");
        for (int i = innerCodeArr.length - 1; i >= 0; i--) {
            Long key = Long.valueOf(innerCodeArr[i]);
            if (map.containsKey(key)) {
                return CommonResponse.success("查询成功！", BeanMapper.map(map.get(key), OddSetVO.class));
            }
        }
        return CommonResponse.success("查询成功！", null);
    }

}
