/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.sync.api.IOddSyncApi;
import com.ejianc.business.sync.vo.OddRedirectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="odd")
public class OddBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOddService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddSyncApi oddSyncApi;
    @Autowired
    private IOddApplyService applyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u96f6\u5de5\u5ba1\u6279\uff0c\u63d0\u4ea4\u524d\u56de\u8c03\u5f00\u59cb");
        QueryParam param = new QueryParam();
        param.getParams().put("odd_id", new Parameter("eq", (Object)billId));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List oddInfoEntities = this.oddInfoService.queryList(param, false);
        for (OddInfoEntity oe : oddInfoEntities) {
            oe.setReviewMny(oe.getMny());
            oe.setReviewNum(oe.getNum());
            oe.setReviewPrice(oe.getPrice());
        }
        this.oddInfoService.saveOrUpdateBatch(oddInfoEntities);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u96f6\u5de5\u5ba1\u6279\uff0c\u63d0\u4ea4\u540e\u56de\u8c03\u5f00\u59cb");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff01---------------------------");
        this.logger.info("---------------------------baseHost\uff01---------------------------" + this.baseHost + "---------------------------------");
        if (this.baseHost.contains("9080") || this.baseHost.contains("9082")) {
            this.logger.info("---------------------------\u6570\u636e\u540c\u6b65\u81f3nc");
            OddVO oddVO = this.service.queryDetail(billId);
            com.ejianc.business.sync.vo.OddVO map = (com.ejianc.business.sync.vo.OddVO)BeanMapper.map((Object)oddVO, com.ejianc.business.sync.vo.OddVO.class);
            List oddInfoEntities = oddVO.getOddInfoEntities();
            ArrayList<com.ejianc.business.sync.vo.OddInfoVO> list = new ArrayList<com.ejianc.business.sync.vo.OddInfoVO>();
            for (OddInfoVO info : oddInfoEntities) {
                List oddRedirectEntities = info.getOddRedirectEntities();
                List redirectVO = BeanMapper.mapList((Iterable)oddRedirectEntities, OddRedirectVO.class);
                com.ejianc.business.sync.vo.OddInfoVO oddInfoVO = (com.ejianc.business.sync.vo.OddInfoVO)BeanMapper.map((Object)info, com.ejianc.business.sync.vo.OddInfoVO.class);
                oddInfoVO.setOddRedirectEntities(redirectVO);
                list.add(oddInfoVO);
            }
            map.setOddInfoEntities(list);
            this.logger.info("\u4e3b\u8868\u6765\u6e901\uff1a" + oddVO.getOddSource());
            this.logger.info("\u4e3b\u8868\u6765\u6e902\uff1a" + map.getOddSource());
            map.setOddSource(oddVO.getOddSource());
            this.logger.info("+++++++++++++++++++++++++++\u67e5\u770b\u8981\u63a8\u9001NC\u7684map\uff1a" + JSONObject.toJSONString((Object)map));
            CommonResponse response = this.oddSyncApi.syncOdd(map);
            this.logger.info("+++++++++++++++++++++++++++\u6570\u636e\u540c\u6b65\u81f3nc:" + JSONObject.toJSONString((Object)response));
            if (response.isSuccess()) {
                com.ejianc.business.sync.vo.OddVO data;
                OddEntity entity = (OddEntity)((Object)this.service.selectById(billId));
                if (entity.getSourceType() == 2) {
                    this.service.sendMsg(entity, BillStatusEnum.\u5df2\u786e\u8ba4.getCode());
                }
                if (CollectionUtils.isNotEmpty((Collection)(data = (com.ejianc.business.sync.vo.OddVO)response.getData()).getOddInfoEntities())) {
                    ArrayList<Object> infoEntities = new ArrayList<Object>();
                    for (com.ejianc.business.sync.vo.OddInfoVO oddInfoVO : data.getOddInfoEntities()) {
                        if (1 != oddInfoVO.getSourceType()) continue;
                        infoEntities.add(BeanMapper.map((Object)oddInfoVO, OddInfoEntity.class));
                    }
                    if (CollectionUtils.isNotEmpty(infoEntities)) {
                        this.oddInfoService.updateBatchById(infoEntities, infoEntities.size());
                    }
                }
                this.service.pushOdd(oddVO);
                return CommonResponse.success();
            }
            return CommonResponse.error((String)("\u6570\u636e\u540c\u6b65\u81f3nc\u5931\u8d25:" + response.getMsg()));
        }
        OddEntity entity = (OddEntity)((Object)this.service.selectById(billId));
        if (entity.getSourceType() == 2) {
            this.service.sendMsg(entity, BillStatusEnum.\u5df2\u786e\u8ba4.getCode());
        }
        OddVO oddVO = this.service.queryDetail(billId);
        this.service.pushOdd(oddVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (this.baseHost.contains("9080") || this.baseHost.contains("9082")) {
            CommonResponse booleanResponse = this.oddSyncApi.syncFlag(billId);
            this.logger.debug("--------\uff1a" + booleanResponse.isSuccess());
            this.logger.debug("--------\uff1a" + booleanResponse.getData());
            if (booleanResponse.isSuccess()) {
                if (((Boolean)booleanResponse.getData()).booleanValue()) {
                    return CommonResponse.error((String)booleanResponse.getMsg());
                }
                CommonResponse delResponse = this.oddSyncApi.delSync(billId);
                this.logger.debug("+++++++\uff1a" + delResponse.isSuccess());
                this.logger.debug("+++++++\uff1a" + delResponse.getData());
                if (delResponse.isSuccess()) {
                    OddEntity entity = (OddEntity)((Object)this.service.selectById(billId));
                    if (entity.getSourceType() == 2) {
                        this.service.sendMsg((OddEntity)((Object)this.service.selectById(billId)), BillStatusEnum.\u5f85\u786e\u8ba4.getCode());
                    }
                    this.service.delPcaOdd((OddVO)BeanMapper.map((Object)((Object)entity), OddVO.class));
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(BaseEntity::getId, (Object)billId);
                    updateWrapper.set(OddEntity::getConfirmState, (Object)0);
                    this.service.update((Wrapper)updateWrapper);
                    return CommonResponse.success();
                }
                return CommonResponse.error((String)delResponse.getMsg());
            }
            return CommonResponse.error((String)booleanResponse.getMsg());
        }
        OddEntity entity = (OddEntity)((Object)this.service.selectById(billId));
        if (entity.getSourceType() == 2) {
            this.service.sendMsg((OddEntity)((Object)this.service.selectById(billId)), BillStatusEnum.\u5f85\u786e\u8ba4.getCode());
        }
        this.service.delPcaOdd((OddVO)BeanMapper.map((Object)((Object)entity), OddVO.class));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(OddEntity::getConfirmState, (Object)0);
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

