package com.ejianc.business.fbxt.grap.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 进度台账实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("sumGrap")
public class SumGrapController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ISumGrapService service;

    @Autowired
    private IGrapService grapService;

    @Autowired
    private IOrgApi orgApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SumGrapVO> saveOrUpdate(@RequestBody SumGrapVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SumGrapVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SumGrapVO> vos) {
        List<Long> ids = vos.stream().map(SumGrapVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        // 修改对应进度计量单为自由态
        LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(GrapEntity::getSumGrapId, ids);
        updateWrapper.set(GrapEntity::getBillState, 0);
        updateWrapper.set(GrapEntity::getSumGrapId, null);
        grapService.update(updateWrapper);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SumGrapVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 权限隔离 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
//            param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                if (param.getParams().containsKey("realCorpId")) {
                    param.getParams().put("cropId", new Parameter(QueryParam.IN, param.getParams().get("realCorpId")));
                } else {
                    param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                            InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                }
            }
        }
        // 审核金额
        if(param.getParams().containsKey("sumApproveMny")){
            param.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.UNCOMMITED_STATE.getBillStateCode()));
        }
        IPage<SumGrapEntity> page = service.queryPage(param,false);
        IPage<SumGrapVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SumGrapVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<SumGrapVO>> res = this.queryList(param);
        List<SumGrapVO> list = new ArrayList<>();
        if(res.isSuccess() && res.getData() != null && CollectionUtils.isNotEmpty(res.getData().getRecords())){
            list = res.getData().getRecords();
            list.forEach(vo -> {
                String useStateName = "";
                if(vo.getUseState() != null && vo.getUseState() == 1) {
                    useStateName = "是";
                } else {
                    useStateName = "否";
                }
                vo.setUseStateName(useStateName);
                if(vo.getBillState() == BillStateEnum.UNCOMMITED_STATE.getBillStateCode()){
                    vo.setSumApproveMny(null);
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sumGrap-export.xlsx", beans, response);
    }

    /**
     * @Description syncUseState 同步NC已结算状态
     */
    @RequestMapping(value = "/syncUseState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse syncUseState(HttpServletRequest request) {
        return service.syncUseState(request);
    }

    /**
     * 供方确认回写供方确认状态
     *
     * @return
     */
    @GetMapping("/sumGrapUpdateState")
    @ResponseBody
    public CommonResponse<String> sumGrapUpdateState(@RequestParam(value = "id") String id,@RequestParam(value = "confirmFlag") Integer confirmFlag) {
        return  service.confirmFlagUpdate(id,confirmFlag);
    }


    @RequestMapping(value = "/handlePrintDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody JSONObject jsonObject){
        logger.info("日志台账打印模板数据处理，入参--{}",jsonObject.toString(SerializerFeature.PrettyFormat,SerializerFeature.WriteMapNullValue));
        JSONObject detailJson = jsonObject.getJSONObject("detailJson");
        logger.info("日志台账打印模板数据处理，detailJson--{}", JSON.toJSONString(detailJson,SerializerFeature.PrettyFormat,SerializerFeature.WriteMapNullValue));
        if(null == detailJson){
            return CommonResponse.success();
        }
        service.handlePrintDetail(detailJson);
        logger.info("处理完成，detailJson--{}", JSON.toJSONString(detailJson,SerializerFeature.PrettyFormat,SerializerFeature.WriteMapNullValue));
        return CommonResponse.success(detailJson);
    }
}
