package com.ejianc.business.fbxt.grap.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.grap.bean.GrapEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapDetailEntity;
import com.ejianc.business.fbxt.grap.bean.SumGrapEntity;
import com.ejianc.business.fbxt.grap.service.IGrapService;
import com.ejianc.business.fbxt.grap.service.ISumGrapService;
import com.ejianc.business.fbxt.grap.vo.SumGrapVO;
import com.ejianc.business.fbxt.util.DecimalUtils;
import com.ejianc.business.sync.api.IGrapSyncApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("sumGrap") 
public class SumGrapBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IGrapService grapService;

	@Autowired
	private ISumGrapService sumGrapService;

	@Autowired
	private IGrapSyncApi grapSyncApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("--> 进度台账提交开始,id:"+billId);
		LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(GrapEntity::getSumGrapId, billId);
		updateWrapper.set(GrapEntity::getUseState, 1);
		grapService.update(updateWrapper);
		logger.info("--> 审批数量及审批金额初始化");
		SumGrapEntity entity = sumGrapService.selectById(billId);
		List<SumGrapDetailEntity> detailList = entity.getDetailList();
		Map<Long, SumGrapDetailEntity> parentMap = new HashMap<>();// 非末级Map，key-id，value-非末级VO
		for(SumGrapDetailEntity vo : detailList){
			if(vo.getLeafFlag() == 0 && !parentMap.containsKey(vo.getId())){
				parentMap.put(vo.getId(), vo);
			}
		}
		BigDecimal sumApproveMny = null;// 汇总审批金额
		BigDecimal price =  null;// 单价
		BigDecimal approveMny = null;// 审批金额
		for(SumGrapDetailEntity detail : detailList){
			price =  null;
			approveMny = null;
			detail.setApproveNum(detail.getOldNum());
			price = detail.getPrice() != null ? detail.getPrice() :
					parentMap.get(detail.getParentId()) != null ? parentMap.get(detail.getParentId()).getPrice() : null;
			approveMny = DecimalUtils.multiply(detail.getOldNum(), price);
			detail.setApproveMny(approveMny);
			if(detail.getLeafFlag() == 0){
				sumApproveMny = DecimalUtils.add(sumApproveMny, approveMny);
			}
		}
		entity.setSumApproveMny(sumApproveMny);
		sumGrapService.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("--> 终审审核前回调");
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--> 进度台账审核开始,id:"+billId);
		// 审批通过，同步至NC
		SumGrapEntity entity = sumGrapService.selectById(billId);
		com.ejianc.business.sync.vo.SumGrapVO sumGrapVO = BeanMapper.map(entity, com.ejianc.business.sync.vo.SumGrapVO.class);
		CommonResponse<String> response = grapSyncApi.syncImg(sumGrapVO);
		logger.info("--> 推送NC中间表:" + JSONObject.toJSONString(response));
		if(!response.isSuccess()){
			grapSyncApi.delSyncImg(billId);// 清空中间表
			return CommonResponse.error(response.getMsg());
		}
		// 修改进度计量已汇总
		LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(GrapEntity::getSumGrapId, billId);
		updateWrapper.set(GrapEntity::getUseState, 1);
		grapService.update(updateWrapper);
		sumGrapService.pushSumGrap(BeanMapper.map(entity, SumGrapVO.class));
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--> 进度台账弃审前事件");
		SumGrapEntity entity = sumGrapService.selectById(billId);
		if(entity.getHistoryFlag() != null && entity.getHistoryFlag() == 1){
			return CommonResponse.error("历史数据，不允许撤回！");
		}
		CommonResponse<Integer> response = grapSyncApi.getSyncImg(billId);
		logger.info("--> NC中间表是否已结算:" + JSONObject.toJSONString(response));
		if(!response.isSuccess()){
			return CommonResponse.error("网络异常，请稍后重试！");
		}
		if(response.getData() >  0){
			LambdaUpdateWrapper<SumGrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(SumGrapEntity::getId, billId);
			updateWrapper.set(SumGrapEntity::getUseState, 1);
			sumGrapService.update(updateWrapper);
			return CommonResponse.error("NC已结算，不允许弃审！");
		}
		sumGrapService.delSumGrap(BeanMapper.map(entity, SumGrapVO.class));
		LambdaUpdateWrapper<SumGrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(SumGrapEntity::getId, billId);
		updateWrapper.set(SumGrapEntity::getConfirmFlag, 0);
		sumGrapService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--> 进度台账撤回开始");
		CommonResponse<String> delRes = grapSyncApi.delSyncImg(billId);
		logger.info("--> 删除NC中间表:" + JSONObject.toJSONString(delRes));
		if(!delRes.isSuccess()){
			return CommonResponse.error("网络异常，请稍后重试！");
		}
		// 修改进度计量未汇总
		LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(GrapEntity::getSumGrapId, billId);
		updateWrapper.set(GrapEntity::getUseState, 0);
		grapService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("--> 有审批流的撤回前事件");
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("--> 有审批流的撤回后事件");
		// 修改进度计量未汇总
		LambdaUpdateWrapper<GrapEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(GrapEntity::getSumGrapId, billId);
		updateWrapper.set(GrapEntity::getUseState, 0);
		grapService.update(updateWrapper);
		return CommonResponse.success();
	}

}
