package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.enums.OutTypeEnum;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 申请实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("apply")
public class ApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IApplyService applyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO applyVO) {
    	ApplyVO vo = applyService.insertOrUpdate(applyVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @RequestMapping(value = "/getBaseInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> getBaseInfo(@RequestParam("orgId") String orgId, @RequestParam("openId") String openId) {
        ApplyVO applyVO = applyService.getBaseInfo(orgId, openId);
        return CommonResponse.success("获取默认信息成功！", applyVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
        ApplyVO vo = applyService.selectDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 扫码后获取当前单据操作权限
     * @return
     */
    @RequestMapping(value = "/getPower", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> getPower(@RequestParam("id") Long id, @RequestParam("openId") String openId) {
        return CommonResponse.success("扫码后获取当前单据操作权限成功", applyService.getPower(id, openId));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        applyService.removeByIds(vos.stream().map(ApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ApplyEntity> page = applyService.queryPage(param,false);
        IPage<ApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryReportList 查询台账列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryReportList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 组织权限 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Page<ApplyReportVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ApplyReportVO> list = applyService.queryReportPage(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }


    @RequestMapping(value = "/excelExportReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<JSONObject> res = this.queryReportList(param);
        List<ApplyReportVO> list = new ArrayList<>();
        if(res.getData() != null){
            JSONArray jsonArray = res.getData().getJSONArray("records");
            list = JSONObject.parseArray(jsonArray.toJSONString(),  ApplyReportVO.class);
        }
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo -> {
                vo.setOpStatusName(OutTypeEnum.getEnumByCode(vo.getOutType()).getDescription());
                vo.setOutTypeName(OpStatusEnum.getEnumByCode(vo.getOpStatus()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("applyReportExport.xlsx", beans, response);
    }
}
