package com.ejianc.business.op.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OpStatusEnum {
    TEMP_SAVE(0, "暂存"),
    SAVE(1, "保存"),
    APPROVING(2, "审批中"),
    WAIT_CHECK(3, "待核验"),
    WAIT_CONFIRM(4, "待确认"),
    REFUSE_CHECK(5, "核验不通过"),
    OUT(6, "已出门"),
    REFUSE_CONFIRM(7, "确认不通过"),
    EXPIRE(8, "已过期");

    private final Integer code;
    private final String description;
    private static Map<Integer, OpStatusEnum> enumMap = new HashMap();

    private OpStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static OpStatusEnum getEnumByCode(Integer code) {
        return (OpStatusEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(OpStatusEnum.class).stream().collect(Collectors.toMap(OpStatusEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
