package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.bean.ConfigCheckerEntity;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.bean.WechatUserEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.mapper.ApplyMapper;
import com.ejianc.business.op.service.*;
import com.ejianc.business.op.util.HttpTookit;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 申请实体
 *
 * @author generator
 *
 */
@Service("applyService")
public class ApplyServiceImpl extends BaseServiceImpl<ApplyMapper, ApplyEntity> implements IApplyService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "CSCEC5B_OP_APPLY";

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IConfigService configService;

    @Autowired
    private IConfigCheckerService configCheckerService;

    @Autowired
    private IGuardUserService guardUserService;

    @Autowired
    private IWechatUserService wechatUserService;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public ApplyVO getBaseInfo(String orgId, String openid) {
        ApplyEntity apply = new ApplyEntity();
        ProjectRegisterVO projectRegisterVO = null;
        //五局老数据传的orgId可能是NC项目主键
        CommonResponse<ProjectRegisterVO> response = projectApi.queryProjectBySourceId(orgId);
        if (response.isSuccess() && null != response.getData() && null != response.getData().getId()) {
            projectRegisterVO = response.getData();
        } else {
            CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(orgId);
            projectRegisterVO = commonResponse.getData();
        }

        apply.setOrgId(projectRegisterVO.getProjectDepartmentId());
        apply.setProjectId(projectRegisterVO.getId());
        apply.setProjectName(projectRegisterVO.getName());
        apply.setBranchCorpId(projectRegisterVO.getRealCorpId());
        apply.setBranchCorpName(projectRegisterVO.getRealCorpName());

        CommonResponse<OrgVO> responseOrg = iOrgApi.getOneById(apply.getOrgId());
        apply.setParentOrgId(responseOrg.getData().getParentId());
        apply.setOrgName(responseOrg.getData().getName());


        apply.setOpenId(openid);

        LambdaQueryWrapper<WechatUserEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(WechatUserEntity::getBindStatus, BooleanStatusEnum.是.getCode());
        wrapper.eq(WechatUserEntity::getOpenId, openid);
        WechatUserEntity wechatUserEntity = wechatUserService.getOne(wrapper, false);
        if (null != wechatUserEntity) {
            apply.setInsideFlag(BooleanStatusEnum.是.getCode());
            apply.setUserId(wechatUserEntity.getUserId());
        }else{
            LambdaQueryWrapper<GuardUserEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(GuardUserEntity::getBindStatus, BooleanStatusEnum.是.getCode());
            queryWrapper.eq(GuardUserEntity::getOpenId, openid);
            GuardUserEntity guardUserEntity = guardUserService.getOne(queryWrapper, false);
            if (null != guardUserEntity) {
                apply.setGuardUserId(guardUserEntity.getId());
            }
            apply.setInsideFlag(BooleanStatusEnum.否.getCode());
        }

        LambdaQueryWrapper<ApplyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ApplyEntity::getOrgId, apply.getOrgId());
        queryWrapper.eq(ApplyEntity::getOpenId, openid);
        queryWrapper.orderByDesc(ApplyEntity::getCreateTime);
        List<ApplyEntity> applyList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(applyList)) {
            apply.setApplyUser(applyList.get(0).getApplyUser());
            apply.setApplyDept(applyList.get(0).getApplyDept());
            apply.setTel(applyList.get(0).getTel());
        }
        return BeanMapper.map(apply, ApplyVO.class);
    }

    @Override
    public ApplyVO insertOrUpdate(ApplyVO applyVO) {
        ApplyEntity entity = BeanMapper.map(applyVO, ApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            ApplyEntity dbEntity = selectById(applyVO.getId());
            if(OpStatusEnum.WAIT_CHECK.getCode().equals(dbEntity.getOpStatus())){
                return checkSave(applyVO);
            }else if(OpStatusEnum.WAIT_CONFIRM.getCode().equals(dbEntity.getOpStatus())){
                return confirmSave(applyVO);
            }
        }
        saveOrUpdate(entity, false);
        ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        return vo;
    }

    private ApplyVO checkSave(ApplyVO applyVO){
        if(null == applyVO.getId()){
            throw new BusinessException("所传单据id不能为空！");
        }
        LambdaQueryWrapper<WechatUserEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(WechatUserEntity::getOpenId, applyVO.getCheckerOpenId());
        wrapper.eq(WechatUserEntity::getBindStatus, BooleanStatusEnum.是.getCode());
        WechatUserEntity wechatUserEntity = wechatUserService.getOne(wrapper, false);
        if(null == wechatUserEntity){
            throw new BusinessException("当前OPENID未绑定内部人员！");
        }

        LambdaUpdateWrapper<ApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ApplyEntity::getId, applyVO.getId());
        updateWrapper.set(ApplyEntity::getCheckerOpenId, applyVO.getCheckerOpenId());
        updateWrapper.set(ApplyEntity::getCheckNote, applyVO.getCheckNote());
        updateWrapper.set(ApplyEntity::getCheckTime, applyVO.getCheckTime());
        updateWrapper.set(ApplyEntity::getCheckerId, wechatUserEntity.getUserId());
        updateWrapper.set(ApplyEntity::getCheckerName, applyVO.getCheckerName());
        updateWrapper.set(ApplyEntity::getOpStatus, applyVO.getOpStatus());
        ConfigVO configVO = configService.queryDetailByOrgId(applyVO.getOrgId());
        if (null != configVO && BooleanStatusEnum.是.getCode().equals(configVO.getGuardStatus())
                && OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyVO.getOpStatus())) {
            updateWrapper.set(ApplyEntity::getOpStatus, OpStatusEnum.OUT.getCode());
        }

        update(updateWrapper);

        return selectDetail(applyVO.getId());
    }

    private ApplyVO confirmSave(ApplyVO applyVO){
        if(null == applyVO.getId()){
            throw new BusinessException("所传单据id不能为空！");
        }
        LambdaQueryWrapper<GuardUserEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(GuardUserEntity::getOpenId, applyVO.getConfirmerOpenId());
        wrapper.eq(GuardUserEntity::getBindStatus, BooleanStatusEnum.是.getCode());
        GuardUserEntity guardUserEntity = guardUserService.getOne(wrapper, false);
        if(null == guardUserEntity){
            throw new BusinessException("当前OPENID未绑定门岗人员！");
        }

        LambdaUpdateWrapper<ApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ApplyEntity::getId, applyVO.getId());
        updateWrapper.set(ApplyEntity::getConfirmerOpenId, applyVO.getConfirmerOpenId());
        updateWrapper.set(ApplyEntity::getConfirmNote, applyVO.getConfirmNote());
        updateWrapper.set(ApplyEntity::getConfirmTime, applyVO.getConfirmTime());
        updateWrapper.set(ApplyEntity::getConfirmerId, guardUserEntity.getId());
        updateWrapper.set(ApplyEntity::getConfirmerName, applyVO.getConfirmerName());
        updateWrapper.set(ApplyEntity::getOpStatus, applyVO.getOpStatus());

        update(updateWrapper);

        return selectDetail(applyVO.getId());
    }

    @Override
    public ApplyVO selectDetail(Long id) {
        ApplyEntity applyEntity = selectById(id);
        if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            Integer lasttime = Integer.parseInt(baseMapper.selectCfgUrl("lasttime"));
            Calendar calendar = new GregorianCalendar();
            calendar.setTime(applyEntity.getCheckTime());
            calendar.add(calendar.MINUTE, lasttime);
            if (1 == new Date().compareTo(calendar.getTime())) {
                applyEntity.setOpStatus(OpStatusEnum.EXPIRE.getCode());
                updateById(applyEntity);
            }
        }
        ApplyVO applyVO = BeanMapper.map(applyEntity, ApplyVO.class);
        ConfigVO configVO = configService.queryDetailByOrgId(applyEntity.getOrgId());
        applyVO.setPhotoStatus((null == configVO || null == configVO.getPhotoStatus()) ? 0 :configVO.getPhotoStatus());
        return applyVO;
    }

    @Override
    public Boolean getPower(Long id, String openId) {
        ApplyEntity applyEntity = selectById(id);
        if (OpStatusEnum.WAIT_CHECK.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper<ConfigCheckerEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ConfigCheckerEntity::getProjectId, applyEntity.getProjectId());
            wrapper.eq(ConfigCheckerEntity::getUserId, InvocationInfoProxy.getUserid());
            return configCheckerService.count(wrapper) > 0;
        } else if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper<GuardUserEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(GuardUserEntity::getProjectId, applyEntity.getProjectId());
            wrapper.eq(GuardUserEntity::getOpenId, openId);
            return guardUserService.count(wrapper) > 0;
        } else {
            throw new BusinessException("该单据状态无扫码结果");
        }
    }

    @Override
    public ApplyVO createQRCode(Long id) {
        String url = "http://111.8.52.138:9000/el/op/wechat/getAccessroken?code=1";
//        String accessroken =  null;
//        if(null == redisTemplate.opsForValue().get("op_access_token")){
//            accessroken = weChatUtil.getAccesstoken();
//            if(!StringUtils.isEmpty(accessroken)){
//                redisTemplate.opsForValue().set("op_access_token", accessroken, 90, TimeUnit.MINUTES);
//            }
//            logger.info("获取accessroken:"+accessroken);
//        }else{
//            accessroken = redisTemplate.opsForValue().get("op_access_token").toString();
//            logger.info("获取accessroken:=====" + accessroken);
//        }
        String accessroken = null;
        try {
            String responseStr = HttpTookit.get(url, null);
            JSONObject json = JSONObject.parseObject(responseStr);
            if("200".equals(json.get("code").toString())){
                accessroken = String.valueOf(json.getString("body"));
            }else{
                throw new BusinessException("获取access_token异常");
            }
        } catch (Exception e) {
            logger.info("IOException 异常"+e.getMessage());
            throw new BusinessException("获取access_token异常");
        }


        String baseAddr = null;
        if (baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        }else if(baseHost.contains("9082")){
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        }else if(baseHost.contains("9080")){
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        ApplyEntity applyEntity = selectById(id);
        String path = "permit/card";
        String multipartFile =  weChatUtil.createShortQRCodeStr(path, String.valueOf(id), applyEntity.getBillCode(), accessroken);
        applyEntity.setOpStatus(OpStatusEnum.WAIT_CHECK.getCode());
        applyEntity.setQrcode(baseAddr + dealImg(multipartFile, applyEntity));
        saveOrUpdate(applyEntity, false);
        return BeanMapper.map(applyEntity, ApplyVO.class);
    }

    @Override
    public List<ApplyReportVO> queryReportPage(Page<ApplyReportVO> page, QueryWrapper wrapper) {
        return baseMapper.queryReportPage(page, wrapper);
    }

    /**
     * 上传图片
     * @return
     */
    private String dealImg(String file, ApplyEntity applyEntity){
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202209000018");
        attachmentVO.setSourceId(String.valueOf(applyEntity.getId()));
        attachmentVO.setSourceType("EJCBT202209000018");
        attachmentVO.setFileList(Arrays.asList(file));
        logger.info(JSON.toJSONString(attachmentVO));
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentVO);
        logger.info("图片列表数据前:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return listCommonResponse.getData().get(0).getFilePath();
        }
        return null;
    }
}
