/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.vo.GuardUserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"guardUser"})
public class GuardUserController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IGuardUserService guardUserService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GuardUserVO> saveOrUpdate(@RequestBody GuardUserVO guardUserVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)this.guardUserService.insertOrUpdate(guardUserVO)));
    }

    @RequestMapping(value={"/updateClose"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateClose(@RequestParam(value="id") Long id, @RequestParam(value="closeStatus") Integer closeStatus) {
        GuardUserEntity guardUser = (GuardUserEntity)((Object)this.guardUserService.selectById(id));
        guardUser.setCloseStatus(closeStatus);
        this.guardUserService.updateById((Object)guardUser);
        return CommonResponse.success((String)"\u66f4\u65b0\u542f\u7528\u505c\u7528\u6210\u529f");
    }

    @RequestMapping(value={"/deleteById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> deleteById(Long id) {
        this.guardUserService.removeById(id, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GuardUserVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        IPage page = this.guardUserService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GuardUserVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/unBindWechat"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GuardUserVO> unBindWechat(Long id) {
        GuardUserEntity guardUserEntity = (GuardUserEntity)((Object)this.guardUserService.selectById(id));
        guardUserEntity.setBindStatus(0);
        guardUserEntity.setOpenId(null);
        this.guardUserService.updateById((Object)guardUserEntity);
        return CommonResponse.success((String)"\u95e8\u5c97\u7528\u6237\u89e3\u7ed1\u6210\u529f", (Object)BeanMapper.map((Object)((Object)guardUserEntity), GuardUserVO.class));
    }

    @RequestMapping(value={"/queryGuarderByProj"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryGuarderByProj(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(GuardUserEntity::getCloseStatus, (Object)BooleanStatusEnum.\u5426.getCode());
        queryWrapper.eq(GuardUserEntity::getProjectId, (Object)projectId);
        List guardUserEntities = this.guardUserService.list((Wrapper)queryWrapper);
        String nameStr = null;
        if (CollectionUtils.isNotEmpty((Collection)guardUserEntities)) {
            List nameList = guardUserEntities.stream().map(GuardUserEntity::getName).collect(Collectors.toList());
            nameStr = StringUtils.join(nameList, (String)",");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4e0b\u95e8\u5c97\u4eba\u5458\u6210\u529f", nameStr);
    }
}

