/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.service.impl;

import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="apply")
public class ApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IApplyService applyService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeSubmitProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterSubmitProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        applyEntity.setOpStatus(OpStatusEnum.APPROVING.getCode());
        this.applyService.saveOrUpdate((Object)applyEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeHasBpmBack billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterHasBpmBack billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        applyEntity.setOpStatus(OpStatusEnum.REFUSE.getCode());
        this.applyService.saveOrUpdate((Object)applyEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        this.logger.info("beforeInApprovalBack billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeApprovalProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.applyService.createQRCode(billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("beforeAbstainingProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        applyEntity.setOpStatus(OpStatusEnum.SAVE.getCode());
        this.applyService.saveOrUpdate((Object)applyEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterAbstainingProcessor billId " + billId + "state  " + state + "billTypeCode" + billTypeCode);
        return CommonResponse.success();
    }
}

