/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.mapper.ConfigMapper;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.util.HttpTookit;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="configService")
public class ConfigServiceImpl
extends BaseServiceImpl<ConfigMapper, ConfigEntity>
implements IConfigService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectApi projectApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public ConfigVO createQRCode(Long orgId) {
        CommonResponse commonResponse = this.projectApi.queryProjectByProjectDepartmentId(String.valueOf(orgId));
        String url = "http://172.30.201.151:9000/el/op/wechat/getAccessroken?code=1";
        String accessroken = null;
        try {
            String responseStr = HttpTookit.get(url, null);
            JSONObject json = JSONObject.parseObject((String)responseStr);
            if (!"200".equals(json.get((Object)"code").toString())) {
                throw new BusinessException("\u83b7\u53d6access_token\u5f02\u5e38");
            }
            accessroken = String.valueOf(json.getString("body"));
        }
        catch (Exception e) {
            this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
            throw new BusinessException("\u83b7\u53d6access_token\u5f02\u5e38");
        }
        String baseAddr = null;
        if (this.baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        } else if (this.baseHost.contains("9082")) {
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        } else if (this.baseHost.contains("9080")) {
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        ConfigEntity config = new ConfigEntity();
        config.setId(IdWorker.getId());
        config.setProjectId(((ProjectRegisterVO)commonResponse.getData()).getId());
        config.setOrgId(orgId);
        config.setCloseStatus(BooleanStatusEnum.\u5426.getCode());
        config.setGuardStatus(BooleanStatusEnum.\u5426.getCode());
        config.setPhotoStatus(BooleanStatusEnum.\u5426.getCode());
        String path = "permit/card?orgId=" + orgId;
        String multipartFile = this.weChatUtil.createLongQRCodeStr(path, String.valueOf(orgId), accessroken);
        config.setQrcode(baseAddr + this.dealImg(multipartFile, config));
        this.saveOrUpdate((Object)config, false);
        return (ConfigVO)((Object)BeanMapper.map((Object)((Object)config), ConfigVO.class));
    }

    @Override
    public ConfigVO queryDetailByOrgId(Long orgId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConfigEntity::getOrgId, (Object)orgId);
        return (ConfigVO)((Object)BeanMapper.map((Object)this.getOne((Wrapper)queryWrapper, false), ConfigVO.class));
    }

    private String dealImg(String file, ConfigEntity configEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202209000017");
        attachmentVO.setSourceId(String.valueOf(configEntity.getId()));
        attachmentVO.setSourceType("EJCBT202209000017");
        attachmentVO.setFileList(Arrays.asList(file));
        this.logger.info(JSON.toJSONString((Object)attachmentVO));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

