package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.bean.WechatUserEntity;
import com.ejianc.business.op.enums.WechatErrorEnum;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.service.IWechatUserService;
import com.ejianc.business.op.util.MD5Utils;
import com.ejianc.business.op.util.PasswordUtils;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.UserOpVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DESUtils;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("wechat")
public class WechatController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private IThirdSystemApi thirdSystemApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IWechatUserService wechatUserService;

    @Autowired
    private IGuardUserService guardUserService;

    @Autowired
    private IUserApi userApi;


    /**
     * @Description openId 获取openid
     * @param code
     */
    @RequestMapping(value = "/openId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> openId(@RequestParam("code") String code) {
        return CommonResponse.success(weChatUtil.oauth2GetOpenid(code));
    }

    /**
     * @Description anaLogin 模拟登录
     * @param request
     */
    private String anaLogin(HttpServletRequest request) {
        String authority = "";
        CommonResponse<ThirdSystemVO> thirdSystemVO = thirdSystemApi.getOneByCode("ZJWJ");
        logger.info("thirdSystemVO " + JSONObject.toJSONString(thirdSystemVO.getData()));
        try {
            if (thirdSystemVO.isSuccess() && thirdSystemVO.getData() != null) {
                Map<String, Object> params = new HashMap<>();
                params.put("tenantId", thirdSystemVO.getData().getTenantId());
                logger.info("baseHost " + baseHost);
                String back = HttpTookit.get(baseHost + "ejc-idm-web/user/context/getBytenantid", params, request);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if (jsonBack.get("data") != null) {
                    JSONObject data = (JSONObject) jsonBack.get("data");
                    logger.info("data  " + data.toJSONString());
                    if (data.get("userContext") != null) {
                        JSONObject userContext = (JSONObject) data.get("userContext");
                        authority = "userType=" + userContext.getString("userType") + ";userCode="
                                + userContext.getString("userCode") +
                                // ";userName="+userContext.getString("userName")
                                // +
                                ";orgId=" + userContext.getString("orgId") +
                                // ";orgName="+userContext.getString("orgName")
                                // +
                                ";tenantid=" + userContext.getString("tenantid") + ";token="
                                + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints")
                                + ";u_usercode=" + userContext.getString("u_usercode") + ";userId="
                                + userContext.getString("userId");
                    }
                }
            } else {
                throw new BusinessException("根据系统code：ZJWJ获取第三方系统信息失败");
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
        logger.info("anaLogin" + authority);
        return authority;
    }

    /**
     * @Description realLogin 内部人员登录
     * @param userVO
     */
    private String realLogin(UserVO userVO) {
        String authority = "";
       JSONObject jsonObject = new JSONObject();
        jsonObject.put("loginName", DESUtils.encrypt(userVO.getUserCode()));
        jsonObject.put("password", userVO.getPassword());
        jsonObject.put("needResolvePwd", false);
        try {
            String  back = HttpTookit.postByJson(baseHost + "ejc-idm-web/user/context/get", jsonObject.toJSONString());
            JSONObject jsonBack = JSONObject.parseObject(back);
            if (jsonBack.get("data") != null) {
                JSONObject data = (JSONObject) jsonBack.get("data");
                logger.info("data  " + data.toJSONString());
                if (data.get("userContext") != null) {
                    JSONObject userContext = (JSONObject) data.get("userContext");
                    authority = "userType=" + userContext.getString("userType") + ";userCode="
                            + userContext.getString("userCode") +
                            // ";userName="+userContext.getString("userName")
                            // +
                            ";orgId=" + userContext.getString("orgId") +
                            // ";orgName="+userContext.getString("orgName")
                            // +
                            ";tenantid=" + userContext.getString("tenantid") + ";token="
                            + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints")
                            + ";u_usercode=" + userContext.getString("u_usercode") + ";userId="
                            + userContext.getString("userId");
                }
            }else{
                logger.info(back);
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
        logger.info("realLogin" + authority);
        return authority;
    }

    /**
     * @param request
     * @Description wechatlogin 登录
     */
    @RequestMapping(value = "/wechatlogin", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserOpVO> wechatlogin(@RequestBody UserOpVO userOpVO, HttpServletRequest request) {
        logger.info("wechatlogin : openid" + userOpVO.getOpenId());
        if (StringUtils.isBlank(userOpVO.getOpenId())) {
            throw new BusinessException("系统异常,未获取openid！");
        }
        LambdaQueryWrapper<WechatUserEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(WechatUserEntity::getOpenId, userOpVO.getOpenId());
        wrapper.eq(WechatUserEntity::getBindStatus, 1);
        WechatUserEntity wechatUserEntity = wechatUserService.getOne(wrapper, false);
        if (null == wechatUserEntity) {
            LambdaQueryWrapper<GuardUserEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(GuardUserEntity::getOpenId, userOpVO.getOpenId());
            queryWrapper.eq(GuardUserEntity::getBindStatus, 1);
            GuardUserEntity guardUserEntity = guardUserService.getOne(queryWrapper, false);
            if (null == guardUserEntity) {
                userOpVO.setInsideFlag(3);
                userOpVO.setAuthority(anaLogin(request));
                return CommonResponse.success("游客用户登录成功", userOpVO);
            }else if(1 == guardUserEntity.getCloseStatus()){
                return CommonResponse.error(WechatErrorEnum.该用户已停用.getCode(), "该用户已停用");
            }else{
                userOpVO.setInsideFlag(0);
                userOpVO.setGuardUserId(guardUserEntity.getId());
                userOpVO.setUserName(guardUserEntity.getUserName());
                userOpVO.setName(guardUserEntity.getName());
                userOpVO.setAuthority(anaLogin(request));
                return CommonResponse.success("门岗用户登录成功", userOpVO);
            }
        }else {
            String authority = anaLogin(request);
            RequestContextHolder.getRequestAttributes().setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(RequestContextHolder.getRequestAttributes());
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            CommonResponse<UserVO> response = userApi.findUserByUserId(wechatUserEntity.getUserId());
            if(!response.isSuccess() || null == response.getData()){
                logger.error("wechatlogin" + JSONObject.toJSONString(response));
                return CommonResponse.error(WechatErrorEnum.账号不存在.getCode(), "账号不存在");
            }
            UserVO userVO = response.getData();
            if(0 == userVO.getUserState()){
                return CommonResponse.error(WechatErrorEnum.该用户已停用.getCode(), "该用户已停用");
            }
            userOpVO.setInsideFlag(1);
            userOpVO.setUserId(userVO.getId());
            userOpVO.setUserName(userVO.getUserCode());
            userOpVO.setName(userVO.getUserName());
            userOpVO.setAuthority(realLogin(userVO));
            return CommonResponse.success("内部用户登录成功", userOpVO);
        }
    }

    @RequestMapping(value = "/bindWechat", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserOpVO> bindWechat(@RequestBody UserOpVO userOpVO, HttpServletRequest request) {
        if (StringUtils.isBlank(userOpVO.getOpenId())) {
            throw new BusinessException("系统异常,未获取openid！");
        }
        if (0 == userOpVO.getInsideFlag()) {
            return bindGuardUser(userOpVO, true, request);
        }else{
            return bindInUser(userOpVO, true, request);
        }
    }

    private CommonResponse<UserOpVO> bindGuardUser(UserOpVO userOpVO, Boolean isBind, HttpServletRequest request) {
        if(isBind){
            LambdaQueryWrapper<GuardUserEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(GuardUserEntity::getUserName, userOpVO.getUserName());
            GuardUserEntity guardUserEntity = guardUserService.getOne(wrapper, false);
            if(null == guardUserEntity){
                return CommonResponse.error(WechatErrorEnum.账号不存在.getCode(), "账号不存在");
            }
            if (!guardUserEntity.getPwd().equals(MD5Utils.getStringMD5(MD5Utils.getStringMD5(userOpVO.getPassword())))) {
                return CommonResponse.error(WechatErrorEnum.密码错误.getCode(), "密码错误");
            }
            if(1 == guardUserEntity.getCloseStatus()){
                return CommonResponse.error(WechatErrorEnum.该用户已停用.getCode(), "该用户已停用");
            }
            guardUserEntity.setBindStatus(1);
            guardUserEntity.setOpenId(userOpVO.getOpenId());
            guardUserService.updateById(guardUserEntity);
            userOpVO.setInsideFlag(0);
            userOpVO.setGuardUserId(guardUserEntity.getId());
            userOpVO.setUserName(guardUserEntity.getUserName());
            userOpVO.setName(guardUserEntity.getName());
            userOpVO.setAuthority(anaLogin(request));
            return CommonResponse.success("门岗用户绑定成功", userOpVO);
        }else{
            LambdaQueryWrapper<GuardUserEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(GuardUserEntity::getOpenId, userOpVO.getOpenId());
            GuardUserEntity guardUserEntity = guardUserService.getOne(wrapper, false);
            if(null == guardUserEntity){
                return CommonResponse.error(WechatErrorEnum.OPENID未绑定.getCode(), "该OPENID未绑定");
            }
            guardUserEntity.setBindStatus(0);
            guardUserEntity.setOpenId(null);
            guardUserService.updateById(guardUserEntity);
            return CommonResponse.success("门岗用户解绑成功", userOpVO);
        }
    }

    private CommonResponse<UserOpVO> bindInUser(UserOpVO userOpVO, Boolean isBind, HttpServletRequest request) {
        if(isBind){
            String authority = anaLogin(request);
            RequestContextHolder.getRequestAttributes().setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(RequestContextHolder.getRequestAttributes());
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            UserVO userVO = null;
            CommonResponse<UserVO> response = userApi.queryUserByUserCode(userOpVO.getUserName());
            if (!response.isSuccess() || null == response.getData()) {
                CommonResponse<UserVO> res = userApi.findByUserMobile(userOpVO.getUserName());
                if (!res.isSuccess() || null == res.getData()) {
                    logger.error("bindInUser" + JSONObject.toJSONString(response));
                    return CommonResponse.error(WechatErrorEnum.账号不存在.getCode(), "账号不存在");
                }else {
                    userVO = res.getData();
                }
            }else{
                userVO = response.getData();
            }

           String encryPassword = PasswordUtils.encodePasswordByUserCode(PasswordUtils.encodePasswordUsingSHA(userOpVO.getPassword()), userVO.getSalt(), userVO.getUserCode());
            if (!userVO.getPassword().equals(encryPassword)) {
                return CommonResponse.error(WechatErrorEnum.密码错误.getCode(), "密码错误");
            }
            if (0 == userVO.getUserState()) {
                return CommonResponse.error(WechatErrorEnum.该用户已停用.getCode(), "该用户已停用");
            }
            LambdaQueryWrapper<WechatUserEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(WechatUserEntity::getUserId, userVO.getId());
            WechatUserEntity wechatUserEntity = wechatUserService.getOne(wrapper, false);
//            if (null != wechatUserEntity && 1 == wechatUserEntity.getBindStatus()) {
//                return CommonResponse.error(WechatErrorEnum.该用户已绑定其他OPENID.getCode(), "该用户已绑定其他OPENID");
//            } else
            if (null == wechatUserEntity) {
                wechatUserEntity = new WechatUserEntity();
            }
            wechatUserEntity.setBindStatus(1);
            wechatUserEntity.setOpenId(userOpVO.getOpenId());
            wechatUserEntity.setUserId(userVO.getId());
            wechatUserService.saveOrUpdate(wechatUserEntity, false);
            userOpVO.setInsideFlag(1);
            userOpVO.setUserId(userVO.getId());
            userOpVO.setUserName(userVO.getUserCode());
            userOpVO.setName(userVO.getUserName());
            userOpVO.setAuthority(realLogin(userVO));
            return CommonResponse.success("内部用户绑定成功", userOpVO);
        } else {
            LambdaQueryWrapper<WechatUserEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(WechatUserEntity::getOpenId, userOpVO.getOpenId());
            WechatUserEntity wechatUserEntity = wechatUserService.getOne(wrapper, false);
            if (null == wechatUserEntity) {
                return CommonResponse.error(WechatErrorEnum.OPENID未绑定.getCode(), "该OPENID未绑定");
            }
            wechatUserEntity.setBindStatus(0);
            wechatUserEntity.setOpenId(null);
            wechatUserService.updateById(wechatUserEntity);
            return CommonResponse.success("内部用户解绑成功", userOpVO);
        }
    }

    @RequestMapping(value = "/unBindWechat", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserOpVO> unBindWechat(@RequestBody UserOpVO userOpVO, HttpServletRequest request) {
        if (StringUtils.isBlank(userOpVO.getOpenId())) {
            throw new BusinessException("系统异常,未获取openid！");
        }
        if (0 == userOpVO.getInsideFlag()) {
            return bindGuardUser(userOpVO, false, request);
        }else{
            return bindInUser(userOpVO, false, request);
        }
    }
}
