/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.bean.ConfigCheckerEntity;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.bean.WechatUserEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.enums.OutTypeEnum;
import com.ejianc.business.op.mapper.ApplyMapper;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.service.IConfigCheckerService;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.service.IWechatUserService;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="applyService")
public class ApplyServiceImpl
extends BaseServiceImpl<ApplyMapper, ApplyEntity>
implements IApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "CSCEC5B_OP_APPLY";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConfigService configService;
    @Autowired
    private IConfigCheckerService configCheckerService;
    @Autowired
    private IGuardUserService guardUserService;
    @Autowired
    private IWechatUserService wechatUserService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public ApplyVO getBaseInfo(String orgId, String openid) {
        LambdaQueryWrapper queryWrapper;
        ApplyEntity apply = new ApplyEntity();
        ProjectRegisterVO projectRegisterVO = null;
        CommonResponse response = this.projectApi.queryProjectBySourceId(orgId);
        if (response.isSuccess() && null != response.getData() && null != ((ProjectRegisterVO)response.getData()).getId()) {
            projectRegisterVO = (ProjectRegisterVO)response.getData();
        } else {
            CommonResponse commonResponse = this.projectApi.queryProjectByProjectDepartmentId(orgId);
            projectRegisterVO = (ProjectRegisterVO)commonResponse.getData();
        }
        apply.setOrgId(projectRegisterVO.getProjectDepartmentId());
        apply.setProjectId(projectRegisterVO.getId());
        apply.setProjectName(projectRegisterVO.getName());
        apply.setBranchCorpId(projectRegisterVO.getRealCorpId());
        apply.setBranchCorpName(projectRegisterVO.getRealCorpName());
        CommonResponse responseOrg = this.iOrgApi.getOneById(apply.getOrgId());
        apply.setParentOrgId(((OrgVO)responseOrg.getData()).getParentId());
        apply.setOrgName(((OrgVO)responseOrg.getData()).getName());
        apply.setOpenId(openid);
        apply.setOpStatus(OpStatusEnum.SAVE.getCode());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WechatUserEntity::getBindStatus, (Object)BooleanStatusEnum.\u662f.getCode());
        wrapper.eq(WechatUserEntity::getOpenId, (Object)openid);
        WechatUserEntity wechatUserEntity = (WechatUserEntity)((Object)this.wechatUserService.getOne((Wrapper)wrapper, false));
        if (null != wechatUserEntity) {
            apply.setInsideFlag(BooleanStatusEnum.\u662f.getCode());
            apply.setUserId(wechatUserEntity.getUserId());
        } else {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(GuardUserEntity::getBindStatus, (Object)BooleanStatusEnum.\u662f.getCode());
            queryWrapper.eq(GuardUserEntity::getOpenId, (Object)openid);
            GuardUserEntity guardUserEntity = (GuardUserEntity)((Object)this.guardUserService.getOne((Wrapper)queryWrapper, false));
            if (null != guardUserEntity) {
                apply.setGuardUserId(guardUserEntity.getId());
            }
            apply.setInsideFlag(BooleanStatusEnum.\u5426.getCode());
        }
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ApplyEntity::getOrgId, (Object)apply.getOrgId());
        queryWrapper.eq(ApplyEntity::getOpenId, (Object)openid);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List applyList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)applyList)) {
            apply.setApplyUser(((ApplyEntity)((Object)applyList.get(0))).getApplyUser());
            apply.setApplyDept(((ApplyEntity)((Object)applyList.get(0))).getApplyDept());
            apply.setTel(((ApplyEntity)((Object)applyList.get(0))).getTel());
        }
        return (ApplyVO)BeanMapper.map((Object)((Object)apply), ApplyVO.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApplyVO insertOrUpdate(ApplyVO applyVO) {
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)applyVO, ApplyEntity.class));
        entity.setCarNumber(StringUtils.trimToNull((String)entity.getCarNumber()));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            ApplyEntity dbEntity = (ApplyEntity)((Object)this.selectById(applyVO.getId()));
            if (OpStatusEnum.WAIT_CHECK.getCode().equals(dbEntity.getOpStatus())) {
                return this.checkSave(applyVO);
            }
            if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(dbEntity.getOpStatus())) {
                return this.confirmSave(applyVO);
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
    }

    private ApplyVO checkSave(ApplyVO applyVO) {
        if (null == applyVO.getId()) {
            throw new BusinessException("\u6240\u4f20\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WechatUserEntity::getOpenId, (Object)applyVO.getCheckerOpenId());
        wrapper.eq(WechatUserEntity::getBindStatus, (Object)BooleanStatusEnum.\u662f.getCode());
        WechatUserEntity wechatUserEntity = (WechatUserEntity)((Object)this.wechatUserService.getOne((Wrapper)wrapper, false));
        if (null == wechatUserEntity) {
            throw new BusinessException("\u5f53\u524dOPENID\u672a\u7ed1\u5b9a\u5185\u90e8\u4eba\u5458\uff01");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)applyVO.getId());
        updateWrapper.set(ApplyEntity::getCheckerOpenId, (Object)applyVO.getCheckerOpenId());
        updateWrapper.set(ApplyEntity::getCheckNote, (Object)applyVO.getCheckNote());
        updateWrapper.set(ApplyEntity::getCheckTime, (Object)applyVO.getCheckTime());
        updateWrapper.set(ApplyEntity::getCheckerId, (Object)wechatUserEntity.getUserId());
        updateWrapper.set(ApplyEntity::getCheckerName, (Object)applyVO.getCheckerName());
        updateWrapper.set(ApplyEntity::getOpStatus, (Object)applyVO.getOpStatus());
        ConfigVO configVO = this.configService.queryDetailByOrgId(applyVO.getOrgId());
        if (null != configVO && BooleanStatusEnum.\u5426.getCode().equals(configVO.getGuardStatus()) && OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyVO.getOpStatus())) {
            updateWrapper.set(ApplyEntity::getOpStatus, (Object)OpStatusEnum.OUT.getCode());
        }
        this.update((Wrapper)updateWrapper);
        return this.selectDetail(applyVO.getId());
    }

    private ApplyVO confirmSave(ApplyVO applyVO) {
        if (null == applyVO.getId()) {
            throw new BusinessException("\u6240\u4f20\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GuardUserEntity::getOpenId, (Object)applyVO.getConfirmerOpenId());
        wrapper.eq(GuardUserEntity::getBindStatus, (Object)BooleanStatusEnum.\u662f.getCode());
        GuardUserEntity guardUserEntity = (GuardUserEntity)((Object)this.guardUserService.getOne((Wrapper)wrapper, false));
        if (null == guardUserEntity) {
            throw new BusinessException("\u5f53\u524dOPENID\u672a\u7ed1\u5b9a\u95e8\u5c97\u4eba\u5458\uff01");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)applyVO.getId());
        updateWrapper.set(ApplyEntity::getConfirmerOpenId, (Object)applyVO.getConfirmerOpenId());
        updateWrapper.set(ApplyEntity::getConfirmNote, (Object)applyVO.getConfirmNote());
        updateWrapper.set(ApplyEntity::getConfirmTime, (Object)applyVO.getConfirmTime());
        updateWrapper.set(ApplyEntity::getConfirmerId, (Object)guardUserEntity.getId());
        updateWrapper.set(ApplyEntity::getConfirmerName, (Object)applyVO.getConfirmerName());
        updateWrapper.set(ApplyEntity::getOpStatus, (Object)applyVO.getOpStatus());
        this.update((Wrapper)updateWrapper);
        return this.selectDetail(applyVO.getId());
    }

    @Override
    public ApplyVO selectDetail(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            Integer lasttime = Integer.parseInt(((ApplyMapper)this.baseMapper).selectCfgUrl("lasttime"));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(applyEntity.getCheckTime());
            ((Calendar)calendar).add(12, lasttime);
            if (1 == new Date().compareTo(calendar.getTime())) {
                applyEntity.setOpStatus(OpStatusEnum.EXPIRE.getCode());
                this.updateById((Object)applyEntity);
            }
        }
        ApplyVO applyVO = (ApplyVO)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class);
        ConfigVO configVO = this.configService.queryDetailByOrgId(applyEntity.getOrgId());
        applyVO.setPhotoStatus(Integer.valueOf(null == configVO || null == configVO.getPhotoStatus() ? 0 : configVO.getPhotoStatus()));
        return applyVO;
    }

    @Override
    public Boolean getPower(Long id, String openId) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        if (OpStatusEnum.WAIT_CHECK.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ConfigCheckerEntity::getProjectId, (Object)applyEntity.getProjectId());
            wrapper.eq(ConfigCheckerEntity::getUserId, (Object)InvocationInfoProxy.getUserid());
            return this.configCheckerService.count((Wrapper)wrapper) > 0;
        }
        if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(GuardUserEntity::getProjectId, (Object)applyEntity.getProjectId());
            wrapper.eq(GuardUserEntity::getOpenId, (Object)openId);
            return this.guardUserService.count((Wrapper)wrapper) > 0;
        }
        throw new BusinessException("\u8be5\u5355\u636e\u72b6\u6001\u65e0\u626b\u7801\u7ed3\u679c");
    }

    @Override
    public ApplyVO createQRCode(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        applyEntity.setOpStatus(OpStatusEnum.WAIT_CHECK.getCode());
        this.createQRCode(applyEntity);
        this.saveOrUpdate((Object)applyEntity, false);
        return (ApplyVO)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class);
    }

    private void createQRCode(ApplyEntity applyEntity) {
        String accessroken = null;
        if (null == this.redisTemplate.opsForValue().get((Object)"op_access_token")) {
            accessroken = this.weChatUtil.getAccesstoken();
            if (!StringUtils.isEmpty((CharSequence)accessroken)) {
                this.redisTemplate.opsForValue().set((Object)"op_access_token", (Object)accessroken, 90L, TimeUnit.MINUTES);
            }
            this.logger.info("\u83b7\u53d6accessroken:" + accessroken);
        } else {
            accessroken = this.redisTemplate.opsForValue().get((Object)"op_access_token").toString();
            this.logger.info("\u83b7\u53d6accessroken:=====" + accessroken);
        }
        String baseAddr = null;
        if (this.baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        } else if (this.baseHost.contains("9082")) {
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        } else if (this.baseHost.contains("9080")) {
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        String path = "pages/newcard/newcard";
        String multipartFile = this.weChatUtil.createShortQRCodeStr(path, String.valueOf(applyEntity.getId()), applyEntity.getBillCode(), accessroken);
        applyEntity.setQrcode(baseAddr + this.dealImg(multipartFile, applyEntity));
    }

    @Override
    public List<ApplyReportVO> queryReportPage(Page<ApplyReportVO> page, QueryWrapper wrapper) {
        return ((ApplyMapper)this.baseMapper).queryReportPage(page, wrapper);
    }

    @Override
    public ApplyVO push(ApplyVO applyVO) {
        this.logger.error("apply push is " + JSONObject.toJSONString((Object)applyVO));
        if (StringUtils.isBlank((CharSequence)applyVO.getLinkUrlPc())) {
            throw new BusinessException("PC\u8054\u67e5\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)applyVO.getLinkUrlMobile())) {
            throw new BusinessException("\u79fb\u52a8\u7aef\u8054\u67e5\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserContext context = this.sessionManager.getUserContext();
        this.logger.error("apply push UserContext is " + JSONObject.toJSONString((Object)context));
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)applyVO, ApplyEntity.class));
        entity.setId(IdWorker.getId());
        entity.setCarNumber(StringUtils.trimToNull((String)entity.getCarNumber()));
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38,\u7f16\u7801\u751f\u6210\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setBillCode((String)billCode.getData());
        entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        entity.setOpStatus(OpStatusEnum.WAIT_CONFIRM.getCode());
        entity.setInsideFlag(1);
        entity.setUserId(context.getUserId());
        entity.setOutType(OutTypeEnum.OTHER.getCode());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WechatUserEntity::getUserId, (Object)context.getUserId());
        wrapper.eq(WechatUserEntity::getBindStatus, (Object)BooleanStatusEnum.\u662f.getCode());
        WechatUserEntity wechatUserEntity = (WechatUserEntity)((Object)this.wechatUserService.getOne((Wrapper)wrapper, false));
        if (null != wechatUserEntity) {
            entity.setCheckerOpenId(wechatUserEntity.getOpenId());
            entity.setOpenId(wechatUserEntity.getOpenId());
        }
        entity.setCheckTime(new Date());
        entity.setCheckerId(context.getUserId());
        entity.setCheckerName(context.getUserName());
        entity.setCheckNote("\u81ea\u52a8\u6838\u9a8c\u6210\u529f");
        this.createQRCode(entity);
        if (StringUtils.isNotBlank((CharSequence)applyVO.getSourceId()) && StringUtils.isNotBlank((CharSequence)applyVO.getSourceBillType()) && StringUtils.isNotBlank((CharSequence)applyVO.getSourceBillSourceType())) {
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(applyVO.getSourceId()), applyVO.getSourceBillType(), applyVO.getSourceBillSourceType(), String.valueOf(entity.getId()), "EJCBT202209000018", "siteImg");
        }
        this.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return vo;
    }

    private String dealImg(String file, ApplyEntity applyEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202209000018");
        attachmentVO.setSourceId(String.valueOf(applyEntity.getId()));
        attachmentVO.setSourceType("EJCBT202209000018");
        attachmentVO.setFileList(Arrays.asList(file));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

