package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.MaterialEntity;
import com.ejianc.business.op.service.IMaterialService;
import com.ejianc.business.op.vo.MaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("material")
public class MaterialController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IOrgApi iOrgApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialVO> saveOrUpdate(@RequestBody MaterialVO saveOrUpdateVO) {
        CommonResponse<List<OrgVO>> commonResponse = iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if (commonResponse.isSuccess()) {
            List<Long> orgIdList = commonResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<MaterialEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.ne(null != saveOrUpdateVO, MaterialEntity::getId, saveOrUpdateVO.getId());
            queryWrapper.in(MaterialEntity::getOrgId, orgIdList);
            queryWrapper.and(wrapper ->
                 wrapper.eq(MaterialEntity::getCode, saveOrUpdateVO.getCode())
                        .or()
                        .eq(MaterialEntity::getName, saveOrUpdateVO.getName())
            );
            if (materialService.count(queryWrapper) > 0) {
                throw new BusinessException("编码或名称重复！");
            }
        }else{
            return CommonResponse.error("根据当前组织查询本上失败");
        }
    	MaterialEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialEntity.class);
    	entity.setOrgId(InvocationInfoProxy.getOrgId());
        materialService.saveOrUpdate(entity, false);
    	MaterialVO vo = BeanMapper.map(entity, MaterialVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialVO> queryDetail(Long id) {
    	MaterialEntity entity = materialService.selectById(id);
    	MaterialVO vo = BeanMapper.map(entity, MaterialVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialVO> vos) {
        materialService.removeByIds(vos.stream().map(MaterialVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        CommonResponse<List<OrgVO>> commonResponse = iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if (commonResponse.isSuccess()) {
            List<Long> orgIdList = commonResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        }else{
            return CommonResponse.error("根据当前组织查询本上失败");
        }

        IPage<MaterialEntity> page = materialService.queryPage(param,false);
        IPage<MaterialVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/opMaterialRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> contractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        queryParam.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                CommonResponse<List<OrgVO>> commonResponse = iOrgApi.findParentsByOrgId(orgId);
                if (commonResponse.isSuccess()) {
                    List<Long> orgIdList = commonResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                    queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
                } else {
                    return CommonResponse.error("根据当前组织查询本上失败");
                }
            }else{
                return CommonResponse.error("查询条件中组织主键不能为空");
            }
        }else{
            return CommonResponse.error("查询条件不能为空");
        }
        IPage<MaterialEntity> pageData = materialService.queryPage(queryParam,false);
        IPage<MaterialVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), MaterialVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }
}
