package com.ejianc.business.op.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OutTypeEnum {
    SUB_MATERIAL(1, "分包物资"),
    RENT_OUT(2, "租赁材退场"),
    OLD_MATERIAL(3, "废旧物资处理"),
    REPAIR(4, "维修"),
    ALLOT_OUT(5, "调拨退场"),
    OTHER(6, "其他");

    private final Integer code;
    private final String description;
    private static Map<Integer, OutTypeEnum> enumMap = new HashMap();

    private OutTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static OutTypeEnum getEnumByCode(Integer code) {
        return (OutTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(OutTypeEnum.class).stream().collect(Collectors.toMap(OutTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
