package com.ejianc.business.rmat.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeEnum {

    验收单("验收单", "BT210816000000002"),
    启用单("启用单", "BT220322000000006"),// 待完善
    停用单("停用单", "BT220322000000007"),// 待完善
    退场单("退场单", "EJCBT202210000013"),
    赔偿单("赔偿单", "BT220322000000005"),// 待完善
//    租金计算单("租金计算单", "BT220322000000008"),// 待完善
    ;

    private final String name;
    private final String code;
    private static Map<String, BillTypeEnum> enumMap = new HashMap();

    private BillTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BillTypeEnum getEnumByName(String billTypeName) {
        return (BillTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeEnum.class).stream().collect(Collectors.toMap(BillTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
