package com.ejianc.business.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 租金计算单-日租
 * 
 * @author generator
 * 
 */
public class CalculateDailyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long calculateId; // 主表主键
    private Long sourceId; // 来源数据Id
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String materialSourceId; // 物资来源主键
    private String spec; // 规则/型号
    private String rentUnitId; // 计租单位id
    private String rentUnitName; // 计租单位
    private BigDecimal rentNum; // 计租数量
    private BigDecimal unitTaxPrice; // 日租单价
    private BigDecimal unitPrice; // 日租单价(无税)
    private BigDecimal stopUnitTaxPrice; // 停租单价
    private BigDecimal stopUnitPrice; // 停租单价(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal dailyRentTaxMny; // 日租租金
    private BigDecimal dailyRentMny; // 日租租金(无税)
    private BigDecimal dailyTax; // 税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 计费开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 计费结束日期
    private String useStatus; // 使用状态：0-启用，1-停用
    private Integer rentDayDate; // 租赁天数
    private String memo; // 备注
    private String unitId; // 档案单位id
    private String unitName; // 档案单位
    private BigDecimal num; // 数量
    private String realUnitId; // 实物单位id
    private String realUnitName; // 实物单位
    private BigDecimal realNum; // 实物数量
    private BigDecimal realTransScale; // 实物转换系数
    private BigDecimal rentTransScale; // 计租转换系数
    

    public Long getCalculateId() {
        return calculateId;
    }

    public void setCalculateId(Long calculateId) {
        this.calculateId = calculateId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSourceId() {
        return materialSourceId;
    }

    public void setMaterialSourceId(String materialSourceId) {
        this.materialSourceId = materialSourceId;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getRentUnitId() {
        return rentUnitId;
    }

    public void setRentUnitId(String rentUnitId) {
        this.rentUnitId = rentUnitId;
    }
    public String getRentUnitName() {
        return rentUnitName;
    }

    public void setRentUnitName(String rentUnitName) {
        this.rentUnitName = rentUnitName;
    }
    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getStopUnitTaxPrice() {
        return stopUnitTaxPrice;
    }

    public void setStopUnitTaxPrice(BigDecimal stopUnitTaxPrice) {
        this.stopUnitTaxPrice = stopUnitTaxPrice;
    }
    public BigDecimal getStopUnitPrice() {
        return stopUnitPrice;
    }

    public void setStopUnitPrice(BigDecimal stopUnitPrice) {
        this.stopUnitPrice = stopUnitPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getDailyRentTaxMny() {
        return dailyRentTaxMny;
    }

    public void setDailyRentTaxMny(BigDecimal dailyRentTaxMny) {
        this.dailyRentTaxMny = dailyRentTaxMny;
    }
    public BigDecimal getDailyRentMny() {
        return dailyRentMny;
    }

    public void setDailyRentMny(BigDecimal dailyRentMny) {
        this.dailyRentMny = dailyRentMny;
    }
    public BigDecimal getDailyTax() {
        return dailyTax;
    }

    public void setDailyTax(BigDecimal dailyTax) {
        this.dailyTax = dailyTax;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }
    public Integer getRentDayDate() {
        return rentDayDate;
    }

    public void setRentDayDate(Integer rentDayDate) {
        this.rentDayDate = rentDayDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public String getRealUnitId() {
        return realUnitId;
    }

    public void setRealUnitId(String realUnitId) {
        this.realUnitId = realUnitId;
    }
    public String getRealUnitName() {
        return realUnitName;
    }

    public void setRealUnitName(String realUnitName) {
        this.realUnitName = realUnitName;
    }
    public BigDecimal getRealNum() {
        return realNum;
    }

    public void setRealNum(BigDecimal realNum) {
        this.realNum = realNum;
    }
    public BigDecimal getRealTransScale() {
        return realTransScale;
    }

    public void setRealTransScale(BigDecimal realTransScale) {
        this.realTransScale = realTransScale;
    }
    public BigDecimal getRentTransScale() {
        return rentTransScale;
    }

    public void setRentTransScale(BigDecimal rentTransScale) {
        this.rentTransScale = rentTransScale;
    }
    
}
