package com.ejianc.business.rmat.api;

import com.ejianc.business.rmat.hystrix.TransfFlowHystrix;
import com.ejianc.business.rmat.vo.TransferFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "cscec5b-rmat-web", url="${common.env.feign-client-url}", path="cscec5b-rmat-web", fallback = TransfFlowHystrix.class)
public interface ITransfFlowApi {
    /**
     * 插入流水
     * @param vos
     * @return
     */
    @PostMapping("/transferFlow/insertFlow")
    CommonResponse<Boolean> insertFlow(@RequestBody List<TransferFlowVO> vos);

    /**
     * 删除流水
     * @param sourceIds
     * @return
     */
    @PostMapping("/transferFlow/delete")
    CommonResponse<Boolean> delFlow(@RequestBody List<Long> sourceIds,  @RequestParam Integer flowType);

}
