package com.ejianc.business.rmat.vo;

import java.util.*;
import java.math.*;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 退场申请单
 * 
 * @author generator
 * 
 */
public class ExitApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 组织ID
    private String orgSourceId; // 组织来源ID
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织ID
    private String parentOrgSourceId; // 上级组织来源ID
    private String billCode; // 单据编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 单据日期
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态
    private Integer applyState; // 关闭状态(1已关闭/0未关闭)
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectSourceId; // 项目来源ID
    private String contractId; // 合同ID
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long supplierId; // 设备供应商
    private String supplierName; // 供应商名称
    private String supplierSourceId; // 供应商来源ID
    private String materialName; // 物资名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitDate; // 止租日期
    private String exitDesc; // 退场说明    
    private Integer confirmFlag; // 确认状态0-未确认1-已确认2-已拒绝
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long confirmerId; // 确认人ID
    private Long confirmerCode; // 确认人编码
    private String confirmerName; // 确认人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date confirmDate; // 确认日期
    private String confirmDesc; // 确认说明    
    private String def1; // 
    private String def2; // 
    private String def3; // 
    private String def4; // 
    private String def5; // 
    private String commitId; // 终审人,推送供方
    private Long linkId; // 联系人ID
    private String linkName; // 联系人
    private String linkTelephone; // 联系电话
    private String confirmFlagName;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private static Map<Integer, String> confirmFlagMap = new HashMap<>();

    static {
        confirmFlagMap.put(0, "未确认");
        confirmFlagMap.put(1, "已确认");
        confirmFlagMap.put(2, "已拒绝");
    }

    public static String getConfirmFlagTxt(Integer confirmFlag) {
        return confirmFlagMap.get(confirmFlag);
    }

    private List<ExitApplyDetailVO> exitApplyDetailEntityList = new ArrayList<>();

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getApplyState() {
        return applyState;
    }

    public void setApplyState(Integer applyState) {
        this.applyState = applyState;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }
    public String getExitDesc() {
        return exitDesc;
    }

    public void setExitDesc(String exitDesc) {
        this.exitDesc = exitDesc;
    }
    public Integer getConfirmFlag() {
        return confirmFlag;
    }

    public void setConfirmFlag(Integer confirmFlag) {
        this.confirmFlag = confirmFlag;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getConfirmerId() {
        return confirmerId;
    }

    public void setConfirmerId(Long confirmerId) {
        this.confirmerId = confirmerId;
    }
    public Long getConfirmerCode() {
        return confirmerCode;
    }

    public void setConfirmerCode(Long confirmerCode) {
        this.confirmerCode = confirmerCode;
    }
    public String getConfirmerName() {
        return confirmerName;
    }

    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }
    public Date getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
    }
    public String getConfirmDesc() {
        return confirmDesc;
    }

    public void setConfirmDesc(String confirmDesc) {
        this.confirmDesc = confirmDesc;
    }
    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }
    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }
    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }
    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }
    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }
    public String getCommitId() {
        return commitId;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }
    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public List<ExitApplyDetailVO> getExitApplyDetailEntityList() {
        return exitApplyDetailEntityList;
    }

    public void setExitApplyDetailEntityList(List<ExitApplyDetailVO> exitApplyDetailEntityList) {
        this.exitApplyDetailEntityList = exitApplyDetailEntityList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public static Map<Integer, String> getConfirmFlagMap() {
        return confirmFlagMap;
    }

    public static void setConfirmFlagMap(Map<Integer, String> confirmFlagMap) {
        ExitApplyVO.confirmFlagMap = confirmFlagMap;
    }

    public String getConfirmFlagName() {
        return confirmFlagName;
    }

    public void setConfirmFlagName(String confirmFlagName) {
        this.confirmFlagName = confirmFlagName;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
}
